/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.util;

public final class RenderSize {
    private final int width;
    private final int height;

    public RenderSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean isLimited() {
        return this.width != -1 && this.height != -1;
    }

    public boolean isWidthLimited() {
        return this.width != -1;
    }

    public boolean isHeightLimited() {
        return this.height != -1;
    }

    public RenderSize smaller(RenderSize another) {
        return new RenderSize(Math.min(this.width, another.width), Math.min(this.height, another.height));
    }

    public RenderSize add(RenderSize another) {
        return new RenderSize(this.width + another.width, this.height + another.height);
    }

    public RenderSize subtract(RenderSize another) {
        return new RenderSize(this.width - another.width, this.height - another.height);
    }

    public String toString() {
        return "RenderSize[" + "width=" + this.width + "," + "height=" + this.height + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (((RenderSize)arg0).width != this.width) {
            return false;
        }
        return ((RenderSize)arg0).height == this.height;
        {
        }
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

