/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui.slot;

import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.client.gui.widgets.GuiFluidTank;
import appeng.fluids.util.IAEFluidTank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;

public class GuiFullCapFluidTank
extends GuiFluidTank {
    protected final IAEFluidTank tank;
    protected final int slot;
    protected boolean darkened = false;

    public GuiFullCapFluidTank(IAEFluidTank tank, int slot, int id, int x, int y, int w, int h) {
        super(tank, slot, id, x, y, w, h);
        this.tank = tank;
        this.slot = slot;
    }

    public GuiFullCapFluidTank(IAEFluidTank tank, int slot, int id, int x, int y, int w, int h, boolean darkened) {
        this(tank, slot, id, x, y, w, h);
        this.darkened = darkened;
    }

    public void drawContent(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        IAEFluidStack fs = this.getFluidStack();
        if (fs != null) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179140_f();
            IAEFluidStack fluid = this.tank.getFluidInSlot(this.slot);
            if (fluid != null && fluid.getStackSize() > 0L) {
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                float red = (float)(fluid.getFluid().getColor() >> 16 & 0xFF) / 255.0f;
                float green = (float)(fluid.getFluid().getColor() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(fluid.getFluid().getColor() & 0xFF) / 255.0f;
                if (this.darkened) {
                    red *= 0.4f;
                    green *= 0.4f;
                    blue *= 0.4f;
                }
                GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                TextureAtlasSprite sprite = mc.func_147117_R().func_110572_b(fluid.getFluid().getStill().toString());
                int scaledHeight = this.getHeight();
                int iconHeightRemainder = scaledHeight % 16;
                if (iconHeightRemainder > 0) {
                    this.func_175175_a(this.xPos(), this.yPos() + this.getHeight() - iconHeightRemainder, sprite, 16, iconHeightRemainder);
                }
                for (int i = 0; i < scaledHeight / 16; ++i) {
                    this.func_175175_a(this.xPos(), this.yPos() + this.getHeight() - iconHeightRemainder - (i + 1) * 16, sprite, 16, 16);
                }
            }
        }
    }
}

