/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.mmce.client.gui;

import appeng.container.slot.SlotDisabled;
import appeng.container.slot.SlotFake;
import appeng.core.localization.GuiText;
import github.kasuminova.mmce.client.gui.GuiMEItemBus;
import github.kasuminova.mmce.common.container.ContainerMEItemInputBus;
import github.kasuminova.mmce.common.network.PktMEInputBusInvAction;
import github.kasuminova.mmce.common.tile.MEItemInputBus;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiMEItemInputBus
extends GuiMEItemBus {
    private static final ResourceLocation TEXTURES_INPUT_BUS = new ResourceLocation("modularmachinery", "textures/gui/meiteminputbus.png");
    private int invActionAmount = 0;

    public GuiMEItemInputBus(MEItemInputBus te, EntityPlayer player) {
        super((Container)new ContainerMEItemInputBus(te, player));
        this.field_147000_g = 204;
    }

    private static int getAddAmount() {
        int addAmount = GuiMEItemInputBus.isShiftDown() && GuiMEItemInputBus.isControlDown() && GuiMEItemInputBus.isAltDown() ? 1000000 : (GuiMEItemInputBus.isAltDown() && GuiMEItemInputBus.isControlDown() ? 100000 : (GuiMEItemInputBus.isAltDown() && GuiMEItemInputBus.isShiftDown() ? 10000 : (GuiMEItemInputBus.isShiftDown() && GuiMEItemInputBus.isControlDown() ? 1000 : (GuiMEItemInputBus.isControlDown() ? 100 : (GuiMEItemInputBus.isShiftDown() ? 10 : 1)))));
        return addAmount;
    }

    private static List<String> getAddActionInfo() {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action", (Object[])new Object[0]));
        String addAmount = MiscUtils.formatDecimal(GuiMEItemInputBus.getAddAmount());
        if (GuiMEItemInputBus.isShiftDown() && GuiMEItemInputBus.isControlDown() && GuiMEItemInputBus.isAltDown()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase", (Object[])new Object[]{"SHIFT + CTRL + ALT", addAmount}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease", (Object[])new Object[]{"SHIFT + CTRL + ALT", addAmount}));
        } else if (GuiMEItemInputBus.isAltDown() && GuiMEItemInputBus.isControlDown()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase", (Object[])new Object[]{"CTRL + ALT", addAmount}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease", (Object[])new Object[]{"CTRL + ALT", addAmount}));
        } else if (GuiMEItemInputBus.isAltDown() && GuiMEItemInputBus.isShiftDown()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase", (Object[])new Object[]{"SHIFT + ALT", addAmount}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease", (Object[])new Object[]{"SHIFT + ALT", addAmount}));
        } else if (GuiMEItemInputBus.isShiftDown() && GuiMEItemInputBus.isControlDown()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase", (Object[])new Object[]{"SHIFT + CTRL", addAmount}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease", (Object[])new Object[]{"SHIFT + CTRL", addAmount}));
        } else if (GuiMEItemInputBus.isControlDown()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase", (Object[])new Object[]{"CTRL", addAmount}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease", (Object[])new Object[]{"CTRL", addAmount}));
        } else if (GuiMEItemInputBus.isShiftDown()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase", (Object[])new Object[]{"SHIFT", addAmount}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease", (Object[])new Object[]{"SHIFT", addAmount}));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.increase.normal", (Object[])new Object[0]));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.meiteminputbus.inv_action.decrease.normal", (Object[])new Object[0]));
        }
        return tooltip;
    }

    private static boolean isAltDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    private static boolean isControlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    private static boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.onMouseWheelEvent(x, y, i / Math.abs(i));
        }
    }

    protected void mouseWheelEvent(int x, int y, int wheel) {
    }

    protected void onMouseWheelEvent(int x, int y, int wheel) {
        Slot slot = this.getSlot(x, y);
        if (!(slot instanceof SlotFake)) {
            return;
        }
        ItemStack stack = slot.func_75211_c();
        if (stack.func_190926_b()) {
            return;
        }
        int amount = wheel < 0 ? -GuiMEItemInputBus.getAddAmount() : GuiMEItemInputBus.getAddAmount();
        int stackCount = stack.func_190916_E();
        if (amount > 0 ? stackCount + amount > slot.func_75219_a() : stackCount - amount <= 0) {
            return;
        }
        this.invActionAmount += amount;
        ClientProxy.clientScheduler.addRunnable(() -> this.sendInvActionToServer(slot.field_75222_d), 0);
    }

    public void sendInvActionToServer(int slotNumber) {
        if (this.invActionAmount == 0) {
            return;
        }
        ModularMachinery.NET_CHANNEL.sendToServer((IMessage)new PktMEInputBusInvAction(this.invActionAmount, slotNumber));
        this.invActionAmount = 0;
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.meiteminputbus.title", (Object[])new Object[0]), 8, 8, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.Config.getLocal(), 8, 24, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.StoredItems.getLocal(), 97, 24, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 93, 0x404040);
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES_INPUT_BUS);
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    protected void func_146285_a(@Nonnull ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List tooltip = this.func_191927_a(stack);
        Slot slot = this.getSlot(x, y);
        if (slot instanceof SlotFake) {
            String formattedAmount = MiscUtils.formatDecimal(stack.func_190916_E());
            String formatted = I18n.func_135052_a((String)"gui.meiteminputbus.items_marked", (Object[])new Object[]{formattedAmount});
            tooltip.add(TextFormatting.GRAY + formatted);
            tooltip.addAll(GuiMEItemInputBus.getAddActionInfo());
            I18n.func_135052_a((String)"gui.meiteminputbus.items_marked", (Object[])new Object[]{formattedAmount});
        } else if (slot instanceof SlotDisabled) {
            String formattedAmount = NumberFormat.getNumberInstance(Locale.US).format(stack.func_190916_E());
            String formatted = I18n.func_135052_a((String)"gui.meitembus.item_cached", (Object[])new Object[]{formattedAmount});
            tooltip.add(TextFormatting.GRAY + formatted);
        }
        this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }
}

