/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.client.util;

import com.cleanroommc.client.util.Vector3;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RayTraceUtils {
    public static AxisAlignedBB rotateAABB(AxisAlignedBB aaBB, EnumFacing facing) {
        Vector3 min = new Vector3(aaBB.field_72340_a, aaBB.field_72338_b, aaBB.field_72339_c).subtract(0.5);
        Vector3 max = new Vector3(aaBB.field_72336_d, aaBB.field_72337_e, aaBB.field_72334_f).subtract(0.5);
        switch (facing) {
            case SOUTH: {
                double radians = Math.toRadians(180.0);
                min.rotate(radians, new Vector3(0.0, 1.0, 0.0));
                max.rotate(radians, new Vector3(0.0, 1.0, 0.0));
                break;
            }
            case EAST: {
                double radians = Math.toRadians(-90.0);
                min.rotate(radians, new Vector3(0.0, 1.0, 0.0));
                max.rotate(radians, new Vector3(0.0, 1.0, 0.0));
                break;
            }
            case WEST: {
                double radians = Math.toRadians(90.0);
                min.rotate(radians, new Vector3(0.0, 1.0, 0.0));
                max.rotate(radians, new Vector3(0.0, 1.0, 0.0));
                break;
            }
            case UP: {
                double radians = Math.toRadians(90.0);
                min.rotate(radians, new Vector3(0.0, 0.0, 1.0));
                max.rotate(radians, new Vector3(0.0, 0.0, 1.0));
                break;
            }
            case DOWN: {
                double radians = Math.toRadians(-90.0);
                min.rotate(radians, new Vector3(0.0, 0.0, 1.0));
                max.rotate(radians, new Vector3(0.0, 0.0, 1.0));
            }
        }
        min.add(0.5);
        max.add(0.5);
        return new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public static DistRayTraceResult rayTrace(BlockPos pos, Vector3 start, Vector3 end, AxisAlignedBB aaBB) {
        Vector3 startRay = start.copy().subtract(pos);
        Vector3 endRay = end.copy().subtract(pos);
        RayTraceResult bbResult = aaBB.func_72327_a(startRay.vec3(), endRay.vec3());
        if (bbResult != null) {
            Vector3 hitVec = new Vector3(bbResult.field_72307_f).add(pos);
            EnumFacing sideHit = bbResult.field_178784_b;
            double dist = hitVec.copy().subtract(start).magSquared();
            return new DistRayTraceResult(hitVec.vec3(), sideHit, pos, dist);
        }
        return null;
    }

    public static DistRayTraceResult rayTraceClosest(BlockPos pos, Vector3 start, Vector3 end, List<AxisAlignedBB> aaBBs) {
        DistRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (AxisAlignedBB aaBB : aaBBs) {
            DistRayTraceResult hit = RayTraceUtils.rayTrace(pos, start, end, aaBB);
            if (hit == null || !(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public static class DistRayTraceResult
    extends RayTraceResult {
        public double dist;

        public DistRayTraceResult(Vec3d hitVecIn, EnumFacing sideHitIn, BlockPos blockPosIn, double dist) {
            super(hitVecIn, sideHitIn, blockPosIn);
            this.dist = dist;
        }
    }
}

