/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.runtime.providers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.runtime.IScriptIterator;
import crafttweaker.runtime.IScriptProvider;
import crafttweaker.runtime.providers.ScriptIteratorSingle;
import crafttweaker.runtime.providers.ScriptIteratorZip;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScriptProviderDirectory
implements IScriptProvider {
    private final File directory;

    public ScriptProviderDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        this.directory = directory;
    }

    @Override
    public Iterator<IScriptIterator> getScripts() {
        ArrayList<IScriptIterator> scripts = new ArrayList<IScriptIterator>();
        if (this.directory.exists()) {
            this.iterate(this.directory, scripts);
        }
        if (scripts.size() > 1) {
            scripts.sort((sc, sc1) -> {
                if (sc == null || sc1 == null) {
                    return -1;
                }
                return sc.getName().compareTo(sc1.getName());
            });
        }
        return scripts.iterator();
    }

    private void iterate(File directoryIterated, List<IScriptIterator> scripts) {
        File[] files = directoryIterated.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.iterate(file, scripts);
                continue;
            }
            if (file.isFile() && file.getName().endsWith(".zs")) {
                scripts.add(new ScriptIteratorSingle(file, this.directory));
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".zip")) continue;
            try {
                scripts.add(new ScriptIteratorZip(file, this.directory));
            }
            catch (IOException ex) {
                CraftTweakerAPI.logError("Could not load " + file.getName() + ": " + ex.getMessage());
            }
        }
    }
}

