/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.supporters;

import com.google.gson.JsonParseException;
import goblinbob.mobends.core.Core;
import goblinbob.mobends.core.connection.ConnectionManager;
import goblinbob.mobends.core.connection.PlayerSettingsResponse;
import goblinbob.mobends.core.env.EnvironmentModule;
import goblinbob.mobends.core.module.IModule;
import goblinbob.mobends.core.supporters.AccessoryDetails;
import goblinbob.mobends.core.supporters.AccessoryDetailsResponse;
import goblinbob.mobends.core.supporters.AccessorySettings;
import goblinbob.mobends.core.util.Color;
import goblinbob.mobends.core.util.ConnectionHelper;
import goblinbob.mobends.core.util.IColorRead;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.http.conn.HttpHostConnectException;

public class SupporterContent {
    private static SupporterContent INSTANCE;
    private static final Color DEFAULT_TRAIL_COLOR;
    private final String apiUrl;
    private final Map<String, AccessoryDetails> accessoryDetailsMap = new HashMap<String, AccessoryDetails>();
    private final Map<String, PlayerSettingsResponse> accessorySettingsPerPlayer = new HashMap<String, PlayerSettingsResponse>();

    private SupporterContent() {
        this.apiUrl = EnvironmentModule.getConfig().getApiUrl();
    }

    public static void fetchAccessoryDetails() {
        try {
            AccessoryDetailsResponse response = ConnectionHelper.sendGetRequest(new URL(SupporterContent.INSTANCE.apiUrl + "/api/accessory/details"), new HashMap<String, String>(), AccessoryDetailsResponse.class);
            Map<String, AccessoryDetails> details = Objects.requireNonNull(response).getDetails();
            SupporterContent.INSTANCE.accessoryDetailsMap.clear();
            SupporterContent.INSTANCE.accessoryDetailsMap.putAll(details);
        }
        catch (HttpHostConnectException response) {
        }
        catch (JsonParseException e) {
            Core.LOG.warning("Failed to parse accessory details map.");
            e.printStackTrace();
        }
        catch (IOException | NullPointerException | URISyntaxException e) {
            Core.LOG.warning("Failed to get accessory details map.");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Map<String, PlayerSettingsResponse> map = this.accessorySettingsPerPlayer;
        synchronized (map) {
            this.accessorySettingsPerPlayer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPlayerAccessorySettings(String playerName, PlayerSettingsResponse settings) {
        Map<String, PlayerSettingsResponse> map = SupporterContent.INSTANCE.accessorySettingsPerPlayer;
        synchronized (map) {
            SupporterContent.INSTANCE.accessorySettingsPerPlayer.put(playerName, settings);
        }
    }

    public static Set<Map.Entry<String, AccessoryDetails>> getAccessories() {
        return Collections.unmodifiableSet(SupporterContent.INSTANCE.accessoryDetailsMap.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AccessorySettings> getAccessorySettingsMapFor(EntityLivingBase entity) {
        PlayerSettingsResponse settings;
        String name = entity.func_70005_c_();
        Map<String, PlayerSettingsResponse> map = SupporterContent.INSTANCE.accessorySettingsPerPlayer;
        synchronized (map) {
            settings = SupporterContent.INSTANCE.accessorySettingsPerPlayer.get(name);
        }
        if (settings == null) {
            ConnectionManager.INSTANCE.fetchSettingsForPlayer(name);
            return Collections.emptyMap();
        }
        return settings.getSettings();
    }

    public static IColorRead getTrailColorFor(EntityLivingBase entity) {
        Map<String, AccessorySettings> settingsMap = SupporterContent.getAccessorySettingsMapFor(entity);
        AccessorySettings swordTrailSettings = settingsMap.get("sword_trail");
        if (swordTrailSettings == null) {
            return DEFAULT_TRAIL_COLOR;
        }
        return swordTrailSettings.getColor();
    }

    static {
        DEFAULT_TRAIL_COLOR = new Color(Color.WHITE);
    }

    public static class Factory
    implements IModule {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            INSTANCE = new SupporterContent();
            SupporterContent.fetchAccessoryDetails();
        }

        @Override
        public void onRefresh() {
            SupporterContent.fetchAccessoryDetails();
            INSTANCE.clearCache();
        }
    }
}

