/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.asset;

import goblinbob.mobends.core.asset.AssetDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AssetManifest {
    private String baseUrl = "";
    private List<AssetDefinition> assets = new ArrayList<AssetDefinition>();

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Collection<AssetDefinition> getAssets() {
        return Collections.unmodifiableCollection(this.assets);
    }

    public static Iterable<AssetDefinition> getAssetsToUpdate(AssetManifest oldManifest, AssetManifest newManifest) {
        if (oldManifest == null) {
            return newManifest.getAssets();
        }
        ArrayList<AssetDefinition> assetsToUpdate = new ArrayList<AssetDefinition>();
        HashMap<Integer, Integer> versionMap = new HashMap<Integer, Integer>();
        for (AssetDefinition asset : oldManifest.getAssets()) {
            versionMap.put(asset.getId(), asset.getVersion());
        }
        for (AssetDefinition asset : newManifest.getAssets()) {
            int assetId = asset.getId();
            if (versionMap.containsKey(assetId) && (Integer)versionMap.get(assetId) >= asset.getVersion()) continue;
            assetsToUpdate.add(asset);
        }
        return assetsToUpdate;
    }
}

