/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util.nbt;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import zmaster587.advancedRocketry.util.nbt.NBTHelper;
import zmaster587.advancedRocketry.util.nbt.ParametrizedFactory;

public class NBTTagCompoundBuilder {
    private final NBTTagCompound instance;

    private NBTTagCompoundBuilder(NBTTagCompound instance) {
        this.instance = instance;
    }

    public static NBTTagCompoundBuilder create() {
        return new NBTTagCompoundBuilder(new NBTTagCompound());
    }

    public static NBTTagCompoundBuilder create(NBTTagCompound instance) {
        return new NBTTagCompoundBuilder(instance);
    }

    public NBTTagCompoundBuilder setString(String key, String value) {
        this.instance.func_74778_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setInt(String key, int value) {
        this.instance.func_74768_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setShort(String key, short value) {
        this.instance.func_74777_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setLong(String key, long value) {
        this.instance.func_74772_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setFloat(String key, float value) {
        this.instance.func_74776_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setDouble(String key, double value) {
        this.instance.func_74780_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setBoolean(String key, boolean value) {
        this.instance.func_74757_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setIntArray(String key, int[] value) {
        this.instance.func_74783_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setByteArray(String key, byte[] value) {
        this.instance.func_74773_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setUniqueID(String key, UUID value) {
        this.instance.func_186854_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setSerializable(String key, INBTSerializable<?> serializable) {
        return this.setTag(key, serializable.serializeNBT());
    }

    public NBTTagCompoundBuilder setBlockPos(String key, BlockPos value) {
        NBTHelper.writeBlockPos(key, value, this.instance);
        return this;
    }

    public NBTTagCompoundBuilder setAABB(String key, AxisAlignedBB value) {
        NBTHelper.writeAABB(key, this.instance, value);
        return this;
    }

    public NBTTagCompoundBuilder setTag(String key, NBTBase value) {
        this.instance.func_74782_a(key, value);
        return this;
    }

    public NBTTagCompoundBuilder setCollection(String key, Collection<? extends INBTSerializable<? extends NBTBase>> collection) {
        NBTHelper.writeCollection(key, this.instance, collection);
        return this;
    }

    public NBTTagCompoundBuilder setStringCollection(String key, Collection<String> collection) {
        NBTHelper.writeCollection(key, this.instance, collection, NBTTagString::new);
        return this;
    }

    public NBTTagCompoundBuilder setIntegerCollection(String key, Collection<Integer> collection) {
        NBTHelper.writeCollection(key, this.instance, collection, NBTTagInt::new);
        return this;
    }

    public NBTTagCompoundBuilder setFloatCollection(String key, Collection<Float> collection) {
        NBTHelper.writeCollection(key, this.instance, collection, NBTTagFloat::new);
        return this;
    }

    public NBTTagCompoundBuilder setDoubleCollection(String key, Collection<Double> collection) {
        NBTHelper.writeCollection(key, this.instance, collection, NBTTagDouble::new);
        return this;
    }

    public NBTTagCompoundBuilder setByteCollection(String key, Collection<Byte> collection) {
        NBTHelper.writeCollection(key, this.instance, collection, NBTTagByte::new);
        return this;
    }

    public <T> NBTTagCompoundBuilder setCollection(String key, Collection<T> collection, ParametrizedFactory<T, ? extends NBTBase> serializer) {
        NBTHelper.writeCollection(key, this.instance, collection, serializer);
        return this;
    }

    public NBTTagCompoundBuilder setResourceLocation(String key, ResourceLocation value) {
        this.instance.func_74778_a(key, value.toString());
        return this;
    }

    public NBTTagCompoundBuilder setMap(String key, Map<?, ? extends INBTSerializable<? extends NBTBase>> map) {
        NBTHelper.writeMap(key, this.instance, map);
        return this;
    }

    public <T> NBTTagCompoundBuilder setMap(String key, Map<?, T> map, ParametrizedFactory<T, ? extends NBTBase> serializer) {
        NBTHelper.writeMap(key, this.instance, map, serializer);
        return this;
    }

    public NBTTagCompoundBuilder execute(Consumer<NBTTagCompound> action) {
        action.accept(this.instance);
        return this;
    }

    public NBTTagCompound build() {
        return this.instance;
    }
}

