/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util.nbt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import zmaster587.advancedRocketry.util.nbt.Factory;
import zmaster587.advancedRocketry.util.nbt.NBTTagCompoundBuilder;
import zmaster587.advancedRocketry.util.nbt.ParametrizedFactory;

public class NBTHelper {
    public static NBTBase NBT_NULL = new NBTTagString("null");

    public static void writeCollection(String name, NBTTagCompound compound, Collection<? extends INBTSerializable<? extends NBTBase>> collection) {
        compound.func_74782_a(name, (NBTBase)NBTHelper.collectionToNBT(collection));
    }

    public static <T> void writeCollection(String name, NBTTagCompound compound, Collection<T> collection, ParametrizedFactory<T, ? extends NBTBase> serializer) {
        compound.func_74782_a(name, (NBTBase)NBTHelper.collectionToNBT(collection, serializer));
    }

    public static <T, NBT_T extends NBTBase, C extends Collection<T>> C readCollection(String name, NBTTagCompound compound, Factory<C> collectionFactory, ParametrizedFactory<NBT_T, T> deserializer) {
        return NBTHelper.collectionFromNBT(NBTHelper.getTagList(name, compound), collectionFactory, deserializer);
    }

    public static NBTTagList collectionToNBT(Collection<? extends INBTSerializable<? extends NBTBase>> collection) {
        NBTTagList tag = new NBTTagList();
        collection.stream().map(INBTSerializable::serializeNBT).forEach(arg_0 -> ((NBTTagList)tag).func_74742_a(arg_0));
        return tag;
    }

    public static <T> NBTTagList collectionToNBT(Collection<T> collection, ParametrizedFactory<T, ? extends NBTBase> serializer) {
        NBTTagList tag = new NBTTagList();
        collection.stream().map(serializer::create).forEach(arg_0 -> ((NBTTagList)tag).func_74742_a(arg_0));
        return tag;
    }

    public static <T, NBT_T extends NBTBase, C extends Collection<T>> C collectionFromNBT(NBTTagList tag, Factory<C> collectionFactory, ParametrizedFactory<NBT_T, T> deserializer) {
        Collection collection = (Collection)collectionFactory.create();
        tag.iterator().forEachRemaining(item -> collection.add(deserializer.create(item)));
        return (C)collection;
    }

    public static void writeMap(String name, NBTTagCompound compound, Map<?, ? extends INBTSerializable<? extends NBTBase>> map) {
        compound.func_74782_a(name, (NBTBase)NBTHelper.mapToNBT(map));
    }

    public static <V> void writeMap(String name, NBTTagCompound compound, Map<?, V> map, ParametrizedFactory<V, ? extends NBTBase> serializer) {
        compound.func_74782_a(name, (NBTBase)NBTHelper.mapToNBT(map, serializer));
    }

    public static <V, NBT_T extends NBTBase> Map<String, V> readMap(String name, NBTTagCompound compound, ParametrizedFactory<NBT_T, V> valueDeserializer) {
        return NBTHelper.readMap(name, compound, Objects::toString, valueDeserializer);
    }

    public static <K, V, NBT_T extends NBTBase> Map<K, V> readMap(String name, NBTTagCompound compound, ParametrizedFactory<String, K> keyDeserializer, ParametrizedFactory<NBT_T, V> valueDeserializer) {
        return NBTHelper.mapFromNBT(compound.func_74775_l(name), HashMap::new, keyDeserializer, valueDeserializer);
    }

    public static NBTTagCompound mapToNBT(Map<?, ? extends INBTSerializable<? extends NBTBase>> map) {
        NBTTagCompound compound = new NBTTagCompound();
        map.forEach((key, value) -> NBTHelper.write(key.toString(), (INBTSerializable<? extends NBTBase>)value, compound));
        return compound;
    }

    public static <T> NBTTagCompound mapToNBT(Map<?, T> map, ParametrizedFactory<T, ? extends NBTBase> serializer) {
        NBTTagCompound compound = new NBTTagCompound();
        map.forEach((key, value) -> NBTHelper.write(key.toString(), serializer.create(value), compound));
        return compound;
    }

    public static <V, NBT_T extends NBTBase> Map<String, V> mapFromNBT(NBTTagCompound compound, ParametrizedFactory<NBT_T, V> valueDeserializer) {
        return NBTHelper.mapFromNBT(compound, Objects::toString, valueDeserializer);
    }

    public static <K, V, NBT_T extends NBTBase> Map<K, V> mapFromNBT(NBTTagCompound compound, ParametrizedFactory<String, K> keyDeserializer, ParametrizedFactory<NBT_T, V> valueDeserializer) {
        return NBTHelper.mapFromNBT(compound, HashMap::new, keyDeserializer, valueDeserializer);
    }

    public static <K, V, NBT_T extends NBTBase> Map<K, V> mapFromNBT(NBTTagCompound compound, Factory<Map<K, V>> mapFactory, ParametrizedFactory<String, K> keyDeserializer, ParametrizedFactory<NBT_T, V> valueDeserializer) {
        Map map = mapFactory.create();
        compound.func_150296_c().forEach(key -> map.put(keyDeserializer.create((String)key), NBTHelper.read(key, compound, valueDeserializer)));
        return map;
    }

    public static void write(String key, INBTSerializable<? extends NBTBase> value, NBTTagCompound compound) {
        compound.func_74782_a(key, value.serializeNBT());
    }

    public static void write(String key, Object value, NBTTagCompound compound) {
        if (value instanceof Integer) {
            compound.func_74768_a(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            compound.func_74772_a(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        } else if (value instanceof Boolean) {
            compound.func_74757_a(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Float) {
            compound.func_74776_a(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            compound.func_74780_a(key, ((Double)value).doubleValue());
        } else if (value instanceof Byte) {
            compound.func_74774_a(key, ((Byte)value).byteValue());
        } else if (value instanceof NBTBase) {
            compound.func_74782_a(key, (NBTBase)value);
        } else if (value instanceof byte[]) {
            compound.func_74773_a(key, (byte[])value);
        } else if (value instanceof int[]) {
            compound.func_74783_a(key, (int[])value);
        }
    }

    public static <T, NBT_T> T read(String key, NBTTagCompound compound, ParametrizedFactory<NBT_T, T> factory) {
        return factory.create(compound.func_74781_a(key));
    }

    public static Object read(String key, NBTTagCompound compound) {
        NBTBase tag = compound.func_74781_a(key);
        if (tag instanceof NBTTagInt) {
            return ((NBTTagInt)tag).func_150287_d();
        }
        if (tag instanceof NBTTagLong) {
            return ((NBTTagLong)tag).func_150291_c();
        }
        if (tag instanceof NBTTagString) {
            return ((NBTTagString)tag).func_150285_a_();
        }
        if (tag instanceof NBTTagByte) {
            return ((NBTTagByte)tag).func_150290_f();
        }
        if (tag instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }
        if (tag instanceof NBTTagDouble) {
            return ((NBTTagDouble)tag).func_150286_g();
        }
        if (tag instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)tag).func_150292_c();
        }
        if (tag instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)tag).func_150302_c();
        }
        return null;
    }

    public static NBTTagList getTagList(String name, NBTTagCompound compound) {
        NBTBase nbt = (NBTBase)compound.field_74784_a.get(name);
        if (!(nbt instanceof NBTTagList)) {
            throw new IllegalArgumentException("Tag got by name " + name + "isn't NBTTagList!");
        }
        return (NBTTagList)nbt;
    }

    public static NBTBase writeBlockPos(BlockPos pos) {
        return new NBTTagLong(pos.func_177986_g());
    }

    public static BlockPos readBlockPos(NBTBase nbt) {
        return BlockPos.func_177969_a((long)((NBTTagLong)nbt).func_150291_c());
    }

    public static void writeBlockPos(String key, BlockPos pos, NBTTagCompound compound) {
        compound.func_74772_a(key, pos.func_177986_g());
    }

    public static BlockPos readBlockPos(String key, NBTTagCompound compound) {
        return BlockPos.func_177969_a((long)compound.func_74763_f(key));
    }

    public static NBTBase writeState(IBlockState state) {
        if (state == null) {
            return NBT_NULL;
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", state.func_177230_c().getRegistryName().toString());
        compound.func_74777_a("meta", (short)state.func_177230_c().func_176201_c(state));
        return compound;
    }

    public static IBlockState readState(NBTBase nbt) {
        if (nbt.equals((Object)NBT_NULL)) {
            return null;
        }
        NBTTagCompound compound = (NBTTagCompound)nbt;
        String blockName = compound.func_74779_i("name");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        return block.func_176203_a((int)compound.func_74765_d("meta"));
    }

    public static void writeAABB(String key, NBTTagCompound compound, AxisAlignedBB aabb) {
        compound.func_74782_a(key, (NBTBase)NBTTagCompoundBuilder.create().setDouble("minX", aabb.field_72340_a).setDouble("minY", aabb.field_72338_b).setDouble("minZ", aabb.field_72339_c).setDouble("maxX", aabb.field_72336_d).setDouble("maxY", aabb.field_72337_e).setDouble("maxZ", aabb.field_72334_f).build());
    }

    public static AxisAlignedBB readAABB(String key, NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l(key);
        return new AxisAlignedBB(tag.func_74769_h("minX"), tag.func_74769_h("minY"), tag.func_74769_h("minZ"), tag.func_74769_h("maxX"), tag.func_74769_h("maxY"), tag.func_74769_h("maxZ"));
    }

    public static NBTBase writeTileEntity(TileEntity tileEntity) {
        if (tileEntity == null) {
            return NBT_NULL;
        }
        NBTTagCompound compound = new NBTTagCompound();
        tileEntity.func_189515_b(compound);
        return compound;
    }

    public static TileEntity readTileEntity(NBTBase compound) {
        return NBTHelper.readTileEntity(compound, null);
    }

    public static TileEntity readTileEntity(NBTBase nbt, World world) {
        if (nbt.equals((Object)NBT_NULL)) {
            return null;
        }
        NBTTagCompound compound = (NBTTagCompound)nbt;
        return TileEntity.func_190200_a((World)world, (NBTTagCompound)compound);
    }

    public static NBTTagCompound writeEntityToCompound(Entity entity) {
        NBTTagCompound entityCompound = new NBTTagCompound();
        if (entity.func_70039_c(entityCompound)) {
            return entityCompound;
        }
        return null;
    }

    public static Entity readEntityFromCompound(NBTTagCompound nbtTagCompound, World world) {
        return EntityList.func_75615_a((NBTTagCompound)nbtTagCompound, (World)world);
    }
}

