/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.common.BiomeManager;
import org.apache.commons.lang3.RandomUtils;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.TerraformingType;
import zmaster587.advancedRocketry.util.chunkdata;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.ChunkProviderPlanet;

public class TerraformingHelper {
    public BiomeProvider chunkMgrTerraformed;
    public int dimId;
    public List<BiomeManager.BiomeEntry> biomeList;
    public World world;
    public ChunkProviderPlanet generator;
    private DimensionProperties props;
    private Map<ChunkPos, chunkdata> chunkDataMap = new HashMap<ChunkPos, chunkdata>();
    private List<Vec3i> terraformingqueue;
    private List<Vec3i> decorationqueue;
    private List<Vec3i> biomechangingqueue;
    int safe_zone_radius = 3;
    int border_zone = 3;

    public boolean has_blocks_in_tf_queue() {
        return !this.terraformingqueue.isEmpty();
    }

    public boolean has_blocks_in_dec_queue() {
        return !this.decorationqueue.isEmpty();
    }

    public TerraformingHelper(int dimension, List<BiomeManager.BiomeEntry> biomes, HashSet<ChunkPos> generated_chunks, HashSet<ChunkPos> biomechanged_chunks) {
        chunkdata data;
        this.dimId = dimension;
        this.props = DimensionManager.getInstance().getDimensionProperties(dimension);
        this.biomeList = biomes;
        this.world = net.minecraftforge.common.DimensionManager.getWorld((int)this.dimId);
        this.chunkMgrTerraformed = new ChunkManagerPlanet(this.world, this.world.func_72912_H().func_82571_y(), this.biomeList);
        this.terraformingqueue = new ArrayList<Vec3i>();
        this.biomechangingqueue = new ArrayList<Vec3i>();
        this.decorationqueue = new ArrayList<Vec3i>();
        this.chunkDataMap = new HashMap<ChunkPos, chunkdata>();
        this.generator = new ChunkProviderPlanet(this.world, this.world.func_72905_C(), this.world.func_72912_H().func_76089_r(), this.world.func_72912_H().func_82571_y());
        System.out.println("register generated chunks...");
        for (ChunkPos i : generated_chunks) {
            data = new chunkdata(i.field_77276_a, i.field_77275_b, null, this.world, this);
            data.chunk_fully_generated = true;
            this.chunkDataMap.put(new ChunkPos(data.x, data.z), data);
        }
        System.out.println("register biome changed chunks...");
        for (ChunkPos i : biomechanged_chunks) {
            this.generate_new_chunkdata(new ChunkPos(i.field_77276_a, i.field_77275_b));
            data = this.getChunkFromList(i.field_77276_a, i.field_77275_b);
            data.chunk_fully_biomechanged = true;
        }
        System.out.println("recalculate chunk types...");
        this.recalculate_chunk_status();
        System.out.println("ok!");
    }

    public int can_populate(int x, int z) {
        chunkdata currentchunk = this.getChunkFromList(x, z);
        chunkdata currentchunkx1 = this.getChunkFromList(x + 1, z);
        chunkdata currentchunkz1 = this.getChunkFromList(x, z + 1);
        chunkdata currentchunkx1z1 = this.getChunkFromList(x + 1, z + 1);
        if (currentchunk != null && currentchunkz1 != null && currentchunkx1 != null && currentchunkx1z1 != null) {
            if (currentchunk.type == TerraformingType.PROTECTED || currentchunkz1.type == TerraformingType.PROTECTED || currentchunkx1.type == TerraformingType.PROTECTED || currentchunkx1z1.type == TerraformingType.PROTECTED) {
                return -1;
            }
            if (currentchunkz1.terrain_fully_generated && currentchunkx1.terrain_fully_generated && currentchunkx1z1.terrain_fully_generated && currentchunk.terrain_fully_generated) {
                currentchunk.populate_chunk_if_not_already_done();
                return 1;
            }
        }
        return 0;
    }

    public void register_height_change_actual(BlockPos pos) {
        ChunkPos cpos = this.getChunkPosFromBlockPos(pos);
        chunkdata data = this.getChunkFromList(cpos.field_77276_a, cpos.field_77275_b);
        if (data != null && data.type == TerraformingType.BORDER) {
            this.add_position_to_queue(pos);
        }
    }

    public void register_height_change(BlockPos pos) {
        this.register_height_change_actual(pos.func_177982_a(1, 0, 0));
        this.register_height_change_actual(pos.func_177982_a(-1, 0, 0));
        this.register_height_change_actual(pos.func_177982_a(0, 0, 1));
        this.register_height_change_actual(pos.func_177982_a(0, 0, -1));
    }

    public synchronized void check_next_border_chunk_fully_generated(int px, int pz) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                chunkdata data = this.getChunkFromList(px + x, pz + z);
                if (data == null || data == null || data.terrain_fully_generated || data.type != TerraformingType.BORDER) continue;
                int chunkposxlow = data.x * 16;
                int chunkposzlow = data.z * 16;
                int chunkposxhigh = chunkposxlow + 16;
                int chunkposzhigh = chunkposzlow + 16;
                for (Vec3i p : this.terraformingqueue) {
                    if (p.func_177958_n() < chunkposxlow || p.func_177958_n() >= chunkposxhigh || p.func_177952_p() < chunkposzlow || p.func_177952_p() >= chunkposzhigh) continue;
                    return;
                }
                for (int x2 = -1; x2 <= 1; ++x2) {
                    for (int z2 = -1; z2 <= 1; ++z2) {
                        chunkdata data2 = this.getChunkFromList(px + x + x2, pz + z + z2);
                        if (data2 == null) {
                            return;
                        }
                        if (data2.type != TerraformingType.ALLOWED || data2.terrain_fully_generated) continue;
                        return;
                    }
                }
                System.out.println("border chunk terrain fully generated");
                data.terrain_fully_generated = true;
                data.blockStates = null;
                this.check_next_border_chunk_fully_generated(data.x, data.z);
                this.check_can_decorate(data.x, data.z);
            }
        }
    }

    public void check_can_decorate(int px, int pz) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (this.getChunkFromList(px + x, pz + z) == null || this.getChunkFromList((int)(px + x), (int)(pz + z)).chunk_fully_generated || this.can_populate(px + x, pz + z) == 0) continue;
                System.out.println("chunk can populate now: " + (px + x) + ":" + (pz + z));
                for (int bx = 0; bx < 16; ++bx) {
                    for (int bz = 0; bz < 16; ++bz) {
                        this.add_position_to_decoration_queue(new BlockPos((px + x) * 16 + bx, 0, (pz + z) * 16 + bz));
                    }
                }
            }
        }
    }

    public ChunkPos getChunkPosFromBlockPos(BlockPos pos) {
        return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public TerraformingType get_chunk_type(int x, int z) {
        TerraformingType type = TerraformingType.ALLOWED;
        for (BlockPos i : DimensionProperties.proxylists.getProtectingBlocksForDimension(this.props.getId())) {
            ChunkPos cpos = this.getChunkPosFromBlockPos(i);
            int dx = cpos.field_77276_a - x;
            int dz = cpos.field_77275_b - z;
            if (Math.abs(dx) <= this.safe_zone_radius && Math.abs(dz) <= this.safe_zone_radius) {
                return TerraformingType.PROTECTED;
            }
            if (Math.abs(dx) > this.safe_zone_radius + this.border_zone || Math.abs(dz) > this.safe_zone_radius + this.border_zone) continue;
            type = TerraformingType.BORDER;
        }
        return type;
    }

    public void recalculate_chunk_status() {
        Iterator<Map.Entry<ChunkPos, chunkdata>> iterator = this.chunkDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ChunkPos, chunkdata> entry = iterator.next();
            chunkdata data = entry.getValue();
            TerraformingType prevtype = data.type;
            data.type = this.get_chunk_type(data.x, data.z);
            if (prevtype == TerraformingType.ALLOWED || data.type != TerraformingType.ALLOWED && data.type != TerraformingType.BORDER || !data.terrain_fully_generated) continue;
            iterator.remove();
        }
    }

    public chunkdata getChunkFromList(int x, int z) {
        ChunkPos key = new ChunkPos(x, z);
        return this.chunkDataMap.get(key);
    }

    public synchronized void add_position_to_queue(BlockPos p) {
        if (p == null) {
            System.out.print("ERROR POSITION IS NULL");
            return;
        }
        ChunkPos cp = this.getChunkPosFromBlockPos(p);
        if (this.get_chunk_type(cp.field_77276_a, cp.field_77275_b) == TerraformingType.PROTECTED) {
            int inchunkx = (p.func_177958_n() % 16 + 16) % 16;
            int inchunkz = (p.func_177952_p() % 16 + 16) % 16;
            this.getChunkFromList(cp.field_77276_a, cp.field_77275_b).set_position_fully_generated(inchunkx, inchunkz);
        } else {
            this.terraformingqueue.add(new Vec3i(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()));
        }
    }

    public synchronized void add_position_to_biomechanging_queue(BlockPos p) {
        if (p == null) {
            System.out.print("ERROR POSITION IS NULL");
            return;
        }
        this.biomechangingqueue.add(new Vec3i(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()));
    }

    public synchronized void add_position_to_decoration_queue(BlockPos p) {
        if (p == null) {
            System.out.print("ERROR POSITION IS NULL");
            return;
        }
        int insertionIndex = 0;
        if (this.decorationqueue.size() > 0) {
            insertionIndex = new Random().nextInt(Math.min(this.decorationqueue.size(), 1000));
        }
        this.decorationqueue.add(insertionIndex, new Vec3i(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()));
    }

    public synchronized BlockPos get_next_position(boolean random) {
        if (this.terraformingqueue.isEmpty()) {
            return null;
        }
        int index = 0;
        if (random) {
            index = RandomUtils.nextInt((int)0, (int)this.terraformingqueue.size());
        }
        Vec3i pos = this.terraformingqueue.remove(index);
        return new BlockPos(pos);
    }

    public synchronized BlockPos get_next_position_biomechanging(boolean random) {
        if (this.biomechangingqueue.isEmpty()) {
            return null;
        }
        int index = random ? new Random().nextInt(Math.min(8192, this.biomechangingqueue.size())) : 0;
        Vec3i pos = this.biomechangingqueue.remove(index);
        return new BlockPos(pos);
    }

    public synchronized BlockPos get_next_position_decoration(boolean random) {
        if (this.decorationqueue.isEmpty()) {
            return null;
        }
        int index = 0;
        if (random) {
            index = RandomUtils.nextInt((int)0, (int)this.decorationqueue.size());
        }
        Vec3i pos = this.decorationqueue.remove(index);
        return new BlockPos(pos);
    }

    public void set_chunk_biomechanged(ChunkPos pos) {
        this.props.add_chunk_to_terraforming_list_but_this_time_real_terraforming_and_not_biomechanging(pos);
        DimensionProperties.proxylists.getChunksFullyBiomeChanged(this.props.getId()).add(pos);
    }

    public void generate_new_chunkdata(ChunkPos cpos) {
        chunkdata data = new chunkdata(cpos.field_77276_a, cpos.field_77275_b, null, this.world, this);
        data.type = this.get_chunk_type(data.x, data.z);
        this.chunkDataMap.put(new ChunkPos(data.x, data.z), data);
    }

    public IBlockState[] getBlocksAt(int x, int z) {
        ChunkPos cpos = this.getChunkPosFromBlockPos(new BlockPos(x, 0, z));
        chunkdata data = this.getChunkFromList(cpos.field_77276_a, cpos.field_77275_b);
        if (data == null) {
            System.out.println("generate new chunk: " + cpos.field_77276_a + ":" + cpos.field_77275_b);
            this.generate_new_chunkdata(new ChunkPos(cpos.field_77276_a, cpos.field_77275_b));
            data = this.getChunkFromList(cpos.field_77276_a, cpos.field_77275_b);
        }
        if (data.blockStates == null) {
            System.out.println("generate new blockstates: " + cpos.field_77276_a + ":" + cpos.field_77275_b);
            ChunkPrimer primer = this.generator.getChunkPrimer(cpos.field_77276_a, cpos.field_77275_b, this.chunkMgrTerraformed);
            IBlockState[][][] blockStates = new IBlockState[16][16][256];
            for (int px = 0; px < 16; ++px) {
                for (int pz = 0; pz < 16; ++pz) {
                    for (int py = 0; py < 256; ++py) {
                        blockStates[px][pz][py] = primer.func_177856_a(px, py, pz);
                    }
                }
            }
            data.blockStates = blockStates;
        }
        int chunkx = (x % 16 + 16) % 16;
        int chunkz = (z % 16 + 16) % 16;
        if (data.blockStates == null) {
            return null;
        }
        return data.blockStates[chunkx][chunkz];
    }

    public void setChunkFullyGenerated(int x, int z) {
        this.getChunkFromList((int)x, (int)z).chunk_fully_generated = true;
        DimensionProperties.proxylists.getChunksFullyTerraformed(this.props.getId()).add(new ChunkPos(x, z));
    }
}

