/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.satellite;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.inventory.modules.ModuleSatellite;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.satellite.SatelliteData;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileSatelliteTerminal
extends TileInventoriedRFConsumer
implements INetworkMachine,
IModularInventory,
IButtonInventory,
IDataInventory,
IDataHandler {
    private SatelliteBase satellite;
    private ModuleText moduleText;
    private DataStorage data = new DataStorage();

    public TileSatelliteTerminal() {
        super(10000, 2);
        this.data.setMaxData(1000);
    }

    @Nonnull
    public int[] func_180463_a(@Nullable EnumFacing side) {
        return new int[0];
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockSatelliteControlCenter.func_149732_F();
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean canPerformFunction() {
        return this.field_145850_b.func_82737_E() % 16L == 0L && this.getSatelliteFromSlot(0) != null;
    }

    public int getPowerPerOperation() {
        return 1;
    }

    public void performFunction() {
        if (this.field_145850_b.field_72995_K) {
            this.updateInventoryInfo();
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
        if (packetId == 22) {
            this.satellite = this.getSatelliteFromSlot(0);
            if (this.satellite != null && this.satellite instanceof SatelliteData) {
                if (this.getUniversalEnergyStored() < this.getPowerPerOperation()) {
                    out.writeInt(1);
                } else if (!PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(this.satellite.getDimensionId(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
                    out.writeInt(2);
                } else {
                    out.writeInt(3);
                    out.writeInt(((SatelliteData)this.satellite).getPowerPerTick());
                    out.writeInt(((SatelliteData)this.satellite).data.getData());
                    out.writeInt(((SatelliteData)this.satellite).data.getMaxData());
                }
            } else {
                out.writeInt(0);
            }
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 22) {
            int status = in.readInt();
            if (status == 3) {
                nbt.func_74768_a("ppt", in.readInt());
                nbt.func_74768_a("data", in.readInt());
                nbt.func_74768_a("maxdata", in.readInt());
            }
            nbt.func_74768_a("status", status);
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 22), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)16.0);
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            this.storeData(0);
        } else if (id == 100) {
            if (this.satellite != null && PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(this.satellite.getDimensionId(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
                this.satellite.performAction(player, this.field_145850_b, this.field_174879_c);
            }
        } else if (id == 101) {
            this.onInventoryButtonPressed(id - 100);
        }
        if (id == 22 && this.field_145850_b.field_72995_K) {
            int status = nbt.func_74762_e("status");
            this.satellite = this.getSatelliteFromSlot(0);
            if (this.moduleText != null) {
                if (status != 0 && this.satellite != null) {
                    if (status == 1) {
                        this.moduleText.setText(LibVulpes.proxy.getLocalizedString("msg.notenoughpower"));
                    } else if (status == 2) {
                        this.moduleText.setText(this.satellite.getName() + "\n\n" + LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.toofar"));
                    } else if (status == 3) {
                        this.moduleText.setText(this.satellite.getName() + "\n\n" + LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.info") + "\nPower gen.: " + nbt.func_74762_e("ppt") + "\nData: " + nbt.func_74762_e("data") + "/" + nbt.func_74762_e("maxdata"));
                    }
                } else {
                    this.moduleText.setText(LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"));
                }
            }
        }
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.satellite = this.getSatelliteFromSlot(0);
        this.updateInventoryInfo();
    }

    public void updateInventoryInfo() {
    }

    public SatelliteBase getSatelliteFromSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            return ItemSatelliteIdentificationChip.getSatellite(stack);
        }
        return null;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.energy));
        modules.add((ModuleBase)new ModuleButton(116, 70, 0, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.connect"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        modules.add((ModuleBase)new ModuleButton(173, 3, 1, "", (IButtonInventory)this, TextureResources.buttonKill, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.destroysat"), 24, 24));
        modules.add(new ModuleData(28, 20, 1, this, this.data));
        ModuleSatellite moduleSatellite = new ModuleSatellite(152, 10, this, 0);
        moduleSatellite.setSatellite(this.satellite);
        modules.add((ModuleBase)moduleSatellite);
        this.moduleText = new ModuleText(60, 20, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"), 0x404040);
        modules.add((ModuleBase)this.moduleText);
        this.updateInventoryInfo();
        return modules;
    }

    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack;
        if (buttonId == 0) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        } else if (buttonId == 1 && !(stack = this.func_70301_a(0)).func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            ItemSatelliteIdentificationChip idchip = (ItemSatelliteIdentificationChip)stack.func_77973_b();
            SatelliteBase satellite = ItemSatelliteIdentificationChip.getSatellite(stack);
            if (satellite != null) {
                DimensionManager.getInstance().getDimensionProperties(satellite.getDimensionId()).removeSatellite(satellite.getId());
            }
            idchip.erase(stack);
            this.func_70299_a(0, stack);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound data = new NBTTagCompound();
        this.data.writeToNBT(data);
        nbt.func_74782_a("data", (NBTBase)data);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound data = nbt.func_74775_l("data");
        this.data.readFromNBT(data);
    }

    @Override
    public void loadData(int id) {
    }

    @Override
    public void storeData(int id) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack = this.func_70301_a(1);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemData && stack.func_190916_E() == 1) {
                ItemData dataItem = (ItemData)stack.func_77973_b();
                this.data.removeData(dataItem.addData(stack, this.data.getData(), this.data.getDataType()), true);
            }
        } else {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        SatelliteBase satellite = this.getSatelliteFromSlot(0);
        if (satellite instanceof SatelliteData && PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(satellite.getDimensionId(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
            satellite.performAction(null, this.field_145850_b, this.field_174879_c);
        }
        if (type == this.data.getDataType() || this.data.getDataType() == DataStorage.DataType.UNDEFINED) {
            return this.data.removeData(maxAmount, commit);
        }
        return 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, EnumFacing dir, boolean commit) {
        return this.data.addData(maxAmount, type, commit);
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }
}

