/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.tile.infrastructure.TileRocketFluidLoader;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketFluidUnloader
extends TileRocketFluidLoader
implements IInfrastructure,
ITickable,
IButtonInventory,
INetworkMachine {
    public TileRocketFluidUnloader() {
        this.setOutputOnly(true);
    }

    public TileRocketFluidUnloader(int size) {
        super(size);
    }

    @Override
    public String getModularInventoryName() {
        return "tile.loader.4.name";
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.rocket != null) {
            boolean isAllowToOperate = this.inputstate == ZUtils.RedstoneState.OFF || this.isStateActive(this.inputstate, this.getStrongPowerForSides(this.field_145850_b, this.func_174877_v()));
            List<TileEntity> tiles = this.rocket.storage.getFluidTiles();
            boolean rocketFluidFull = false;
            boolean doupdate = false;
            for (TileEntity tile : tiles) {
                boolean shouldOperate;
                FluidStack rocketFluid;
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (handler.fill(rocketFluid = handler.drain(1, false), false) > 0) {
                    rocketFluidFull = true;
                }
                if (!isAllowToOperate) continue;
                if (this.getFluidTank().getFluid() != null) {
                    shouldOperate = this.getFluidTank().fill(handler.drain(new FluidStack(this.getFluidTank().getFluid(), this.getFluidTank().getCapacity() - this.getFluidTank().getFluidAmount()), false), false) > 0;
                } else {
                    boolean bl = shouldOperate = this.getFluidTank().fill(handler.drain(this.getFluidTank().getCapacity(), false), false) > 0;
                }
                if (!shouldOperate) continue;
                doupdate = true;
                this.getFluidTank().fill(handler.drain(Math.max(50, this.getFluidTank().getCapacity() - this.getFluidTank().getFluidAmount()), true), true);
            }
            if (doupdate) {
                PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)this.rocket, 3), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.func_174877_v(), (double)128.0);
            }
            this.setRedstoneState(!rocketFluidFull);
        }
    }
}

