/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.cables;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import zmaster587.advancedRocketry.cable.EnergyNetwork;
import zmaster587.advancedRocketry.cable.HandlerCableNetwork;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.tile.cables.TilePipe;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.cap.TeslaHandler;

public class TileEnergyPipe
extends TilePipe
implements IUniversalEnergy {
    @Override
    public boolean canExtract(EnumFacing dir, TileEntity e) {
        return e.hasCapability(CapabilityEnergy.ENERGY, dir) && ((IEnergyStorage)e.getCapability(CapabilityEnergy.ENERGY, dir)).canExtract() && !(e instanceof TileEnergyPipe);
    }

    @Override
    public boolean canInject(EnumFacing dir, TileEntity e) {
        return e.hasCapability(CapabilityEnergy.ENERGY, dir) && ((IEnergyStorage)e.getCapability(CapabilityEnergy.ENERGY, dir)).canReceive() && !(e instanceof TileEnergyPipe);
    }

    public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability);
    }

    public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)new ForgePowerCapability((IUniversalEnergy)this);
        }
        if (TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability)) {
            return (T)TeslaHandler.getHandler((IUniversalEnergy)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public HandlerCableNetwork getNetworkHandler() {
        return NetworkRegistry.energyNetwork;
    }

    @Override
    protected void attemptLink(EnumFacing dir, TileEntity tile) {
        if (this.canExtract(dir, tile) && !this.field_145850_b.field_72995_K) {
            this.connectedSides[dir.ordinal()] = true;
            this.getNetworkHandler().removeFromAllTypes(this, tile);
            this.getNetworkHandler().addSource(this, tile, dir);
        }
        if (this.canInject(dir, tile) && !this.field_145850_b.field_72995_K) {
            this.connectedSides[dir.ordinal()] = true;
            this.getNetworkHandler().removeFromAllTypes(this, tile);
            this.getNetworkHandler().addSink(this, tile, dir);
        }
    }

    public void setEnergyStored(int amt) {
    }

    public int extractEnergy(int amt, boolean simulate) {
        return 0;
    }

    public int getUniversalEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public void setMaxEnergyStored(int max) {
    }

    public int acceptEnergy(int amt, boolean simulate) {
        if (this.isInitialized()) {
            EnergyNetwork network = (EnergyNetwork)this.getNetworkHandler().getNetwork(this.getNetworkID());
            return network.acceptEnergy(amt, simulate);
        }
        return 0;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canExtract() {
        return false;
    }
}

