/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMiningDrill;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.api.IRocketNuclearCore;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockBipropellantFuelTank;
import zmaster587.advancedRocketry.block.BlockBipropellantRocketMotor;
import zmaster587.advancedRocketry.block.BlockFuelTank;
import zmaster587.advancedRocketry.block.BlockLandingPad;
import zmaster587.advancedRocketry.block.BlockNuclearFuelTank;
import zmaster587.advancedRocketry.block.BlockNuclearRocketMotor;
import zmaster587.advancedRocketry.block.BlockOxidizerFuelTank;
import zmaster587.advancedRocketry.block.BlockRocketMotor;
import zmaster587.advancedRocketry.block.BlockSeat;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.network.PacketInvalidLocationNotify;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.advancedRocketry.util.WeightEngine;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IDataSync;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSync;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TileEntityRFConsumer;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketAssemblingMachine
extends TileEntityRFConsumer
implements IButtonInventory,
INetworkMachine,
IDataSync,
IModularInventory,
IProgressBar,
ILinkableTile {
    protected static final ResourceLocation backdrop = new ResourceLocation("advancedrocketry", "textures/gui/rocketBuilder.png");
    protected static final ProgressBarImage verticalProgressBar = new ProgressBarImage(76, 93, 8, 52, 176, 15, 2, 38, 3, 2, EnumFacing.UP, backdrop);
    private static final int MAXSCANDELAY = 10;
    private static final int ENERGYFOROP = 100;
    private static final int MAX_SIZE = 16;
    private static final int MAX_SIZE_Y = 128;
    private static final int MIN_SIZE = 3;
    private static final int MIN_SIZE_Y = 4;
    private static final ProgressBarImage horizontalProgressBar = new ProgressBarImage(89, 9, 81, 17, 176, 0, 80, 15, 0, 2, EnumFacing.EAST, backdrop);
    private static final Block[] viableBlocks = new Block[]{AdvancedRocketryBlocks.blockLaunchpad, AdvancedRocketryBlocks.blockLandingPad};
    protected ModuleText errorText;
    protected StatsRocket stats;
    protected AxisAlignedBB bbCache;
    protected ErrorCodes status;
    private ModuleText thrustText;
    private ModuleText weightText;
    private ModuleText fuelText;
    private ModuleText accelerationText;
    private int totalProgress;
    private int progress;
    private int prevProgress = 0;
    private boolean building = false;
    private int lastRocketID;
    private List<HashedBlockPosition> blockPos = new LinkedList<HashedBlockPosition>();

    public TileRocketAssemblingMachine() {
        super(100000);
        this.status = ErrorCodes.UNSCANNED;
        this.stats = new StatsRocket();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (HashedBlockPosition pos : this.blockPos) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos.getBlockPos());
            if (!(tile instanceof IMultiblock)) continue;
            ((IMultiblock)tile).setIncomplete();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public ErrorCodes getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = ErrorCodes.values()[value];
    }

    public StatsRocket getRocketStats() {
        return this.stats;
    }

    public AxisAlignedBB getBBCache() {
        return this.bbCache;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public void setTotalProgress(int scanTotalBlocks) {
        this.totalProgress = scanTotalBlocks;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int scanTime) {
        this.progress = scanTime;
    }

    public double getNormallizedProgress() {
        return (double)this.progress / (double)(this.totalProgress * 10);
    }

    public float getAcceleration(float gravitationalMultiplier) {
        return this.stats.getAcceleration(gravitationalMultiplier);
    }

    public float getWeight() {
        return this.stats.getWeight();
    }

    public int getThrust() {
        return this.stats.getThrust();
    }

    public float getNeededThrust() {
        return this.getWeight();
    }

    public boolean hasEnoughFuel(@Nonnull FuelRegistry.FuelType fuelType) {
        float target_s;
        float fueltime;
        float a = this.getAcceleration(this.getGravityMultiplier());
        float s_can = a / 2.0f * (fueltime = (float)this.stats.getFuelCapacity(fuelType) / (float)this.stats.getBaseFuelRate(fuelType)) * fueltime;
        return s_can > (target_s = (float)(1 * ARConfiguration.getCurrentConfig().orbit - this.func_174877_v().func_177956_o()));
    }

    public float getGravityMultiplier() {
        return DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.getDimension()).getGravitationalMultiplier();
    }

    public int getFuel(@Nullable FuelRegistry.FuelType fuelType) {
        return (int)((double)this.stats.getFuelCapacity(fuelType) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void setBuilding(boolean building) {
        this.building = building;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getPowerPerOperation() {
        return 100;
    }

    public void performFunction() {
        if (this.progress >= this.totalProgress * 10) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.building) {
                    this.assembleRocket();
                } else {
                    this.scanRocket(this.field_145850_b, this.field_174879_c, this.bbCache);
                }
            }
            this.totalProgress = -1;
            this.progress = 0;
            this.prevProgress = 0;
            this.building = false;
            if (this.thrustText != null) {
                this.updateText();
            }
        }
        ++this.progress;
        if (!this.field_145850_b.field_72995_K && this.energy.getUniversalEnergyStored() < this.getPowerPerOperation() && this.progress - this.prevProgress > 0) {
            this.prevProgress = this.progress;
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 2), (int)this.field_145850_b.field_73011_w.getDimension(), (BlockPos)this.func_174877_v(), (double)32.0);
        }
    }

    public boolean canPerformFunction() {
        return this.isScanning();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isScanning() && this.bbCache != null) {
            return this.bbCache;
        }
        return super.getRenderBoundingBox();
    }

    public boolean isScanning() {
        return this.totalProgress > 0;
    }

    public AxisAlignedBB scanRocket(World world, BlockPos pos2, AxisAlignedBB bb) {
        double buffer;
        AxisAlignedBB bufferedBB;
        List rockets;
        world.func_184138_a(this.field_174879_c, world.func_180495_p(this.field_174879_c), world.func_180495_p(this.field_174879_c), 3);
        this.stats = new StatsRocket();
        if (this.getBBCache() == null) {
            this.bbCache = this.getRocketPadBounds(world, this.field_174879_c);
        }
        if (this.getBBCache() != null && (rockets = world.func_72872_a(EntityRocket.class, bufferedBB = this.bbCache.func_72314_b(buffer = 1.0E-4, buffer, buffer))).size() == 1) {
            ((EntityRocket)rockets.get(0)).recalculateStats();
            this.stats = ((EntityRocket)rockets.get((int)0)).stats;
            this.status = ErrorCodes.ALREADY_ASSEMBLED;
            return null;
        }
        int thrustMonopropellant = 0;
        int thrustBipropellant = 0;
        int thrustNuclearNozzleLimit = 0;
        int thrustNuclearReactorLimit = 0;
        int thrustNuclearTotalLimit = 0;
        int monopropellantfuelUse = 0;
        int bipropellantfuelUse = 0;
        int nuclearWorkingFluidUseMax = 0;
        int fuelCapacityMonopropellant = 0;
        int fuelCapacityBipropellant = 0;
        int fuelCapacityOxidizer = 0;
        int fuelCapacityNuclearWorkingFluid = 0;
        float drillPower = 0.0f;
        this.stats.reset();
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                int yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    BlockPos currBlockPos = new BlockPos(xCurr, yCurr, zCurr);
                    IBlockState state = world.func_180495_p(currBlockPos);
                    Block block = state.func_177230_c();
                    if (!world.func_175623_d(currBlockPos)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        boolean hasSatellite = false;
        boolean hasGuidance = false;
        boolean invalidBlock = false;
        float weight = 0.0f;
        if (this.verifyScan(bb, world)) {
            int yCurr = (int)bb.field_72338_b;
            while ((double)yCurr <= bb.field_72337_e) {
                int xCurr2 = (int)bb.field_72340_a;
                while ((double)xCurr2 <= bb.field_72336_d) {
                    int zCurr = (int)bb.field_72339_c;
                    while ((double)zCurr <= bb.field_72334_f) {
                        BlockPos currBlockPos = new BlockPos(xCurr2, yCurr, zCurr);
                        BlockPos abovePos = new BlockPos(xCurr2, yCurr + 1, zCurr);
                        BlockPos belowPos = new BlockPos(xCurr2, yCurr - 1, zCurr);
                        if (!world.func_175623_d(currBlockPos)) {
                            IBlockState state = world.func_180495_p(currBlockPos);
                            Block block = state.func_177230_c();
                            if (ARConfiguration.getCurrentConfig().blackListRocketBlocks.contains(block)) {
                                if (!block.func_176200_f((IBlockAccess)world, currBlockPos)) {
                                    invalidBlock = true;
                                    if (!world.field_72995_K) {
                                        PacketHandler.sendToNearby((BasePacket)new PacketInvalidLocationNotify(new HashedBlockPosition(xCurr2, yCurr, zCurr)), (int)world.field_73011_w.getDimension(), (BlockPos)this.func_174877_v(), (double)64.0);
                                    }
                                }
                            } else {
                                TileEntity tile;
                                weight = ARConfiguration.getCurrentConfig().advancedWeightSystem ? (weight += WeightEngine.INSTANCE.getWeight(world, currBlockPos)) : (weight += 1.0f);
                                float x = (float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f;
                                float z = (float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f;
                                if (block instanceof IRocketEngine && (world.func_180495_p(belowPos).func_177230_c().isAir(world.func_180495_p(belowPos), (IBlockAccess)world, belowPos) || world.func_180495_p(belowPos).func_177230_c() instanceof BlockLandingPad || world.func_180495_p(belowPos).func_177230_c() == AdvancedRocketryBlocks.blockLaunchpad)) {
                                    if (block instanceof BlockNuclearRocketMotor) {
                                        nuclearWorkingFluidUseMax += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                        thrustNuclearNozzleLimit += ((IRocketEngine)block).getThrust(world, currBlockPos);
                                    } else if (block instanceof BlockBipropellantRocketMotor) {
                                        bipropellantfuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                        thrustBipropellant += ((IRocketEngine)block).getThrust(world, currBlockPos);
                                    } else if (block instanceof BlockRocketMotor) {
                                        monopropellantfuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                        thrustMonopropellant += ((IRocketEngine)block).getThrust(world, currBlockPos);
                                    }
                                    this.stats.addEngineLocation(x + 0.5f, (float)(yCurr - actualMinY) + 0.5f, z + 0.5f);
                                }
                                if (block instanceof IFuelTank) {
                                    if (block instanceof BlockBipropellantFuelTank) {
                                        fuelCapacityBipropellant = (int)((double)fuelCapacityBipropellant + (double)((IFuelTank)block).getMaxFill(world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                                    } else if (block instanceof BlockOxidizerFuelTank) {
                                        fuelCapacityOxidizer = (int)((double)fuelCapacityOxidizer + (double)((IFuelTank)block).getMaxFill(world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                                    } else if (block instanceof BlockNuclearFuelTank) {
                                        fuelCapacityNuclearWorkingFluid = (int)((double)fuelCapacityNuclearWorkingFluid + (double)((IFuelTank)block).getMaxFill(world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                                    } else if (block instanceof BlockFuelTank) {
                                        fuelCapacityMonopropellant = (int)((double)fuelCapacityMonopropellant + (double)((IFuelTank)block).getMaxFill(world, currBlockPos, state) * ARConfiguration.getCurrentConfig().fuelCapacityMultiplier);
                                    }
                                }
                                if (block instanceof IRocketNuclearCore && (world.func_180495_p(belowPos).func_177230_c() instanceof IRocketNuclearCore || world.func_180495_p(belowPos).func_177230_c() instanceof IRocketEngine)) {
                                    thrustNuclearReactorLimit += ((IRocketNuclearCore)block).getMaxThrust(world, currBlockPos);
                                }
                                if (block instanceof BlockSeat && world.func_180495_p(abovePos).func_177230_c().func_176205_b((IBlockAccess)world, abovePos)) {
                                    this.stats.addPassengerSeat((int)Math.floor(x), yCurr - actualMinY, (int)Math.floor(z));
                                }
                                if (block instanceof IMiningDrill) {
                                    drillPower += ((IMiningDrill)block).getMiningSpeed(world, currBlockPos);
                                }
                                if ((tile = world.func_175625_s(currBlockPos)) instanceof TileSatelliteHatch) {
                                    hasSatellite = true;
                                    if (ARConfiguration.getCurrentConfig().advancedWeightSystem) {
                                        TileSatelliteHatch hatch = (TileSatelliteHatch)tile;
                                        if (hatch.getSatellite() != null) {
                                            weight += hatch.getSatellite().getProperties().getWeight();
                                        } else if (hatch.func_70301_a(0).func_77973_b() instanceof ItemPackedStructure) {
                                            ItemPackedStructure struct = (ItemPackedStructure)hatch.func_70301_a(0).func_77973_b();
                                            weight += struct.getStructure(hatch.func_70301_a(0)).getWeight();
                                        }
                                    }
                                } else if (tile instanceof TileGuidanceComputer) {
                                    hasGuidance = true;
                                }
                            }
                        }
                        ++zCurr;
                    }
                    ++xCurr2;
                }
                ++yCurr;
            }
            int nuclearWorkingFluidUse = 0;
            if (thrustNuclearNozzleLimit > 0) {
                thrustNuclearTotalLimit = Math.min(thrustNuclearNozzleLimit, thrustNuclearReactorLimit);
                nuclearWorkingFluidUse = (int)((float)nuclearWorkingFluidUseMax * ((float)thrustNuclearTotalLimit / (float)thrustNuclearNozzleLimit));
                thrustNuclearTotalLimit = nuclearWorkingFluidUse * thrustNuclearNozzleLimit / nuclearWorkingFluidUseMax;
            }
            this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, monopropellantfuelUse);
            this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, bipropellantfuelUse);
            this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER, bipropellantfuelUse);
            this.stats.setBaseFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, nuclearWorkingFluidUse);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fuelCapacityMonopropellant);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fuelCapacityBipropellant);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER, fuelCapacityOxidizer);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, fuelCapacityNuclearWorkingFluid);
            this.stats.setWeight(weight);
            this.stats.setThrust(Math.max(Math.max(thrustMonopropellant, thrustBipropellant), thrustNuclearTotalLimit));
            this.stats.setDrillingPower(drillPower);
            int totalFuel = fuelCapacityBipropellant + fuelCapacityNuclearWorkingFluid + fuelCapacityMonopropellant;
            int totalFuelUse = bipropellantfuelUse + nuclearWorkingFluidUse + monopropellantfuelUse;
            this.status = invalidBlock ? ErrorCodes.INVALIDBLOCK : (fuelCapacityBipropellant > 0 && totalFuel > fuelCapacityBipropellant || fuelCapacityMonopropellant > 0 && totalFuel > fuelCapacityMonopropellant || fuelCapacityNuclearWorkingFluid > 0 && totalFuel > fuelCapacityNuclearWorkingFluid || thrustBipropellant > 0 && totalFuelUse > bipropellantfuelUse || thrustMonopropellant > 0 && totalFuelUse > monopropellantfuelUse || thrustNuclearTotalLimit > 0 && totalFuelUse > nuclearWorkingFluidUse ? ErrorCodes.COMBINEDTHRUST : (!hasGuidance && !hasSatellite ? ErrorCodes.NOGUIDANCE : ((float)this.getThrust() <= this.getNeededThrust() ? ErrorCodes.NOENGINES : (thrustBipropellant > 0 && !this.hasEnoughFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) || thrustMonopropellant > 0 && !this.hasEnoughFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) || thrustNuclearTotalLimit > 0 && !this.hasEnoughFuel(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID) ? ErrorCodes.NOFUEL : ErrorCodes.SUCCESS))));
        }
        return new AxisAlignedBB((double)actualMinX, (double)actualMinY, (double)actualMinZ, (double)actualMaxX, (double)actualMaxY, (double)actualMaxZ);
    }

    private void removeReplaceableBlocks(AxisAlignedBB bb) {
        int yCurr = (int)bb.field_72338_b;
        while ((double)yCurr <= bb.field_72337_e) {
            int xCurr = (int)bb.field_72340_a;
            while ((double)xCurr <= bb.field_72336_d) {
                int zCurr = (int)bb.field_72339_c;
                while ((double)zCurr <= bb.field_72334_f) {
                    IBlockState state;
                    Block block;
                    BlockPos currBlockPos = new BlockPos(xCurr, yCurr, zCurr);
                    if (!this.field_145850_b.func_175623_d(currBlockPos) && ARConfiguration.getCurrentConfig().blackListRocketBlocks.contains(block = (state = this.field_145850_b.func_180495_p(currBlockPos)).func_177230_c()) && block.func_176200_f((IBlockAccess)this.field_145850_b, currBlockPos) && !this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_175698_g(currBlockPos);
                    }
                    ++zCurr;
                }
                ++xCurr;
            }
            ++yCurr;
        }
    }

    public void assembleRocket() {
        StorageChunk storageChunk;
        if (this.bbCache == null || this.field_145850_b.field_72995_K) {
            return;
        }
        AxisAlignedBB rocketBB = this.scanRocket(this.field_145850_b, this.field_174879_c, this.bbCache);
        if (this.status != ErrorCodes.SUCCESS) {
            return;
        }
        this.removeReplaceableBlocks(this.bbCache);
        try {
            storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
        }
        catch (NegativeArraySizeException e) {
            return;
        }
        EntityRocket rocket = new EntityRocket(this.field_145850_b, storageChunk, this.stats.copy(), rocketBB.field_72340_a + (rocketBB.field_72336_d - rocketBB.field_72340_a) / 2.0 + 0.5, this.func_174877_v().func_177956_o(), rocketBB.field_72339_c + (rocketBB.field_72334_f - rocketBB.field_72339_c) / 2.0 + 0.5);
        this.field_145850_b.func_72838_d((Entity)rocket);
        NBTTagCompound nbtdata = new NBTTagCompound();
        rocket.func_189511_e(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)rocket, 0, nbtdata), (int)rocket.field_70170_p.field_73011_w.getDimension(), (BlockPos)this.field_174879_c, (double)64.0);
        this.stats.reset();
        this.status = ErrorCodes.FINISHED;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
            rocket.linkInfrastructure(infrastructure);
        }
        this.scanRocket(this.field_145850_b, this.field_174879_c, this.bbCache);
    }

    public AxisAlignedBB getRocketPadBounds(World world, BlockPos pos) {
        int i;
        int zSize;
        int xSize;
        int zMin;
        int xMin;
        EnumFacing direction = RotatableBlock.getFront((IBlockState)world.func_180495_p(pos)).func_176734_d();
        int yCurrent = pos.func_177956_o() - 1;
        int xCurrent = pos.func_177958_n() + direction.func_82601_c();
        int zCurrent = pos.func_177952_p() + direction.func_82599_e();
        int xMax = xMin = xCurrent;
        int zMax = zMin = zCurrent;
        BlockPos currPos = new BlockPos(xCurrent, yCurrent, zCurrent);
        if (world.field_72995_K) {
            return null;
        }
        if (direction.func_82601_c() != 0) {
            xSize = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)direction, (BlockPos)currPos, (int)16, (Block[])viableBlocks);
            zMin = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.NORTH, (BlockPos)currPos, (int)16, (Block[])viableBlocks);
            zMax = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.SOUTH, (BlockPos)currPos.func_177982_a(0, 0, 1), (int)(16 - zMin), (Block[])viableBlocks);
            zSize = zMin + zMax;
            zMin = zCurrent - zMin + 1;
            zMax = zCurrent + zMax;
            if (direction.func_82601_c() > 0) {
                xMax = xCurrent + xSize - 1;
            }
            if (direction.func_82601_c() < 0) {
                xMin = xCurrent - xSize + 1;
            }
        } else {
            zSize = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)direction, (BlockPos)currPos, (int)16, (Block[])viableBlocks);
            xMin = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.WEST, (BlockPos)currPos, (int)16, (Block[])viableBlocks);
            xMax = ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.EAST, (BlockPos)currPos.func_177982_a(1, 0, 0), (int)(16 - xMin), (Block[])viableBlocks);
            xSize = xMin + xMax;
            xMin = xCurrent - xMin + 1;
            xMax = xCurrent + xMax;
            if (direction.func_82599_e() > 0) {
                zMax = zCurrent + zSize - 1;
            }
            if (direction.func_82599_e() < 0) {
                zMin = zCurrent - zSize + 1;
            }
        }
        int maxTowerSize = 0;
        for (i = xMin; i <= xMax; ++i) {
            if (world.func_180495_p(new BlockPos(i, yCurrent, zMin - 1)).func_177230_c() == AdvancedRocketryBlocks.blockStructureTower) {
                maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.UP, (BlockPos)new BlockPos(i, yCurrent, zMin - 1), (int)128, (Block)AdvancedRocketryBlocks.blockStructureTower));
            }
            if (world.func_180495_p(new BlockPos(i, yCurrent, zMax + 1)).func_177230_c() != AdvancedRocketryBlocks.blockStructureTower) continue;
            maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.UP, (BlockPos)new BlockPos(i, yCurrent, zMax + 1), (int)128, (Block)AdvancedRocketryBlocks.blockStructureTower));
        }
        for (i = zMin; i <= zMax; ++i) {
            if (world.func_180495_p(new BlockPos(xMin - 1, yCurrent, i)).func_177230_c() == AdvancedRocketryBlocks.blockStructureTower) {
                maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.UP, (BlockPos)new BlockPos(xMin - 1, yCurrent, i), (int)128, (Block)AdvancedRocketryBlocks.blockStructureTower));
            }
            if (world.func_180495_p(new BlockPos(xMax + 1, yCurrent, i)).func_177230_c() != AdvancedRocketryBlocks.blockStructureTower) continue;
            maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (EnumFacing)EnumFacing.UP, (BlockPos)new BlockPos(xMax + 1, yCurrent, i), (int)128, (Block)AdvancedRocketryBlocks.blockStructureTower));
        }
        if (maxTowerSize < 4 || xSize < 3 || zSize < 3) {
            return null;
        }
        return new AxisAlignedBB(new BlockPos(xMin, yCurrent + 1, zMin), new BlockPos(xMax, yCurrent + maxTowerSize - 1, zMax));
    }

    protected boolean verifyScan(AxisAlignedBB bb, World world) {
        boolean whole = true;
        block0: for (int xx = (int)bb.field_72340_a; xx <= (int)bb.field_72336_d; ++xx) {
            for (int zz = (int)bb.field_72339_c; zz <= (int)bb.field_72334_f; ++zz) {
                Block blockAtSpot = world.func_180495_p(new BlockPos(xx, (int)bb.field_72338_b - 1, zz)).func_177230_c();
                boolean contained = false;
                for (Block b : viableBlocks) {
                    if (blockAtSpot != b) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                whole = false;
                break block0;
            }
        }
        return whole;
    }

    public int getVolume(World world, AxisAlignedBB bb) {
        return (int)((bb.field_72336_d - bb.field_72340_a) * (bb.field_72337_e - bb.field_72338_b) * (bb.field_72334_f - bb.field_72339_c));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.stats.writeToNBT(nbt);
        nbt.func_74768_a("scanTime", this.progress);
        nbt.func_74768_a("scanTotalBlocks", this.totalProgress);
        nbt.func_74757_a("building", this.building);
        nbt.func_74768_a("status", this.status.ordinal());
        if (this.bbCache != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("minX", this.bbCache.field_72340_a);
            tag.func_74780_a("minY", this.bbCache.field_72338_b);
            tag.func_74780_a("minZ", this.bbCache.field_72339_c);
            tag.func_74780_a("maxX", this.bbCache.field_72336_d);
            tag.func_74780_a("maxY", this.bbCache.field_72337_e);
            tag.func_74780_a("maxZ", this.bbCache.field_72334_f);
            nbt.func_74782_a("bb", (NBTBase)tag);
        }
        if (!this.blockPos.isEmpty()) {
            int[] array = new int[this.blockPos.size() * 3];
            int counter = 0;
            for (HashedBlockPosition pos : this.blockPos) {
                array[counter] = pos.x;
                array[counter + 1] = pos.y;
                array[counter + 2] = pos.z;
                counter += 3;
            }
            nbt.func_74783_a("infrastructureLocations", array);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stats.readFromNBT(nbt);
        this.prevProgress = this.progress = nbt.func_74762_e("scanTime");
        this.totalProgress = nbt.func_74762_e("scanTotalBlocks");
        this.status = ErrorCodes.values()[nbt.func_74762_e("status")];
        this.building = nbt.func_74767_n("building");
        if (nbt.func_74764_b("bb")) {
            NBTTagCompound tag = nbt.func_74775_l("bb");
            this.bbCache = new AxisAlignedBB(tag.func_74769_h("minX"), tag.func_74769_h("minY"), tag.func_74769_h("minZ"), tag.func_74769_h("maxX"), tag.func_74769_h("maxY"), tag.func_74769_h("maxZ"));
        }
        this.blockPos.clear();
        if (nbt.func_74764_b("infrastructureLocations")) {
            int[] array = nbt.func_74759_k("infrastructureLocations");
            for (int counter = 0; counter < array.length; counter += 3) {
                this.blockPos.add(new HashedBlockPosition(array[counter], array[counter + 1], array[counter + 2]));
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        super.func_189518_D_();
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 2) {
            out.writeInt(this.energy.getUniversalEnergyStored());
            out.writeInt(this.progress);
        } else if (id == 3) {
            out.writeInt(this.lastRocketID);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte id, NBTTagCompound nbt) {
        if (id == 2) {
            nbt.func_74768_a("pwr", in.readInt());
            nbt.func_74768_a("tik", in.readInt());
        } else if (id == 3) {
            nbt.func_74768_a("id", in.readInt());
        }
    }

    public boolean canScan() {
        return this.bbCache != null;
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.field_174879_c);
            if (!this.canScan()) {
                return;
            }
            this.totalProgress = (int)(ARConfiguration.getCurrentConfig().buildSpeedMultiplier * (float)this.getVolume(this.field_145850_b, this.bbCache) / 10.0f);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        } else if (id == 1) {
            if (this.isScanning()) {
                return;
            }
            this.building = true;
            this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.field_174879_c);
            if (!this.canScan()) {
                return;
            }
            this.totalProgress = (int)(ARConfiguration.getCurrentConfig().buildSpeedMultiplier * (float)this.getVolume(this.field_145850_b, this.bbCache) / 10.0f);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        } else if (id == 2) {
            this.energy.setEnergyStored(nbt.func_74762_e("pwr"));
            this.progress = nbt.func_74762_e("tik");
        } else if (id == 3) {
            EntityRocket rocket = (EntityRocket)this.field_145850_b.func_73045_a(nbt.func_74762_e("id"));
            for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
                rocket.linkInfrastructure(infrastructure);
            }
        }
    }

    protected void updateText() {
        this.thrustText.setText(this.isScanning() ? LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.thrust") + ": ???" : String.format("%s: %dkN", LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.thrust"), this.getThrust()));
        this.weightText.setText(this.isScanning() ? LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.weight") + ": ???" : String.format("%s: %.2fkN", LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.weight"), Float.valueOf(this.getWeight() * this.getGravityMultiplier())));
        this.fuelText.setText(this.isScanning() ? LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.fuel") + ": ???" : String.format("%s: %dmb/s", LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.fuel"), 20 * this.getRocketStats().getFuelRate(this.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) > 0 ? FuelRegistry.FuelType.LIQUID_MONOPROPELLANT : (this.stats.getFuelCapacity(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID) > 0 ? FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID : FuelRegistry.FuelType.LIQUID_BIPROPELLANT))));
        this.accelerationText.setText(this.isScanning() ? LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.acc") + ": ???" : String.format("%s: %.2fm/s\u00b2", LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.acc"), Float.valueOf(this.getAcceleration(this.getGravityMultiplier()) * 20.0f)));
        if (!this.field_145850_b.field_72995_K) {
            if (this.getRocketPadBounds(this.field_145850_b, this.field_174879_c) == null) {
                this.setStatus(ErrorCodes.INCOMPLETESTRCUTURE.ordinal());
            } else if (ErrorCodes.INCOMPLETESTRCUTURE.equals((Object)this.getStatus())) {
                this.setStatus(ErrorCodes.UNSCANNED.ordinal());
            }
        }
        this.errorText.setText(this.getStatus().getErrorCode());
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(160, 90, (IUniversalEnergy)this));
        if (this.field_145850_b.field_72995_K) {
            modules.add((ModuleBase)new ModuleImage(4, 9, new IconResource(4, 9, 168, 74, backdrop)));
        }
        modules.add((ModuleBase)new ModuleProgress(89, 47, 0, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(89, 66, 1, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(89, 28, 3, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(89, 9, 4, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(149, 90, 2, verticalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleButton(5, 94, 0, LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.scan"), (IButtonInventory)this, TextureResources.buttonScan));
        ModuleButton buttonBuild = new ModuleButton(5, 120, 1, LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.build"), (IButtonInventory)this, TextureResources.buttonBuild);
        modules.add((ModuleBase)buttonBuild);
        buttonBuild.setColor(-56798);
        this.thrustText = new ModuleText(8, 15, "", -14483678);
        modules.add((ModuleBase)this.thrustText);
        this.weightText = new ModuleText(8, 34, "", -14483678);
        modules.add((ModuleBase)this.weightText);
        this.fuelText = new ModuleText(8, 52, "", -14483678);
        modules.add((ModuleBase)this.fuelText);
        this.accelerationText = new ModuleText(8, 71, "", -14483678);
        modules.add((ModuleBase)this.accelerationText);
        this.errorText = new ModuleText(5, 84, "", -222);
        modules.add((ModuleBase)this.errorText);
        this.updateText();
        for (int i = 0; i < 15; ++i) {
            modules.add((ModuleBase)new ModuleSync(i, (IDataSync)this));
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "";
    }

    public float getNormallizedProgress(int id) {
        if (this.isScanning() && id != 2) {
            return 0.0f;
        }
        switch (id) {
            case 0: {
                FuelRegistry.FuelType fuelType = this.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) > 0 ? FuelRegistry.FuelType.LIQUID_MONOPROPELLANT : (this.stats.getBaseFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID) > 0 ? FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID : FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
                return this.getAcceleration(this.getGravityMultiplier()) > 0.0f ? MathHelper.func_76131_a((float)(0.5f + 0.5f * ((float)(this.getFuel(fuelType) - this.stats.getFuelCapacity(fuelType)) / (float)this.stats.getFuelCapacity(fuelType))), (float)0.0f, (float)1.0f) : 0.0f;
            }
            case 1: {
                return MathHelper.func_76131_a((float)(0.5f + this.getAcceleration(this.getGravityMultiplier()) * 10.0f), (float)0.0f, (float)1.0f);
            }
            case 2: {
                return (float)this.getNormallizedProgress();
            }
            case 3: {
                return this.getWeight() > 0.0f ? 0.5f : 0.0f;
            }
            case 4: {
                return this.getThrust() > 0 ? 0.9f : 0.0f;
            }
        }
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
        if (id == 2) {
            this.setProgress(progress);
        }
    }

    public int getProgress(int id) {
        if (id == 2) {
            return this.getProgress();
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 2) {
            return this.getTotalProgress();
        }
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
        if (id == 2) {
            this.setTotalProgress(progress);
            this.updateText();
        }
    }

    public void setData(int id, int value) {
        switch (id) {
            case 0: {
                this.getRocketStats().setWeight((float)value / 1000.0f);
                break;
            }
            case 1: {
                this.getRocketStats().setThrust(value);
                break;
            }
            case 2: {
                this.setStatus(value);
                break;
            }
            case 3: {
                this.getRocketStats().setBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, value);
                break;
            }
            case 4: {
                this.getRocketStats().setFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, value);
                break;
            }
            case 5: {
                this.getRocketStats().setFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, value);
                break;
            }
            case 6: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, value);
                break;
            }
            case 7: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, value);
                break;
            }
            case 8: {
                this.getRocketStats().setFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, value);
                break;
            }
            case 9: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, value);
                break;
            }
            case 10: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, value);
                break;
            }
            case 11: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, value);
                break;
            }
            case 12: {
                this.getRocketStats().setFuelAmount(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, value);
                break;
            }
            case 13: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, value);
                break;
            }
            case 14: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID, value);
            }
        }
        this.updateText();
    }

    public int getData(int id) {
        switch (id) {
            case 0: {
                return (int)(this.getRocketStats().getWeight_NoFuel() * 1000.0f);
            }
            case 1: {
                return this.getRocketStats().getThrust();
            }
            case 2: {
                return this.getStatus().ordinal();
            }
            case 3: {
                return this.getRocketStats().getBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT);
            }
            case 4: {
                return this.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT);
            }
            case 5: {
                return this.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT);
            }
            case 6: {
                return this.getRocketStats().getFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT);
            }
            case 7: {
                return this.getRocketStats().getBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
            }
            case 8: {
                return this.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
            }
            case 9: {
                return this.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
            }
            case 10: {
                return this.getRocketStats().getFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT);
            }
            case 11: {
                return this.getRocketStats().getBaseFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID);
            }
            case 12: {
                return this.getRocketStats().getFuelAmount(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID);
            }
            case 13: {
                return this.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID);
            }
            case 14: {
                return this.getRocketStats().getFuelRate(FuelRegistry.FuelType.NUCLEAR_WORKING_FLUID);
            }
        }
        return 0;
    }

    public void onInventoryButtonPressed(int buttonId) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }

    public boolean onLinkStart(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        return true;
    }

    public boolean onLinkComplete(@Nonnull ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        TileEntity tile = world.func_175625_s(ItemLinker.getMasterCoords((ItemStack)item));
        float maxlinkDistance = 15.0f;
        if (tile instanceof IInfrastructure) {
            HashedBlockPosition pos = new HashedBlockPosition(tile.func_174877_v());
            HashedBlockPosition hashedBlockPosition = new HashedBlockPosition(this.field_174879_c);
            if (pos.getDistance(hashedBlockPosition) > (double)maxlinkDistance) {
                if (!world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("the machine is too far away to be linked", new Object[0]));
                }
                return false;
            }
            if (!this.blockPos.contains(pos)) {
                this.blockPos.add(pos);
            }
            if (this.getBBCache() == null) {
                this.bbCache = this.getRocketPadBounds(world, this.func_174877_v());
            }
            if (this.getBBCache() != null) {
                List rockets = world.func_72872_a(EntityRocketBase.class, this.bbCache);
                for (EntityRocketBase rocket : rockets) {
                    rocket.linkInfrastructure((IInfrastructure)tile);
                }
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.linker.success", new Object[0]));
                if (tile instanceof IMultiblock) {
                    ((IMultiblock)tile).setMasterBlock(this.func_174877_v());
                }
            }
            ItemLinker.resetPosition((ItemStack)item);
            return true;
        }
        return false;
    }

    public void removeConnectedInfrastructure(TileEntity tile) {
        this.blockPos.remove(new HashedBlockPosition(tile.func_174877_v()));
        if (this.getBBCache() == null) {
            this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.func_174877_v());
        }
        if (this.getBBCache() != null) {
            List rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, this.bbCache);
            for (EntityRocketBase rocket : rockets) {
                rocket.unlinkInfrastructure((IInfrastructure)tile);
            }
        }
    }

    public List<IInfrastructure> getConnectedInfrastructure() {
        LinkedList<IInfrastructure> infrastructure = new LinkedList<IInfrastructure>();
        Iterator<HashedBlockPosition> iter = this.blockPos.iterator();
        while (iter.hasNext()) {
            HashedBlockPosition position = iter.next();
            TileEntity tile = this.field_145850_b.func_175625_s(position.getBlockPos());
            if (tile instanceof IInfrastructure) {
                infrastructure.add((IInfrastructure)tile);
                continue;
            }
            iter.remove();
        }
        return infrastructure;
    }

    @SubscribeEvent
    public void onRocketLand(RocketEvent.RocketLandedEvent event) {
        double buffer;
        AxisAlignedBB bufferedBB;
        List rockets;
        if (event.world.field_72995_K) {
            return;
        }
        EntityRocketBase rocket = (EntityRocketBase)event.getEntity();
        if (this.field_145850_b == null) {
            AdvancedRocketry.logger.debug("World null for rocket builder during rocket land event @ " + this.field_174879_c);
            return;
        }
        if (this.getBBCache() == null) {
            this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.field_174879_c);
        }
        if (this.getBBCache() != null && (rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, bufferedBB = this.bbCache.func_72314_b(buffer = 1.0E-4, buffer, buffer))).contains((Object)rocket)) {
            this.lastRocketID = rocket.func_145782_y();
            for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
                rocket.linkInfrastructure(infrastructure);
            }
            this.scanRocket(this.field_145850_b, this.field_174879_c, this.bbCache);
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketMachine((INetworkMachine)this, 3), (Entity)rocket);
        }
    }

    protected static enum ErrorCodes {
        SUCCESS(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.success")),
        NOFUEL(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.nofuel")),
        NOSEAT(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.noseat")),
        NOENGINES(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.noengines")),
        NOGUIDANCE(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.noguidance")),
        UNSCANNED(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.unscanned")),
        SUCCESS_STATION(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.success_station")),
        EMPTY(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.empty")),
        FINISHED(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.finished")),
        INCOMPLETESTRCUTURE(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.incompletestructure")),
        NOSATELLITEHATCH(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.nosatellitehatch")),
        NOSATELLITECHIP(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.nosatellitechip")),
        OUTPUTBLOCKED(LibVulpes.proxy.getLocalizedString("msg.rocketbuilder.outputblocked")),
        INVALIDBLOCK(LibVulpes.proxy.getLocalizedString("msg.rocketbuild.invalidblock")),
        COMBINEDTHRUST(LibVulpes.proxy.getLocalizedString("msg.rocketbuild.combinedthrust")),
        ALREADY_ASSEMBLED("rocket already assembled");

        String code;

        private ErrorCodes(String code) {
            this.code = code;
        }

        public String getErrorCode() {
            return this.code;
        }
    }
}

