/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;

public class TileFluidTank
extends TileFluidHatch {
    private static final int MAX_UPDATE = 5;
    private long lastUpdateTime;
    private boolean fluidChanged = false;

    public TileFluidTank() {
    }

    public TileFluidTank(int i) {
        super(i);
    }

    private void checkForUpdate() {
        if (this.fluidChanged && this.field_145850_b instanceof WorldDummy || this.field_145850_b.func_82737_E() - this.lastUpdateTime > 5L) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.lastUpdateTime = this.field_145850_b.func_82737_E();
            this.fluidChanged = false;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TileFluidTank handler2 = this.getFluidTankInDirection(EnumFacing.UP);
        if (handler2 != null && handler2.canFill(resource)) {
            return handler2.fill(resource, doFill);
        }
        return this.fillInternal2(resource, doFill);
    }

    private int fillInternal2(FluidStack resource, boolean doFill) {
        TileFluidTank handler = this.getFluidTankInDirection(EnumFacing.DOWN);
        int amt = 0;
        if (handler != null) {
            amt = handler.fillInternal2(resource, doFill);
        }
        FluidStack resource2 = resource.copy();
        resource2.amount -= amt;
        if (resource2.amount > 0) {
            amt += super.fill(resource2, doFill);
        }
        if (amt > 0 && doFill) {
            this.fluidChanged = true;
        }
        this.checkForUpdate();
        return amt;
    }

    public String getModularInventoryName() {
        return AdvancedRocketryBlocks.blockPressureTank.func_149732_F();
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        TileFluidTank handler = this.getFluidTankInDirection(EnumFacing.UP);
        FluidStack fStack = null;
        if (handler != null && handler.getTankProperties()[0].getContents() != null && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == handler.getTankProperties()[0].getContents().getFluid()) {
            fStack = handler.drain(maxDrain, doDrain);
        }
        if (fStack != null) {
            return fStack;
        }
        FluidStack fStack2 = super.drain(maxDrain, doDrain);
        if (fStack2 != null && doDrain) {
            this.fluidChanged = true;
        }
        this.checkForUpdate();
        return fStack2;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() == null || resource.getFluid() != this.fluidTank.getFluid().getFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public TileFluidTank getFluidTankInDirection(EnumFacing direction) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
        if (tile instanceof TileFluidTank) {
            return (TileFluidTank)tile;
        }
        return null;
    }

    private boolean canFill(FluidStack fStack) {
        FluidStack fStack2 = this.fluidTank.getFluid();
        return fStack2 == null || fStack2.getFluid() == fStack.getFluid();
    }

    protected NBTTagCompound writeToNBTHelper(NBTTagCompound nbtTagCompound) {
        super.writeToNBTHelper(nbtTagCompound);
        this.fluidTank.writeToNBT(nbtTagCompound);
        return nbtTagCompound;
    }

    protected void readFromNBTHelper(NBTTagCompound nbtTagCompound) {
        super.readFromNBTHelper(nbtTagCompound);
        this.fluidTank.readFromNBT(nbtTagCompound);
    }

    protected boolean useBucket(int slot, @Nonnull ItemStack stack) {
        FluidStack othertank;
        TileFluidTank handler;
        boolean bucketUsed = super.useBucket(slot, stack);
        if (bucketUsed && (handler = this.getFluidTankInDirection(EnumFacing.DOWN)) != null && ((othertank = handler.getTankProperties()[0].getContents()) == null || othertank.amount < handler.getTankProperties()[0].getCapacity())) {
            this.fluidTank.drain(handler.fill(this.fluidTank.getFluid(), true), true);
        }
        return bucketUsed;
    }

    public void onAdjacentBlockUpdated(EnumFacing dir) {
        if (dir != EnumFacing.DOWN) {
            return;
        }
        TileFluidTank tank = this.getFluidTankInDirection(EnumFacing.UP);
        if (tank != null && tank.getTankProperties()[0].getContents() != null) {
            if (this.fluidTank.getFluid() == null) {
                this.fluidTank.fill(tank.fluidTank.drain(this.fluidTank.getCapacity(), true), true);
            } else if (tank.getTankProperties()[0].getContents().getFluid() == this.fluidTank.getFluid().getFluid()) {
                this.fluidTank.fill(tank.drain(this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), true), true);
                tank.fluidTank.drain(this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), true);
            }
            this.func_70296_d();
        }
    }
}

