/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.RandomUtils;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.item.ItemWeatherController;
import zmaster587.advancedRocketry.network.PacketAirParticle;
import zmaster587.advancedRocketry.network.PacketFluidParticle;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class SatelliteWeatherController
extends SatelliteBase {
    public int mode_id = 0;
    public int last_mode_id = 0;
    public int floodlevel = -1;
    private List<BlockPos> viable_positions = new ArrayList<BlockPos>();

    public int getMode_id() {
        return this.mode_id;
    }

    public int getFloodlevel() {
        if (this.floodlevel == -1) {
            this.floodlevel = DimensionManager.getInstance().getDimensionProperties(this.getDimensionId()).getSeaLevel();
        }
        return this.floodlevel;
    }

    @Override
    public String getInfo(World world) {
        return "Ready";
    }

    @Override
    public String getName() {
        return "Weather Satellite";
    }

    @Override
    @Nonnull
    public ItemStack getControllerItemStack(@Nonnull ItemStack satIdChip, SatelliteProperties properties) {
        ItemWeatherController idChipItem = (ItemWeatherController)satIdChip.func_77973_b();
        idChipItem.setSatellite(satIdChip, properties);
        return satIdChip;
    }

    @Override
    public boolean isAcceptableControllerItemStack(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemWeatherController;
    }

    @Override
    public void tickEntity() {
        BlockPos new_block;
        super.tickEntity();
        if (this.last_mode_id != this.mode_id) {
            this.last_mode_id = this.mode_id;
            this.viable_positions.clear();
        }
        int listsize = this.viable_positions.size();
        WorldServer world = net.minecraftforge.common.DimensionManager.getWorld((int)this.getDimensionId());
        if (listsize > 0 && this.mode_id == 0 && (world.func_180495_p(new_block = this.viable_positions.remove(RandomUtils.nextInt((int)0, (int)listsize))).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(new_block).func_177230_c() == Blocks.field_150358_i || world.func_180495_p(new_block).func_177230_c() == Blocks.field_150355_j && (Integer)world.func_180495_p(new_block).func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0)) {
            world.func_175656_a(new_block, Blocks.field_150355_j.func_176223_P());
            world.func_184138_a(new_block, world.func_180495_p(new_block), world.func_180495_p(new_block), 3);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 45, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 35, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 25, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 15, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
        }
        if (listsize > 0 && this.mode_id == 1) {
            new_block = this.viable_positions.remove(RandomUtils.nextInt((int)0, (int)listsize));
            DimensionManager.getInstance().getDimensionProperties(this.getDimensionId()).add_water_locked_pos(new HashedBlockPosition(new_block));
            if (world.func_180495_p(new_block).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(new_block).func_177230_c() == Blocks.field_150358_i) {
                world.func_175656_a(new_block, Blocks.field_150350_a.func_176223_P());
                world.func_184138_a(new_block, world.func_180495_p(new_block), world.func_180495_p(new_block), 3);
                PacketHandler.sendToNearby((BasePacket)new PacketAirParticle(new HashedBlockPosition(new_block.func_177958_n(), new_block.func_177956_o() + 1, new_block.func_177952_p())), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
                PacketHandler.sendToNearby((BasePacket)new PacketAirParticle(new HashedBlockPosition(new_block.func_177958_n(), new_block.func_177956_o() + 2, new_block.func_177952_p())), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
                PacketHandler.sendToNearby((BasePacket)new PacketAirParticle(new HashedBlockPosition(new_block.func_177958_n(), new_block.func_177956_o() + 3, new_block.func_177952_p())), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
                PacketHandler.sendToNearby((BasePacket)new PacketAirParticle(new HashedBlockPosition(new_block.func_177958_n(), new_block.func_177956_o() + 4, new_block.func_177952_p())), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
                PacketHandler.sendToNearby((BasePacket)new PacketAirParticle(new HashedBlockPosition(new_block.func_177958_n(), new_block.func_177956_o() + 5, new_block.func_177952_p())), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            }
        }
        if (listsize > 0 && this.mode_id == 2 && (world.func_180495_p(new_block = this.viable_positions.remove(RandomUtils.nextInt((int)0, (int)listsize))).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(new_block).func_177230_c() == Blocks.field_150358_i || world.func_180495_p(new_block).func_177230_c() == Blocks.field_150355_j)) {
            world.func_175656_a(new_block, Blocks.field_150355_j.func_176223_P());
            world.func_184138_a(new_block, world.func_180495_p(new_block), world.func_180495_p(new_block), 3);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 45, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 35, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 25, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
            PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(new_block.func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a().func_177984_a(), new_block, 15, 13955577), (int)world.field_73011_w.getDimension(), (BlockPos)new_block, (double)128.0);
        }
    }

    private boolean is_block_in_list(List<BlockPos> l, BlockPos p) {
        for (BlockPos i : l) {
            if (i.func_177958_n() != p.func_177958_n() || i.func_177952_p() != p.func_177952_p() || i.func_177956_o() != p.func_177956_o()) continue;
            return true;
        }
        return false;
    }

    private boolean can_be_made_water(BlockPos block, World world) {
        return world.func_180495_p(block).func_177230_c() == Blocks.field_150350_a || world.func_180495_p(block).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(block).func_177230_c() == Blocks.field_150358_i || world.func_180495_p(block).func_185904_a().func_76222_j();
    }

    private boolean check_one_block(BlockPos block_x, World world, List<BlockPos> checked_blocks, int in, int max_vol) {
        if (this.is_block_in_list(this.viable_positions, block_x)) {
            return true;
        }
        if (checked_blocks.size() > max_vol) {
            return false;
        }
        if (!this.is_block_in_list(checked_blocks, block_x) && this.can_be_made_water(block_x, world)) {
            checked_blocks.add(block_x);
            if (!this.find_connected_blocks_down(block_x, world, checked_blocks, in + 1, max_vol)) {
                return false;
            }
        }
        return true;
    }

    private boolean find_connected_blocks_down(BlockPos start, World world, List<BlockPos> checked_blocks, int in, int max_vol) {
        if (!this.check_one_block(start.func_177978_c(), world, checked_blocks, in, max_vol)) {
            return false;
        }
        if (!this.check_one_block(start.func_177976_e(), world, checked_blocks, in, max_vol)) {
            return false;
        }
        if (!this.check_one_block(start.func_177968_d(), world, checked_blocks, in, max_vol)) {
            return false;
        }
        if (!this.check_one_block(start.func_177974_f(), world, checked_blocks, in, max_vol)) {
            return false;
        }
        LinkedList<BlockPos> lower_layer = new LinkedList<BlockPos>();
        if (!this.check_one_block(start.func_177977_b(), world, lower_layer, in, max_vol)) {
            return false;
        }
        checked_blocks.addAll(lower_layer);
        return true;
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        if (this.mode_id == 0) {
            long startTime = System.nanoTime();
            int max_vol = 300;
            int radius = 4;
            if (this.viable_positions.size() > 4000) {
                return false;
            }
            for (int z = -radius; z < radius + 1; ++z) {
                for (int x = -radius; x < radius + 1; ++x) {
                    BlockPos top_block = world.func_175645_m(new BlockPos(x + pos.func_177958_n(), 0, z + pos.func_177952_p()));
                    while (!world.func_180495_p(top_block.func_177977_b()).func_185914_p() && top_block.func_177956_o() > 0) {
                        top_block = top_block.func_177977_b();
                    }
                    ArrayList<BlockPos> checked_blocks = new ArrayList<BlockPos>();
                    while (this.check_one_block(top_block, world, checked_blocks, 0, max_vol)) {
                        this.viable_positions.addAll(checked_blocks);
                        checked_blocks.clear();
                        top_block = top_block.func_177984_a();
                    }
                }
            }
            long endTime = System.nanoTime();
            long top_block = endTime - startTime;
        } else if (this.mode_id == 1) {
            long startTime = System.nanoTime();
            int max_vol = 1000;
            int radius = 16;
            if (this.viable_positions.size() > 4000) {
                return false;
            }
            for (int z = -radius; z < radius + 1; ++z) {
                for (int x = -radius; x < radius + 1; ++x) {
                    BlockPos top_block = world.func_175645_m(new BlockPos(x + pos.func_177958_n(), 0, z + pos.func_177952_p()));
                    top_block = top_block.func_177977_b();
                    while (world.func_180495_p(top_block).func_177230_c() == Blocks.field_150355_j) {
                        this.viable_positions.add(top_block);
                        top_block = top_block.func_177977_b();
                    }
                }
            }
            long endTime = System.nanoTime();
            long top_block = endTime - startTime;
        } else if (this.mode_id == 2) {
            long startTime = System.nanoTime();
            int max_vol = 1000;
            int radius = 16;
            if (this.viable_positions.size() > 4000) {
                return false;
            }
            for (int z = -radius; z < radius + 1; ++z) {
                for (int x = -radius; x < radius + 1; ++x) {
                    BlockPos top_block = new BlockPos(x + pos.func_177958_n(), this.floodlevel, z + pos.func_177952_p());
                    top_block = top_block.func_177977_b();
                    while (this.can_be_made_water(top_block, world)) {
                        this.viable_positions.add(top_block);
                        top_block = top_block.func_177977_b();
                    }
                }
            }
            long endTime = System.nanoTime();
            long l = endTime - startTime;
        }
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    public IUniversalEnergy getBattery() {
        return this.battery;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("mode_id", this.mode_id);
        nbt.func_74768_a("last_mode_id", this.last_mode_id);
        nbt.func_74768_a("floodlevel", this.floodlevel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.mode_id = nbt.func_74762_e("mode_id");
        this.last_mode_id = nbt.func_74762_e("last_mode_id");
        this.floodlevel = nbt.func_74762_e("floodlevel");
    }
}

