/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.satellite.SatelliteWeatherController;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;

public class ItemWeatherController
extends ItemSatelliteIdentificationChip
implements IModularInventory,
IButtonInventory,
INetworkItem {
    private int floodlevel = 63;

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> list = new LinkedList<ModuleBase>();
        SatelliteWeatherController sat = (SatelliteWeatherController)ItemWeatherController.getSatellite(player.func_184586_b(EnumHand.MAIN_HAND));
        if (player.field_70170_p.field_72995_K) {
            // empty if block
        }
        list.add((ModuleBase)new ModuleButton(32, 40, 1, "dry", (IButtonInventory)this, TextureResources.buttonBuild));
        list.add((ModuleBase)new ModuleButton(32, 64, 0, "rain", (IButtonInventory)this, TextureResources.buttonBuild));
        list.add((ModuleBase)new ModuleButton(32, 88, 2, "flood", (IButtonInventory)this, TextureResources.buttonBuild));
        list.add((ModuleBase)new ModuleButton(90, 91, 3, "", (IButtonInventory)this, TextureResources.buttonLeft, 5, 8));
        list.add((ModuleBase)new ModuleText(100, 91, "y=" + sat.getFloodlevel(), 0x2D2D2D));
        list.add((ModuleBase)new ModuleButton(130, 91, 4, "", (IButtonInventory)this, TextureResources.buttonRight, 5, 8));
        list.add((ModuleBase)new ModulePower(16, 48, sat.getBattery()));
        return list;
    }

    @Override
    public void func_77624_a(@Nonnull ItemStack stack, World player, List<String> list, ITooltipFlag arg5) {
        SatelliteBase sat = SatelliteRegistry.getSatellite(stack);
        SatelliteWeatherController mapping = null;
        if (sat instanceof SatelliteWeatherController) {
            mapping = (SatelliteWeatherController)sat;
        }
        if (!stack.func_77942_o()) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.unprogrammed"));
        } else if (mapping == null) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.biomechanger.nosat"));
        } else if (mapping.getDimensionId() == player.field_73011_w.getDimension()) {
            list.add(LibVulpes.proxy.getLocalizedString("msg.connected"));
            if (mapping.mode_id == 0) {
                list.add("mode: rain - Fills small basins in the terrain with water");
            }
            if (mapping.mode_id == 1) {
                list.add("mode: dry - Drys all water in a radius of 16");
            }
            if (mapping.mode_id == 2) {
                list.add("mode: flood - Floods area with a radius of 16 with water");
            }
        } else {
            list.add(LibVulpes.proxy.getLocalizedString("msg.notconnected"));
        }
        super.func_77624_a(stack, player, list, arg5);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            SatelliteBase sat = SatelliteRegistry.getSatellite(stack);
            if (!(sat instanceof SatelliteWeatherController)) {
                return super.func_77659_a(world, player, hand);
            }
            if (sat != null) {
                if (player.func_70093_af()) {
                    ((SatelliteWeatherController)sat).floodlevel = player.func_180425_c().func_177956_o();
                    PacketHandler.sendToPlayer((BasePacket)new PacketSatellite(sat), (EntityPlayer)player);
                    player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), world, -1, -1, 0);
                } else if (sat.getDimensionId() == world.field_73011_w.getDimension()) {
                    sat.performAction(player, world, player.func_180425_c());
                }
            }
        }
        player.func_184609_a(hand);
        return super.func_77659_a(world, player, hand);
    }

    public String getModularInventoryName() {
        return "item.weatherController.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        SatelliteBase sat = ItemWeatherController.getSatellite(stack);
        if (sat instanceof SatelliteWeatherController) {
            if (buttonId == 0 || buttonId == 1 || buttonId == 2) {
                ((SatelliteWeatherController)sat).mode_id = buttonId;
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
            }
            if (buttonId == 4 && ((SatelliteWeatherController)sat).floodlevel < 180) {
                ++((SatelliteWeatherController)sat).floodlevel;
                Minecraft.func_71410_x().field_71439_g.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), (World)DimensionManager.getWorld((int)sat.getDimensionId()), -1, -1, 0);
            }
            if (buttonId == 3 && ((SatelliteWeatherController)sat).floodlevel > 1) {
                --((SatelliteWeatherController)sat).floodlevel;
                Minecraft.func_71410_x().field_71439_g.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), (World)DimensionManager.getWorld((int)sat.getDimensionId()), -1, -1, 0);
            }
            PacketHandler.sendToServer((BasePacket)new PacketItemModifcation((INetworkItem)this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (byte)buttonId));
        }
    }

    public void writeDataToNetwork(ByteBuf byteBuf, byte b, @Nonnull ItemStack itemStack) {
        SatelliteWeatherController sat = (SatelliteWeatherController)ItemWeatherController.getSatellite(itemStack);
        byteBuf.writeInt(sat.mode_id);
        byteBuf.writeInt(sat.floodlevel);
        byteBuf.writeInt(sat.last_mode_id);
    }

    public void readDataFromNetwork(ByteBuf byteBuf, byte b, NBTTagCompound nbtTagCompound, @Nonnull ItemStack itemStack) {
        nbtTagCompound.func_74768_a("mode_id", byteBuf.readInt());
        nbtTagCompound.func_74768_a("floodlevel", byteBuf.readInt());
        nbtTagCompound.func_74768_a("last_mode_id", byteBuf.readInt());
    }

    public void useNetworkData(EntityPlayer entityPlayer, Side side, byte b, NBTTagCompound nbtTagCompound, @Nonnull ItemStack itemStack) {
        SatelliteWeatherController sat = (SatelliteWeatherController)ItemWeatherController.getSatellite(itemStack);
        sat.mode_id = nbtTagCompound.func_74762_e("mode_id");
        sat.floodlevel = nbtTagCompound.func_74762_e("floodlevel");
        sat.last_mode_id = nbtTagCompound.func_74762_e("last_mode_id");
    }
}

