/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.SidedProxy;
import org.apache.commons.lang3.ArrayUtils;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.watersourcelocked;
import zmaster587.advancedRocketry.integrated_server_and_client_variable_sharing_fix.Afuckinginterface;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.advancedRocketry.util.SpawnListEntryNBT;
import zmaster587.advancedRocketry.util.TerraformingHelper;
import zmaster587.advancedRocketry.util.chunkdata;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.VulpineMath;
import zmaster587.libVulpes.util.ZUtils;

public class DimensionProperties
implements Cloneable,
IDimensionProperties {
    public static final ResourceLocation atmosphere = new ResourceLocation("advancedrocketry:textures/planets/Atmosphere2.png");
    public static final ResourceLocation atmosphereLEO = new ResourceLocation("advancedrocketry:textures/planets/AtmosphereLEO.png");
    public static final ResourceLocation atmGlow = new ResourceLocation("advancedrocketry:textures/planets/atmGlow.png");
    public static final ResourceLocation planetRings = new ResourceLocation("advancedrocketry:textures/planets/rings.png");
    public static final ResourceLocation planetRingsNew = new ResourceLocation("advancedrocketry:textures/planets/ringsnew.png");
    public static final ResourceLocation planetRingShadow = new ResourceLocation("advancedrocketry:textures/planets/ringShadow.png");
    public static final ResourceLocation shadow = new ResourceLocation("advancedrocketry:textures/planets/shadow.png");
    public static final ResourceLocation shadow3 = new ResourceLocation("advancedrocketry:textures/planets/shadow3.png");
    public static final int MAX_ATM_PRESSURE = 1600;
    public static final int MIN_ATM_PRESSURE = 0;
    public static final int MAX_DISTANCE = Integer.MAX_VALUE;
    public static final int MIN_DISTANCE = 1;
    public static final int MAX_GRAVITY = 400;
    public static final int MIN_GRAVITY = 0;
    public boolean isNativeDimension;
    public boolean skyRenderOverride;
    public float[] skyColor;
    public float[] fogColor;
    public float[] ringColor;
    public float gravitationalMultiplier;
    public int orbitalDist;
    public boolean hasOxygen;
    public boolean colorOverride;
    public double peakInsolationMultiplier;
    public double peakInsolationMultiplierWithoutAtmosphere;
    public int averageTemperature;
    public int rotationalPeriod;
    public double orbitTheta;
    public double baseOrbitTheta;
    public double prevOrbitalTheta;
    public double orbitalPhi;
    public double rotationalPhi;
    public boolean isRetrograde;
    public OreGenProperties oreProperties = null;
    public List<ItemStack> laserDrillOres;
    public List<String> geodeOres;
    public List<String> craterOres;
    public String laserDrillOresRaw;
    public String customIcon;
    public float[] sunriseSunsetColors;
    public boolean hasRings;
    public int ringAngle;
    public boolean hasRivers;
    public List<ItemStack> requiredArtifacts;
    public int rainStartLength = 168000;
    public int thunderStartLength = 168000;
    public int rainProlongationLength = 12000;
    public int thunderProlongationLength = 12000;
    private int rainMarker;
    private int thunderMarker;
    IAtmosphere atmosphereType;
    StellarBody star;
    int starId;
    private int originalAtmosphereDensity;
    private int atmosphereDensity;
    private String name = "Temp";
    private LinkedList<BiomeManager.BiomeEntry> allowedBiomes;
    private LinkedList<BiomeManager.BiomeEntry> craterBiomeWeights;
    private boolean isRegistered = false;
    private HashSet<Integer> childPlanets;
    private int parentPlanet;
    private int planetId;
    private boolean isStation;
    private boolean isGasGiant;
    private boolean canGenerateCraters;
    private boolean canGenerateGeodes;
    private boolean canGenerateVolcanoes;
    private boolean canGenerateStructures;
    private boolean canGenerateCaves;
    private boolean canDecorate;
    private boolean overrideDecoration;
    private float craterFrequencyMultiplier;
    private float volcanoFrequencyMultiplier;
    private float geodeFrequencyMultiplier;
    private HashMap<Long, SatelliteBase> satellites;
    private HashMap<Long, SatelliteBase> tickingSatellites;
    private List<Fluid> harvestableAtmosphere;
    private List<SpawnListEntryNBT> spawnableEntities;
    private HashSet<HashedBlockPosition> beaconLocations;
    private IBlockState oceanBlock;
    private IBlockState fillerBlock;
    private int seaLevel;
    private int generatorType;
    @SidedProxy(serverSide="zmaster587.advancedRocketry.integrated_server_and_client_variable_sharing_fix.serverlists", clientSide="zmaster587.advancedRocketry.integrated_server_and_client_variable_sharing_fix.clientlists")
    public static Afuckinginterface proxylists;
    public List<ChunkPos> terraformingChunksAlreadyAdded;
    public List<watersourcelocked> water_source_locked_positions;

    public DimensionProperties(int id) {
        this.resetProperties();
        this.planetId = id;
        this.parentPlanet = -2147483647;
        this.childPlanets = new HashSet();
        this.orbitalPhi = 0.0;
        this.isRetrograde = false;
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.oceanBlock = null;
        this.fillerBlock = null;
        this.laserDrillOres = new ArrayList<ItemStack>();
        this.geodeOres = new ArrayList<String>();
        this.craterOres = new ArrayList<String>();
        this.allowedBiomes = new LinkedList();
        this.craterBiomeWeights = new LinkedList();
        this.satellites = new HashMap();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.tickingSatellites = new HashMap();
        this.isNativeDimension = true;
        this.skyRenderOverride = false;
        this.hasOxygen = true;
        this.colorOverride = false;
        this.peakInsolationMultiplier = -1.0;
        this.peakInsolationMultiplierWithoutAtmosphere = -1.0;
        this.isGasGiant = false;
        this.hasRings = false;
        this.canGenerateCraters = true;
        this.canGenerateGeodes = true;
        this.canGenerateStructures = true;
        this.canGenerateVolcanoes = false;
        this.canGenerateCaves = true;
        this.hasRivers = true;
        this.craterFrequencyMultiplier = 1.0f;
        this.volcanoFrequencyMultiplier = 1.0f;
        this.geodeFrequencyMultiplier = 1.0f;
        this.canDecorate = true;
        this.customIcon = "";
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.spawnableEntities = new LinkedList<SpawnListEntryNBT>();
        this.beaconLocations = new HashSet();
        this.seaLevel = 63;
        this.generatorType = 0;
        this.water_source_locked_positions = new ArrayList<watersourcelocked>();
        this.terraformingChunksAlreadyAdded = new ArrayList<ChunkPos>();
        this.ringAngle = 70;
    }

    public int getRainMarker() {
        return this.rainMarker;
    }

    public int getThunderMarker() {
        return this.thunderMarker;
    }

    public void setRainMarker(int marker) {
        this.rainMarker = marker;
    }

    public void setThunderMarker(int marker) {
        this.thunderMarker = marker;
    }

    public void load_terraforming_helper(boolean reset) {
        if (!net.minecraftforge.common.DimensionManager.getWorld((int)this.getId()).field_72995_K) {
            if (!proxylists.isinitialized(this.getId())) {
                proxylists.initdim(this.getId());
            }
            this.getAverageTemp();
            this.getViableBiomes(false);
            if (reset) {
                proxylists.getChunksFullyTerraformed(this.getId()).clear();
                proxylists.getChunksFullyBiomeChanged(this.getId()).clear();
                this.terraformingChunksAlreadyAdded.clear();
            }
            System.out.println("load helper with protecting blocks: " + proxylists.getProtectingBlocksForDimension(this.getId()).size() + " (" + reset + ")");
            proxylists.sethelper(this.getId(), new TerraformingHelper(this.getId(), this.getBiomesEntries(this.getViableBiomes(false)), proxylists.getChunksFullyTerraformed(this.getId()), proxylists.getChunksFullyBiomeChanged(this.getId())));
            System.out.println("num biomes: " + this.getViableBiomes(false).size());
            Collection list = net.minecraftforge.common.DimensionManager.getWorld((int)this.getId()).func_72863_F().func_189548_a();
            System.out.println("add chunks to tf list");
            if (!list.isEmpty()) {
                for (Chunk chunk : list) {
                    this.add_chunk_to_terraforming_list(chunk);
                }
            }
            System.out.println("ok!");
        }
    }

    public void registerProtectingBlock(BlockPos p) {
        boolean already_registered = false;
        for (BlockPos i : proxylists.getProtectingBlocksForDimension(this.getId())) {
            if (!i.equals((Object)p)) continue;
            already_registered = true;
            break;
        }
        if (!already_registered) {
            proxylists.getProtectingBlocksForDimension(this.getId()).add(p);
            if (proxylists.gethelper(this.getId()) != null) {
                proxylists.gethelper(this.getId()).recalculate_chunk_status();
            }
        }
    }

    public void unregisterProtectingBlock(BlockPos p) {
        for (BlockPos i : proxylists.getProtectingBlocksForDimension(this.getId())) {
            if (!i.equals((Object)p)) continue;
            proxylists.getProtectingBlocksForDimension(this.getId()).remove(i);
            if (proxylists.gethelper(this.getId()) == null) break;
            proxylists.gethelper(this.getId()).recalculate_chunk_status();
            break;
        }
    }

    public void add_block_to_terraforming_queue(BlockPos p) {
        proxylists.gethelper(this.getId()).add_position_to_queue(p);
    }

    public void add_chunk_to_terraforming_list_but_this_time_real_terraforming_and_not_biomechanging(ChunkPos pos) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                this.add_block_to_terraforming_queue(new BlockPos(pos.field_77276_a * 16 + x, 0, pos.field_77275_b * 16 + z));
            }
        }
    }

    public void add_block_to_biomechanging_queue(BlockPos p) {
        proxylists.gethelper(this.getId()).add_position_to_biomechanging_queue(p);
    }

    synchronized boolean chunk_was_added_to_terraforming_list_if_not_add_it(ChunkPos pos) {
        for (ChunkPos i : this.terraformingChunksAlreadyAdded) {
            if (pos.field_77276_a != i.field_77276_a || pos.field_77275_b != i.field_77275_b) continue;
            return true;
        }
        this.terraformingChunksAlreadyAdded.add(new ChunkPos(pos.field_77276_a, pos.field_77275_b));
        return false;
    }

    public void add_chunk_to_terraforming_list(Chunk chunk) {
        if (proxylists.gethelper(this.getId()) != null) {
            boolean chunk_was_already_done = proxylists.getChunksFullyTerraformed(this.getId()).contains(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h));
            if (chunk_was_already_done) {
                return;
            }
            chunkdata current_chunk = proxylists.gethelper(this.getId()).getChunkFromList(chunk.field_76635_g, chunk.field_76647_h);
            if (current_chunk == null || !current_chunk.chunk_fully_biomechanged) {
                if (this.chunk_was_added_to_terraforming_list_if_not_add_it(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h))) {
                    return;
                }
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (current_chunk != null && current_chunk.fully_generated[x][z]) continue;
                        this.add_block_to_biomechanging_queue(new BlockPos(chunk.field_76635_g * 16 + x, 0, chunk.field_76647_h * 16 + z));
                    }
                }
            } else if (!current_chunk.chunk_fully_generated) {
                if (this.chunk_was_added_to_terraforming_list_if_not_add_it(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h))) {
                    return;
                }
                this.add_chunk_to_terraforming_list_but_this_time_real_terraforming_and_not_biomechanging(new ChunkPos(chunk.field_76635_g, chunk.field_76647_h));
            }
        }
    }

    public DimensionProperties(int id, String name) {
        this(id);
        this.name = name;
    }

    public DimensionProperties(int id, boolean shouldRegister) {
        this(id);
        this.isStation = !shouldRegister;
    }

    public static ResourceLocation getAtmosphereResource() {
        return atmosphere;
    }

    public static ResourceLocation getShadowResource() {
        return shadow;
    }

    public static ResourceLocation getAtmosphereLEOResource() {
        return atmosphereLEO;
    }

    public static DimensionProperties createFromNBT(int id, NBTTagCompound nbt) {
        DimensionProperties properties = new DimensionProperties(id);
        properties.readFromNBT(nbt);
        properties.planetId = id;
        return properties;
    }

    public void copyData(DimensionProperties props) {
        this.satellites = props.satellites;
        this.tickingSatellites = props.tickingSatellites;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public OreGenProperties getOreGenProperties(World world) {
        if (this.oreProperties != null) {
            return this.oreProperties;
        }
        return OreGenProperties.getOresForPressure(AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity), Temps.getTempFromValue(this.getAverageTemp()));
    }

    public void resetProperties() {
        this.fogColor = new float[]{1.0f, 1.0f, 1.0f};
        this.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        this.sunriseSunsetColors = new float[]{0.7f, 0.2f, 0.2f, 1.0f};
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.gravitationalMultiplier = 1.0f;
        this.rotationalPeriod = 24000;
        this.orbitalDist = 100;
        this.atmosphereDensity = 100;
        this.originalAtmosphereDensity = 100;
        this.childPlanets = new HashSet();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.parentPlanet = -2147483647;
        this.starId = 0;
        this.averageTemperature = 100;
        this.hasRings = false;
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.spawnableEntities = new LinkedList<SpawnListEntryNBT>();
        this.beaconLocations = new HashSet();
        this.seaLevel = 63;
        this.oceanBlock = null;
        this.fillerBlock = null;
        this.generatorType = 0;
        this.laserDrillOres = new ArrayList<ItemStack>();
    }

    public List<Fluid> getHarvestableGasses() {
        return this.harvestableAtmosphere;
    }

    public List<ItemStack> getRequiredArtifacts() {
        return this.requiredArtifacts;
    }

    @Override
    public float getGravitationalMultiplier() {
        return this.gravitationalMultiplier;
    }

    @Override
    public void setGravitationalMultiplier(float mult) {
        this.gravitationalMultiplier = mult;
    }

    public List<SpawnListEntryNBT> getSpawnListEntries() {
        return this.spawnableEntities;
    }

    @Override
    public float[] getSunColor() {
        return this.getStar().getColor();
    }

    @Override
    public StellarBody getStar() {
        if (this.isStar()) {
            this.star = this.getStarData();
        }
        if (this.star == null) {
            this.star = DimensionManager.getInstance().getStar(this.starId);
        }
        return this.star;
    }

    public boolean hasSurface() {
        return !this.isGasGiant() && !this.isStar();
    }

    @Override
    public boolean isGasGiant() {
        return this.isGasGiant;
    }

    public void setGasGiant(boolean gas) {
        this.isGasGiant = gas;
    }

    public boolean isStar() {
        return this.planetId >= 10000;
    }

    public void setStar(StellarBody star) {
        this.starId = star.getId();
        this.star = star;
        if (!this.isMoon() && !this.isStation()) {
            this.star.addPlanet(this);
        }
    }

    public void setStar(int id) {
        this.starId = id;
        if (DimensionManager.getInstance().getStar(id) != null) {
            this.setStar(DimensionManager.getInstance().getStar(id));
        }
    }

    public StellarBody getStarData() {
        return DimensionManager.getInstance().getStar(this.planetId - 10000);
    }

    @Override
    public boolean hasRings() {
        return this.hasRings;
    }

    public void setHasRings(boolean value) {
        this.hasRings = value;
    }

    public void addBeaconLocation(World world, HashedBlockPosition pos) {
        this.beaconLocations.add(pos);
        DimensionManager.getInstance().knownPlanets.add(this.getId());
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    public HashSet<HashedBlockPosition> getBeacons() {
        return this.beaconLocations;
    }

    public void removeBeaconLocation(World world, HashedBlockPosition pos) {
        this.beaconLocations.remove(pos);
        if (this.beaconLocations.isEmpty() && !ARConfiguration.getCurrentConfig().initiallyKnownPlanets.contains(this.getId())) {
            DimensionManager.getInstance().knownPlanets.remove(this.getId());
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    @Override
    public ResourceLocation getPlanetIcon() {
        if (!this.customIcon.isEmpty()) {
            try {
                String resource_location = "advancedrocketry:textures/planets/" + this.customIcon.toLowerCase() + ".png";
                if (TextureResources.planetResources.containsKey(resource_location)) {
                    return TextureResources.planetResources.get(resource_location);
                }
                ResourceLocation new_resource = new ResourceLocation(resource_location);
                TextureResources.planetResources.put(resource_location, new_resource);
                return new_resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.getAverageTemp());
        if (this.isStar() && this.getStarData().isBlackHole()) {
            return TextureResources.locationBlackHole_icon;
        }
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resource;
        }
        if (this.isAsteroid()) {
            return PlanetIcons.ASTEROID.resource;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resource;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resource;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resource;
            }
            return PlanetIcons.ICEWORLD.resource;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resource;
            }
            return PlanetIcons.MOON.resource;
        }
        return PlanetIcons.LAVA.resource;
    }

    @Override
    public ResourceLocation getPlanetIconLEO() {
        if (!this.customIcon.isEmpty()) {
            try {
                String resource_location = "advancedrocketry:textures/planets/" + this.customIcon.toLowerCase() + "leo.jpg";
                if (TextureResources.planetResources.containsKey(resource_location)) {
                    return TextureResources.planetResources.get(resource_location);
                }
                ResourceLocation new_resource = new ResourceLocation(resource_location);
                TextureResources.planetResources.put(resource_location, new_resource);
                return new_resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.getAverageTemp());
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resourceLEO;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resourceLEO;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resourceLEO;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resourceLEO;
            }
            return PlanetIcons.ICEWORLD.resourceLEO;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resourceLEO;
            }
            return PlanetIcons.MOON.resourceLEO;
        }
        return PlanetIcons.LAVA.resourceLEO;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getId() {
        return this.planetId;
    }

    public void setId(int id) {
        this.planetId = id;
    }

    @Override
    public int getParentPlanet() {
        return this.parentPlanet;
    }

    public void setParentPlanet(DimensionProperties parent) {
        this.setParentPlanet(parent, true);
    }

    @Override
    public DimensionProperties getParentProperties() {
        if (this.parentPlanet != -2147483647) {
            return DimensionManager.getInstance().getDimensionProperties(this.parentPlanet);
        }
        return null;
    }

    @Override
    public int getParentOrbitalDistance() {
        return this.orbitalDist;
    }

    @Override
    public void setParentOrbitalDistance(int distance) {
        this.orbitalDist = distance;
    }

    @Override
    public int getSolarOrbitalDistance() {
        if (this.isStar()) {
            return 1;
        }
        if (this.parentPlanet != -2147483647) {
            return this.getParentProperties().getSolarOrbitalDistance();
        }
        return this.orbitalDist;
    }

    public double getSolarTheta() {
        if (this.parentPlanet != -2147483647) {
            return this.getParentProperties().getSolarTheta();
        }
        return this.orbitTheta;
    }

    public void setParentPlanet(DimensionProperties parent, boolean update) {
        if (update) {
            if (this.parentPlanet != -2147483647) {
                this.getParentProperties().childPlanets.remove(this.getId());
            }
            if (parent == null) {
                this.parentPlanet = -2147483647;
            } else {
                this.parentPlanet = parent.getId();
                this.star = parent.getStar();
                if (parent.getId() != -2147483647) {
                    parent.childPlanets.add(this.getId());
                }
            }
        } else if (parent == null) {
            this.parentPlanet = -2147483647;
        } else {
            this.star = parent.getStar();
            this.starId = this.star.getId();
            this.parentPlanet = parent.getId();
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.childPlanets.isEmpty();
    }

    @Override
    public boolean isMoon() {
        return this.parentPlanet != -2147483647 && this.parentPlanet != Integer.MIN_VALUE;
    }

    @Override
    public int getAtmosphereDensity() {
        return this.atmosphereDensity;
    }

    @Override
    public void setAtmosphereDensity(int atmosphereDensity) {
        int prevAtm = this.atmosphereDensity;
        this.atmosphereDensity = atmosphereDensity;
        this.load_terraforming_helper(true);
        PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
    }

    public void setAtmosphereDensityDirect(int atmosphereDensity) {
        this.originalAtmosphereDensity = this.atmosphereDensity = atmosphereDensity;
    }

    public boolean isStation() {
        return this.isStation;
    }

    @Override
    public IAtmosphere getAtmosphere() {
        if (this.hasAtmosphere() && this.hasOxygen) {
            if (this.averageTemperature >= 900) {
                return AtmosphereType.SUPERHEATED;
            }
            if (Temps.getTempFromValue(this.getAverageTemp()) == Temps.TOOHOT) {
                return AtmosphereType.VERYHOT;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.SUPERHIGHPRESSURE) {
                return AtmosphereType.SUPERHIGHPRESSURE;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.HIGHPRESSURE) {
                return AtmosphereType.HIGHPRESSURE;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.LOW) {
                return AtmosphereType.LOWOXYGEN;
            }
            return AtmosphereType.AIR;
        }
        if (this.hasAtmosphere() && !this.hasOxygen) {
            if (this.averageTemperature >= 900) {
                return AtmosphereType.SUPERHEATEDNOO2;
            }
            if (Temps.getTempFromValue(this.averageTemperature) == Temps.TOOHOT) {
                return AtmosphereType.VERYHOTNOO2;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.SUPERHIGHPRESSURE) {
                return AtmosphereType.SUPERHIGHPRESSURENOO2;
            }
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.HIGHPRESSURE) {
                return AtmosphereType.HIGHPRESSURENOO2;
            }
            return AtmosphereType.NOO2;
        }
        return AtmosphereType.VACUUM;
    }

    @Override
    public boolean hasAtmosphere() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity).compareTo(AtmosphereTypes.NONE) < 0;
    }

    @Override
    public double getPeakInsolationMultiplier() {
        double insolationRelativeToLEO = AstronomicalBodyHelper.getStellarBrightness(this.getStar(), this.getSolarOrbitalDistance()) * Math.pow(Math.E, -(0.0026899 * (double)this.getAtmosphereDensity()));
        this.peakInsolationMultiplier = insolationRelativeToLEO * 1.308;
        return this.peakInsolationMultiplier;
    }

    @Override
    public double getPeakInsolationMultiplierWithoutAtmosphere() {
        this.peakInsolationMultiplierWithoutAtmosphere = AstronomicalBodyHelper.getStellarBrightness(this.getStar(), this.getSolarOrbitalDistance()) * 1.308;
        return this.peakInsolationMultiplierWithoutAtmosphere;
    }

    public boolean isAsteroid() {
        return this.generatorType == 2;
    }

    public boolean hasDecorators() {
        return !this.isAsteroid() && !this.isStar() || this.canDecorate && this.overrideDecoration;
    }

    public void setDecoratoration(boolean value) {
        this.canDecorate = value;
        this.overrideDecoration = true;
    }

    public boolean isDecorationOverridden() {
        return this.overrideDecoration;
    }

    public void unsetDecoratoration() {
        this.overrideDecoration = false;
    }

    @Override
    public Set<Integer> getChildPlanets() {
        return this.childPlanets;
    }

    @Override
    public int getPathLengthToStar() {
        if (this.isMoon()) {
            return 1 + this.getParentProperties().getPathLengthToStar();
        }
        return 1;
    }

    public boolean addChildPlanet(DimensionProperties child) {
        if (child == this) {
            return false;
        }
        this.childPlanets.add(child.getId());
        child.setParentPlanet(this);
        return true;
    }

    public void removeChild(int id) {
        this.childPlanets.remove(id);
    }

    @Override
    public void addSatellite(SatelliteBase satellite, World world) {
        if (this.satellites.containsKey(satellite.getId())) {
            this.satellites.remove(satellite.getId());
            this.tickingSatellites.remove(satellite.getId());
        }
        this.satellites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatellites.put(satellite.getId(), satellite);
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    public void addSatellite(SatelliteBase satellite, int world, boolean isRemote) {
        if (this.satellites.containsKey(satellite.getId())) {
            this.satellites.remove(satellite.getId());
            this.tickingSatellites.remove(satellite.getId());
        }
        this.satellites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatellites.put(satellite.getId(), satellite);
        }
        if (!isRemote) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    @Override
    public void addSatellite(SatelliteBase satellite) {
        if (this.satellites.containsKey(satellite.getId())) {
            this.satellites.remove(satellite.getId());
            this.tickingSatellites.remove(satellite.getId());
        }
        this.satellites.put(satellite.getId(), satellite);
        if (satellite.canTick()) {
            this.tickingSatellites.put(satellite.getId(), satellite);
        }
    }

    @Override
    public SatelliteBase removeSatellite(long satelliteId) {
        SatelliteBase satellite = this.satellites.remove(satelliteId);
        if (satellite != null && satellite.canTick() && this.tickingSatellites.containsKey(satelliteId)) {
            this.tickingSatellites.get(satelliteId).setDead();
        }
        return satellite;
    }

    @Override
    public SatelliteBase getSatellite(long id) {
        return this.satellites.get(id);
    }

    @Override
    public Collection<SatelliteBase> getAllSatellites() {
        return this.satellites.values();
    }

    public Collection<SatelliteBase> getTickingSatellites() {
        return this.tickingSatellites.values();
    }

    public void tick() {
        TerraformingHelper t;
        Iterator<SatelliteBase> iterator = this.tickingSatellites.values().iterator();
        while (iterator.hasNext()) {
            SatelliteBase satellite = iterator.next();
            satellite.tickEntity();
            if (!satellite.isDead()) continue;
            iterator.remove();
            this.satellites.remove(satellite.getId());
            break;
        }
        this.updateOrbit();
        Iterator<watersourcelocked> iterator_2 = this.water_source_locked_positions.iterator();
        while (iterator_2.hasNext()) {
            watersourcelocked i = iterator_2.next();
            --i.timer;
            if (i.timer > 0) continue;
            BlockPos p = i.pos.getBlockPos();
            iterator_2.remove();
            WorldServer world = net.minecraftforge.common.DimensionManager.getWorld((int)this.getId());
            world.func_175685_c(p, world.func_180495_p(p).func_177230_c(), false);
        }
        WorldServer world = net.minecraftforge.common.DimensionManager.getWorld((int)this.getId());
        if (world != null && proxylists.gethelper(this.getId()) != null && (t = proxylists.gethelper(this.getId())).has_blocks_in_dec_queue()) {
            BlockPos target;
            for (int i = 0; i < 5 && (target = t.get_next_position_decoration(true)) != null; ++i) {
                BiomeHandler.do_decoration((World)world, target, this.getId());
            }
        }
    }

    public void add_water_locked_pos(HashedBlockPosition pos) {
        for (watersourcelocked i : this.water_source_locked_positions) {
            if (!i.pos.equals((Object)pos)) continue;
            i.reset_timer();
            return;
        }
        this.water_source_locked_positions.add(new watersourcelocked(pos));
    }

    public void updateOrbit() {
        this.prevOrbitalTheta = this.orbitTheta;
        if (this.isMoon()) {
            this.orbitTheta = (AstronomicalBodyHelper.getMoonOrbitalTheta(this.orbitalDist, this.getParentProperties().gravitationalMultiplier) + this.baseOrbitTheta) * (double)(this.isRetrograde ? -1 : 1);
        } else if (!this.isMoon()) {
            this.orbitTheta = (AstronomicalBodyHelper.getOrbitalTheta(this.orbitalDist, this.getStar().getSize()) + this.baseOrbitTheta) * (double)(this.isRetrograde ? -1 : 1);
        }
    }

    public boolean hasRivers() {
        return this.hasRivers || AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity).compareTo(AtmosphereTypes.LOW) <= 0 && Temps.getTempFromValue(this.getAverageTemp()).isInRange(Temps.COLD, Temps.HOT);
    }

    public List<BiomeManager.BiomeEntry> getBiomes() {
        return this.allowedBiomes;
    }

    public void setBiomes(List<Biome> biomes) {
        this.allowedBiomes.clear();
        this.addBiomes(biomes);
    }

    public boolean isBiomeblackListed(Biome biome, boolean is_NOT_terraforming) {
        if (!is_NOT_terraforming) {
            String modId = biome.getRegistryName().func_110624_b();
            if (!(ARConfiguration.getCurrentConfig().allowNonArBiomesInTerraforming || modId.equals("minecraft") || modId.equals("advancedrocketry"))) {
                return true;
            }
        }
        if (biome.equals(AdvancedRocketryBiomes.spaceBiome)) {
            return true;
        }
        return AdvancedRocketryBiomes.instance.getBlackListedBiomes().contains(Biome.func_185362_a((Biome)biome));
    }

    public List<Biome> getViableBiomes(boolean not_terraforming) {
        Random random = new Random(System.nanoTime());
        ArrayList<Biome> viableBiomes = new ArrayList<Biome>();
        if (this.atmosphereDensity > AtmosphereTypes.LOW.value && random.nextInt(3) == 0 && not_terraforming) {
            LinkedList<Biome> list = new LinkedList<Biome>(AdvancedRocketryBiomes.instance.getSingleBiome());
            while (list.size() > 1) {
                Biome biome = (Biome)list.get(random.nextInt(list.size()));
                Temps temp = Temps.getTempFromValue(this.averageTemperature);
                if (biome.func_150561_m() == Biome.TempCategory.COLD && temp.isInRange(Temps.FRIGID, Temps.NORMAL) || (biome.func_150561_m() == Biome.TempCategory.MEDIUM || biome.func_150561_m() == Biome.TempCategory.OCEAN) && temp.isInRange(Temps.COLD, Temps.HOT) || biome.func_150561_m() == Biome.TempCategory.WARM && temp.isInRange(Temps.NORMAL, Temps.HOT)) {
                    viableBiomes.add(biome);
                    return viableBiomes;
                }
                list.remove(biome);
            }
        }
        if (this.atmosphereDensity <= AtmosphereTypes.LOW.value) {
            viableBiomes.add(AdvancedRocketryBiomes.moonBiome);
            viableBiomes.add(AdvancedRocketryBiomes.moonBiomeDark);
        } else if (Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.TOOHOT)) {
            viableBiomes.add(AdvancedRocketryBiomes.hotDryBiome);
            viableBiomes.add(AdvancedRocketryBiomes.volcanic);
            viableBiomes.add(AdvancedRocketryBiomes.volcanicBarren);
        } else if (Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.HOT)) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HOT) && !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.OCEAN) || this.isBiomeblackListed(biome, not_terraforming)) continue;
                viableBiomes.add(biome);
            }
        } else if (Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.NORMAL)) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome, not_terraforming)) continue;
                viableBiomes.add(biome);
            }
        } else if (Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.COLD)) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.HOT) || this.isBiomeblackListed(biome, not_terraforming)) continue;
                viableBiomes.add(biome);
            }
        } else if (Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.FRIGID)) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome, not_terraforming)) continue;
                viableBiomes.add(biome);
            }
        } else {
            for (Biome biome : Biome.field_185377_q) {
                if (biome == null || !BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome, not_terraforming)) continue;
                viableBiomes.add(biome);
            }
        }
        int maxBiomesPerPlanet = ARConfiguration.getCurrentConfig().maxBiomesPerPlanet;
        if (viableBiomes.size() > maxBiomesPerPlanet) {
            viableBiomes = ZUtils.copyRandomElements(viableBiomes, (int)maxBiomesPerPlanet);
        }
        if (this.atmosphereDensity > AtmosphereTypes.HIGHPRESSURE.value && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.NORMAL, Temps.HOT)) {
            viableBiomes.addAll(AdvancedRocketryBiomes.instance.getHighPressureBiomes());
        }
        return viableBiomes;
    }

    public void addCraterBiomeWeight(Biome biome, int frequency) {
        ArrayList<BiomeManager.BiomeEntry> biomes = new ArrayList<BiomeManager.BiomeEntry>();
        biomes.add(new BiomeManager.BiomeEntry(biome, Math.min(Math.max(0, frequency), 100)));
        this.craterBiomeWeights.addAll(biomes);
    }

    public List<BiomeManager.BiomeEntry> getCraterBiomeWeights() {
        return this.craterBiomeWeights;
    }

    public void addBiomeWeighted(Biome biome, int weight) {
        ArrayList<BiomeManager.BiomeEntry> biomes = new ArrayList<BiomeManager.BiomeEntry>();
        biomes.add(new BiomeManager.BiomeEntry(biome, weight));
        this.allowedBiomes.addAll(biomes);
    }

    public void addBiome(Biome biome) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        biomes.add(biome);
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public boolean addBiome(int biomeId) {
        Biome biome = Biome.func_150568_d((int)biomeId);
        if (biomeId == 0 || Biome.func_185362_a((Biome)biome) != 0) {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            biomes.add(biome);
            this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
            return true;
        }
        return false;
    }

    public void addBiomes(List<Biome> biomes) {
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public void setBiomeEntries(List<BiomeManager.BiomeEntry> biomes) {
        if (biomes != this.allowedBiomes) {
            this.allowedBiomes.clear();
            this.allowedBiomes.addAll(biomes);
        }
    }

    public void addBiomeType(BiomeDictionary.Type type) {
        ArrayList<Biome> entryList = new ArrayList<Biome>(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        entryList.remove(Biome.func_150568_d((int)8));
        entryList.remove(Biome.func_150568_d((int)9));
        Iterator iter = entryList.iterator();
        while (iter.hasNext()) {
            Biome nextBiome = (Biome)iter.next();
            for (BiomeManager.BiomeEntry entry : this.allowedBiomes) {
                if (!BiomeDictionary.areSimilar((Biome)entry.biome, (Biome)nextBiome)) continue;
                iter.remove();
            }
        }
        this.allowedBiomes.addAll(this.getBiomesEntries(entryList));
    }

    public void removeBiomeType(BiomeDictionary.Type type) {
        for (Biome biome : Biome.field_185377_q) {
            this.allowedBiomes.removeIf(biomeEntry -> BiomeDictionary.areSimilar((Biome)biomeEntry.biome, (Biome)biome));
        }
    }

    private ArrayList<BiomeManager.BiomeEntry> getBiomesEntries(List<Biome> biomeIds) {
        ArrayList<BiomeManager.BiomeEntry> biomeEntries = new ArrayList<BiomeManager.BiomeEntry>();
        for (Biome biomes : biomeIds) {
            boolean notFound = true;
            block1: for (BiomeManager.BiomeType types : BiomeManager.BiomeType.values()) {
                for (BiomeManager.BiomeEntry entry : BiomeManager.getBiomes((BiomeManager.BiomeType)types)) {
                    if (biomes == null) {
                        AdvancedRocketry.logger.warn("Null biomes loaded for DIMID: " + this.getId());
                        continue;
                    }
                    if (!entry.biome.equals(biomes)) continue;
                    biomeEntries.add(entry);
                    notFound = false;
                    break block1;
                }
            }
            if (!notFound || biomes == null) continue;
            biomeEntries.add(new BiomeManager.BiomeEntry(biomes, 30));
        }
        return biomeEntries;
    }

    public void initDefaultAttributes() {
        if (Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.TOOHOT)) {
            this.setOceanBlock(Blocks.field_150353_l.func_176223_P());
        }
        this.setGenerateCraters(AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()).lessDenseThan(AtmosphereTypes.NORMAL));
        this.setGenerateVolcanos(Temps.getTempFromValue(this.averageTemperature).hotterOrEquals(Temps.HOT));
        this.setGenerateStructures(this.isHabitable());
        this.setGenerateGeodes(this.getAtmosphereDensity() > 125);
    }

    private void readFromTechnicalNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("beaconLocations")) {
            NBTTagList list = nbt.func_150295_c("beaconLocations", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] location = list.func_150306_c(i);
                this.beaconLocations.add(new HashedBlockPosition(location[0], location[1], location[2]));
            }
            DimensionManager.getInstance().knownPlanets.add(this.getId());
        } else {
            this.beaconLocations.clear();
        }
        if (nbt.func_74764_b("satallites")) {
            NBTTagCompound allSatelliteNBT = nbt.func_74775_l("satallites");
            for (String keyObject : allSatelliteNBT.func_150296_c()) {
                Long longKey = Long.parseLong(keyObject);
                NBTTagCompound satelliteNBT = allSatelliteNBT.func_74775_l(keyObject);
                if (this.satellites.containsKey(longKey)) {
                    this.satellites.get(longKey).readFromNBT(satelliteNBT);
                    continue;
                }
                try {
                    SatelliteBase satellite = SatelliteRegistry.createFromNBT(satelliteNBT);
                    this.satellites.put(longKey, satellite);
                    if (!satellite.canTick()) continue;
                    this.tickingSatellites.put(satellite.getId(), satellite);
                }
                catch (NullPointerException e) {
                    AdvancedRocketry.logger.warn("Satellite with bad NBT detected, Removing");
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i2;
        ArrayList<BiomeManager.BiomeEntry> biomesList;
        int[] biomeWeights;
        int f;
        NBTTagList list;
        if (nbt.func_74764_b("skyColor")) {
            list = nbt.func_150295_c("skyColor", 5);
            this.skyColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.skyColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("ringColor")) {
            list = nbt.func_150295_c("ringColor", 5);
            this.ringColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.ringColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("sunriseSunsetColors")) {
            list = nbt.func_150295_c("sunriseSunsetColors", 5);
            this.sunriseSunsetColors = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.sunriseSunsetColors[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("fogColor")) {
            list = nbt.func_150295_c("fogColor", 5);
            this.fogColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.fogColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("biomes")) {
            this.allowedBiomes.clear();
            int[] biomeIds = nbt.func_74759_k("biomes");
            biomeWeights = nbt.func_74759_k("weights");
            if (biomeWeights.length == 0) {
                biomeWeights = new int[biomeIds.length];
                Arrays.fill(biomeWeights, 30);
            }
            biomesList = new ArrayList<BiomeManager.BiomeEntry>();
            for (i2 = 0; i2 < biomeIds.length; ++i2) {
                biomesList.add(new BiomeManager.BiomeEntry(AdvancedRocketryBiomes.instance.getBiomeById(biomeIds[i2]), biomeWeights[i2]));
            }
            this.allowedBiomes.addAll(biomesList);
        }
        if (nbt.func_74764_b("craterBiomes")) {
            this.craterBiomeWeights.clear();
            int[] biomeIds = nbt.func_74759_k("craterBiomes");
            biomeWeights = nbt.func_74759_k("craterWeights");
            biomesList = new ArrayList();
            for (i2 = 0; i2 < biomeIds.length; ++i2) {
                biomesList.add(new BiomeManager.BiomeEntry(AdvancedRocketryBiomes.instance.getBiomeById(biomeIds[i2]), biomeWeights[i2]));
            }
            this.craterBiomeWeights.addAll(biomesList);
        }
        if (nbt.func_74764_b("laserDrillOres")) {
            this.laserDrillOres.clear();
            list = nbt.func_150295_c("laserDrillOres", 10);
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagCompound);
                this.laserDrillOres.add(new ItemStack((NBTTagCompound)entry));
            }
        }
        if (nbt.func_74764_b("laserDrillOresRaw")) {
            this.laserDrillOresRaw = nbt.func_74779_i("laserDrillOresRaw");
        }
        if (nbt.func_74764_b("geodeOres")) {
            this.geodeOres.clear();
            list = nbt.func_150295_c("geodeOres", 8);
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagString);
                this.geodeOres.add(((NBTTagString)entry).func_150285_a_());
            }
        }
        if (nbt.func_74764_b("craterOres")) {
            this.craterOres.clear();
            list = nbt.func_150295_c("craterOres", 8);
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagString);
                this.craterOres.add(((NBTTagString)entry).func_150285_a_());
            }
        }
        if (nbt.func_74764_b("artifacts")) {
            this.requiredArtifacts.clear();
            list = nbt.func_150295_c("artifacts", 10);
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagCompound);
                this.requiredArtifacts.add(new ItemStack((NBTTagCompound)entry));
            }
        }
        this.gravitationalMultiplier = nbt.func_74760_g("gravitationalMultiplier");
        this.orbitalDist = nbt.func_74762_e("orbitalDist");
        this.orbitTheta = nbt.func_74769_h("orbitTheta");
        this.baseOrbitTheta = nbt.func_74769_h("baseOrbitTheta");
        this.orbitalPhi = nbt.func_74769_h("orbitPhi");
        this.rotationalPhi = nbt.func_74769_h("rotationalPhi");
        this.isRetrograde = nbt.func_74767_n("isRetrograde");
        this.hasOxygen = nbt.func_74767_n("hasOxygen");
        this.colorOverride = nbt.func_74767_n("colorOverride");
        this.atmosphereDensity = nbt.func_74762_e("atmosphereDensity");
        this.originalAtmosphereDensity = nbt.func_74764_b("originalAtmosphereDensity") ? nbt.func_74762_e("originalAtmosphereDensity") : this.atmosphereDensity;
        this.peakInsolationMultiplier = nbt.func_74769_h("peakInsolationMultiplier");
        this.peakInsolationMultiplierWithoutAtmosphere = nbt.func_74769_h("peakInsolationMultiplierWithoutAtmosphere");
        this.averageTemperature = nbt.func_74762_e("avgTemperature");
        this.rotationalPeriod = nbt.func_74762_e("rotationalPeriod");
        this.name = nbt.func_74779_i("name");
        this.customIcon = nbt.func_74779_i("icon");
        this.isNativeDimension = !nbt.func_74764_b("isNative") || nbt.func_74767_n("isNative");
        this.isGasGiant = nbt.func_74767_n("isGasGiant");
        this.hasRings = nbt.func_74767_n("hasRings");
        this.ringAngle = nbt.func_74762_e("ringAngle");
        this.seaLevel = nbt.func_74762_e("sealevel");
        this.generatorType = nbt.func_74762_e("genType");
        this.canGenerateCraters = nbt.func_74767_n("canGenerateCraters");
        this.canGenerateGeodes = nbt.func_74767_n("canGenerateGeodes");
        this.canGenerateStructures = nbt.func_74767_n("canGenerateStructures");
        this.canGenerateVolcanoes = nbt.func_74767_n("canGenerateVolcanos");
        this.canGenerateCaves = nbt.func_74767_n("canGenerateCaves");
        this.hasRivers = nbt.func_74767_n("hasRivers");
        this.geodeFrequencyMultiplier = nbt.func_74760_g("geodeFrequencyMultiplier");
        this.craterFrequencyMultiplier = nbt.func_74760_g("craterFrequencyMultiplier");
        this.volcanoFrequencyMultiplier = nbt.func_74760_g("volcanoFrequencyMultiplier");
        this.rainStartLength = nbt.func_74762_e("rainStartLength");
        this.thunderStartLength = nbt.func_74762_e("thunderStartLength");
        this.rainProlongationLength = nbt.func_74762_e("rainProlongationLength");
        this.thunderProlongationLength = nbt.func_74762_e("thunderProlongationLength");
        this.rainMarker = nbt.func_74762_e("rainMarker");
        this.thunderMarker = nbt.func_74762_e("thunderMarker");
        if (nbt.func_74764_b("childrenPlanets")) {
            for (int i2 : nbt.func_74759_k("childrenPlanets")) {
                this.childPlanets.add(i2);
            }
        }
        this.parentPlanet = nbt.func_74762_e("parentPlanet");
        this.setStar(DimensionManager.getInstance().getStar(nbt.func_74762_e("starId")));
        if (this.isGasGiant) {
            NBTTagList fluidList = nbt.func_150295_c("fluids", 8);
            this.getHarvestableGasses().clear();
            for (int i3 = 0; i3 < fluidList.func_74745_c(); ++i3) {
                Fluid fluid = FluidRegistry.getFluid((String)fluidList.func_150307_f(i3));
                if (fluid == null) continue;
                this.getHarvestableGasses().add(fluid);
            }
            if (this.getHarvestableGasses().isEmpty()) {
                this.getHarvestableGasses().addAll(AtmosphereRegister.getInstance().getHarvestableGasses());
            }
        }
        if (nbt.func_74764_b("oceanBlock")) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("oceanBlock")));
            if (block == Blocks.field_150350_a) {
                this.oceanBlock = null;
            } else {
                int meta = nbt.func_74762_e("oceanBlockMeta");
                this.oceanBlock = block.func_176203_a(meta);
            }
        } else {
            this.oceanBlock = null;
        }
        if (nbt.func_74764_b("fillBlock")) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("fillBlock")));
            if (block == Blocks.field_150350_a) {
                this.fillerBlock = null;
            } else {
                int meta = nbt.func_74762_e("fillBlockMeta");
                this.fillerBlock = block.func_176203_a(meta);
            }
        } else {
            this.fillerBlock = null;
        }
        this.readFromTechnicalNBT(nbt);
    }

    private void writeTechnicalNBT(NBTTagCompound nbt) {
        if (!this.beaconLocations.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (HashedBlockPosition pos : this.beaconLocations) {
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.x, pos.y, pos.z}));
            }
            nbt.func_74782_a("beaconLocations", (NBTBase)list);
        }
        if (!this.satellites.isEmpty()) {
            NBTTagCompound allSatelliteNBT = new NBTTagCompound();
            for (Map.Entry<Long, SatelliteBase> entry : this.satellites.entrySet()) {
                NBTTagCompound satelliteNBT = new NBTTagCompound();
                entry.getValue().writeToNBT(satelliteNBT);
                allSatelliteNBT.func_74782_a(entry.getKey().toString(), (NBTBase)satelliteNBT);
            }
            nbt.func_74782_a("satallites", (NBTBase)allSatelliteNBT);
        }
    }

    public void read_terraforming_data(NBTTagCompound nbt) {
        boolean chunk_was_already_done;
        int z;
        int x;
        NBTTagList list;
        int dimid = this.getId();
        if (!proxylists.isinitialized(dimid)) {
            proxylists.initdim(dimid);
        }
        if (nbt.func_74764_b("fullyGeneratedChunks")) {
            list = nbt.func_150295_c("fullyGeneratedChunks", 10);
            if (!list.func_82582_d()) {
                proxylists.setChunksFullyTerraformed(dimid, new HashSet<ChunkPos>());
            }
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagCompound);
                x = ((NBTTagCompound)entry).func_74762_e("x");
                z = ((NBTTagCompound)entry).func_74762_e("z");
                System.out.println("Chunk fully terraformed: " + x + ":" + z);
                chunk_was_already_done = false;
                for (ChunkPos i : proxylists.getChunksFullyTerraformed(dimid)) {
                    if (x != i.field_77276_a || z != i.field_77275_b) continue;
                    chunk_was_already_done = true;
                    break;
                }
                if (!chunk_was_already_done) {
                    proxylists.getChunksFullyTerraformed(dimid).add(new ChunkPos(x, z));
                    continue;
                }
                System.out.println("Chunk is already in list: " + x + ":" + z);
            }
        }
        if (nbt.func_74764_b("fullyBiomeChangedChunks")) {
            list = nbt.func_150295_c("fullyBiomeChangedChunks", 10);
            if (!list.func_82582_d()) {
                proxylists.setChunksFullyBiomeChanged(dimid, new HashSet<ChunkPos>());
            }
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagCompound);
                x = ((NBTTagCompound)entry).func_74762_e("x");
                z = ((NBTTagCompound)entry).func_74762_e("z");
                System.out.println("Chunk fully biome changed: " + x + ":" + z);
                chunk_was_already_done = false;
                for (ChunkPos i : proxylists.getChunksFullyBiomeChanged(dimid)) {
                    if (x != i.field_77276_a || z != i.field_77275_b) continue;
                    chunk_was_already_done = true;
                    break;
                }
                if (!chunk_was_already_done) {
                    proxylists.getChunksFullyBiomeChanged(dimid).add(new ChunkPos(x, z));
                    continue;
                }
                System.out.println("Chunk is already in list: " + x + ":" + z);
            }
        }
        if (nbt.func_74764_b("terraformingProtectedBlocks")) {
            list = nbt.func_150295_c("terraformingProtectedBlocks", 10);
            if (!list.func_82582_d()) {
                proxylists.setProtectingBlocksForDimension(dimid, new ArrayList<BlockPos>());
            }
            for (NBTBase entry : list) {
                assert (entry instanceof NBTTagCompound);
                x = ((NBTTagCompound)entry).func_74762_e("x");
                z = ((NBTTagCompound)entry).func_74762_e("z");
                int y = ((NBTTagCompound)entry).func_74762_e("y");
                proxylists.getProtectingBlocksForDimension(dimid).add(new BlockPos(x, y, z));
                System.out.println("read protecting block at " + x + ":" + y + ":" + z + " - - " + proxylists.getProtectingBlocksForDimension(dimid).size());
            }
        }
    }

    public void write_terraforming_data(NBTTagCompound nbt) {
        NBTTagCompound entry;
        int dimid = this.getId();
        if (!proxylists.isinitialized(dimid)) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (ChunkPos chunkPos : proxylists.getChunksFullyTerraformed(dimid)) {
            entry = new NBTTagCompound();
            entry.func_74768_a("x", chunkPos.field_77276_a);
            entry.func_74768_a("z", chunkPos.field_77275_b);
            list.func_74742_a((NBTBase)entry);
        }
        nbt.func_74782_a("fullyGeneratedChunks", (NBTBase)list);
        list = new NBTTagList();
        for (ChunkPos chunkPos : proxylists.getChunksFullyBiomeChanged(dimid)) {
            entry = new NBTTagCompound();
            entry.func_74768_a("x", chunkPos.field_77276_a);
            entry.func_74768_a("z", chunkPos.field_77275_b);
            list.func_74742_a((NBTBase)entry);
        }
        nbt.func_74782_a("fullyBiomeChangedChunks", (NBTBase)list);
        list = new NBTTagList();
        for (BlockPos blockPos : proxylists.getProtectingBlocksForDimension(dimid)) {
            entry = new NBTTagCompound();
            entry.func_74768_a("x", blockPos.func_177958_n());
            entry.func_74768_a("y", blockPos.func_177956_o());
            entry.func_74768_a("z", blockPos.func_177952_p());
            list.func_74742_a((NBTBase)entry);
        }
        nbt.func_74782_a("terraformingProtectedBlocks", (NBTBase)list);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        int i;
        Object biomeId;
        NBTTagList list;
        if (this.skyColor != null) {
            list = new NBTTagList();
            for (float f : this.skyColor) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("skyColor", (NBTBase)list);
        }
        if (this.sunriseSunsetColors != null) {
            list = new NBTTagList();
            for (float f : this.sunriseSunsetColors) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("sunriseSunsetColors", (NBTBase)list);
        }
        list = new NBTTagList();
        for (float f : this.fogColor) {
            list.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        nbt.func_74782_a("fogColor", (NBTBase)list);
        if (this.hasRings) {
            nbt.func_74768_a("ringAngle", this.ringAngle);
            list = new NBTTagList();
            for (float f : this.ringColor) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("ringColor", (NBTBase)list);
        }
        if (!this.allowedBiomes.isEmpty()) {
            biomeId = new int[this.allowedBiomes.size()];
            int[] weights = new int[this.allowedBiomes.size()];
            for (i = 0; i < this.allowedBiomes.size(); ++i) {
                biomeId[i] = Biome.func_185362_a((Biome)this.allowedBiomes.get((int)i).biome);
                weights[i] = this.allowedBiomes.get((int)i).field_76292_a;
            }
            nbt.func_74783_a("biomes", (int[])biomeId);
            nbt.func_74783_a("weights", weights);
        }
        if (!this.craterBiomeWeights.isEmpty()) {
            biomeId = new int[this.craterBiomeWeights.size()];
            int[] weights = new int[this.craterBiomeWeights.size()];
            for (i = 0; i < this.craterBiomeWeights.size(); ++i) {
                biomeId[i] = Biome.func_185362_a((Biome)this.craterBiomeWeights.get((int)i).biome);
                weights[i] = this.craterBiomeWeights.get((int)i).field_76292_a;
            }
            nbt.func_74783_a("craterBiomes", (int[])biomeId);
            nbt.func_74783_a("craterWeights", weights);
        }
        if (!this.laserDrillOres.isEmpty()) {
            list = new NBTTagList();
            biomeId = this.laserDrillOres.iterator();
            while (biomeId.hasNext()) {
                ItemStack ore = (ItemStack)biomeId.next();
                NBTTagCompound entry = new NBTTagCompound();
                ore.func_77955_b(entry);
                list.func_74742_a((NBTBase)entry);
            }
            nbt.func_74782_a("laserDrillOres", (NBTBase)list);
        }
        if (this.laserDrillOresRaw != null) {
            nbt.func_74782_a("laserDrillOresRaw", (NBTBase)new NBTTagString(this.laserDrillOresRaw));
        }
        if (!this.geodeOres.isEmpty()) {
            list = new NBTTagList();
            for (String ore : this.geodeOres) {
                list.func_74742_a((NBTBase)new NBTTagString(ore));
            }
            nbt.func_74782_a("geodeOres", (NBTBase)list);
        }
        if (!this.craterOres.isEmpty()) {
            list = new NBTTagList();
            for (String ore : this.craterOres) {
                list.func_74742_a((NBTBase)new NBTTagString(ore));
            }
            nbt.func_74782_a("craterOres", (NBTBase)list);
        }
        if (!this.requiredArtifacts.isEmpty()) {
            list = new NBTTagList();
            for (ItemStack ore : this.requiredArtifacts) {
                NBTTagCompound entry = new NBTTagCompound();
                ore.func_77955_b(entry);
                list.func_74742_a((NBTBase)entry);
            }
            nbt.func_74782_a("artifacts", (NBTBase)list);
        }
        nbt.func_74768_a("starId", this.starId);
        nbt.func_74776_a("gravitationalMultiplier", this.gravitationalMultiplier);
        nbt.func_74768_a("orbitalDist", this.orbitalDist);
        nbt.func_74780_a("orbitTheta", this.orbitTheta);
        nbt.func_74780_a("baseOrbitTheta", this.baseOrbitTheta);
        nbt.func_74780_a("orbitPhi", this.orbitalPhi);
        nbt.func_74780_a("rotationalPhi", this.rotationalPhi);
        nbt.func_74757_a("isRetrograde", this.isRetrograde);
        nbt.func_74757_a("hasOxygen", this.hasOxygen);
        nbt.func_74757_a("colorOverride", this.colorOverride);
        nbt.func_74768_a("atmosphereDensity", this.atmosphereDensity);
        nbt.func_74768_a("originalAtmosphereDensity", this.originalAtmosphereDensity);
        nbt.func_74780_a("peakInsolationMultiplier", this.peakInsolationMultiplier);
        nbt.func_74780_a("peakInsolationMultiplierWithoutAtmosphere", this.peakInsolationMultiplierWithoutAtmosphere);
        nbt.func_74768_a("avgTemperature", this.averageTemperature);
        nbt.func_74768_a("rotationalPeriod", this.rotationalPeriod);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("icon", this.customIcon);
        nbt.func_74757_a("isNative", this.isNativeDimension);
        nbt.func_74757_a("isGasGiant", this.isGasGiant);
        nbt.func_74757_a("hasRings", this.hasRings);
        nbt.func_74768_a("sealevel", this.seaLevel);
        nbt.func_74768_a("genType", this.generatorType);
        nbt.func_74757_a("canGenerateCraters", this.canGenerateCraters);
        nbt.func_74757_a("canGenerateGeodes", this.canGenerateGeodes);
        nbt.func_74757_a("canGenerateStructures", this.canGenerateStructures);
        nbt.func_74757_a("canGenerateVolcanos", this.canGenerateVolcanoes);
        nbt.func_74757_a("canGenerateCaves", this.canGenerateCaves);
        nbt.func_74757_a("hasRivers", this.hasRivers);
        nbt.func_74776_a("geodeFrequencyMultiplier", this.geodeFrequencyMultiplier);
        nbt.func_74776_a("craterFrequencyMultiplier", this.craterFrequencyMultiplier);
        nbt.func_74776_a("volcanoFrequencyMultiplier", this.volcanoFrequencyMultiplier);
        nbt.func_74768_a("rainStartLength", this.rainStartLength);
        nbt.func_74768_a("thunderStartLength", this.thunderStartLength);
        nbt.func_74768_a("rainProlongationLength", this.rainProlongationLength);
        nbt.func_74768_a("thunderProlongationLength", this.thunderProlongationLength);
        nbt.func_74768_a("rainMarker", this.rainMarker);
        nbt.func_74768_a("thunderMarker", this.thunderMarker);
        if (!this.childPlanets.isEmpty()) {
            Integer[] intList = new Integer[this.childPlanets.size()];
            NBTTagIntArray childArray = new NBTTagIntArray(ArrayUtils.toPrimitive((Integer[])this.childPlanets.toArray(intList)));
            nbt.func_74782_a("childrenPlanets", (NBTBase)childArray);
        }
        nbt.func_74768_a("parentPlanet", this.parentPlanet);
        if (this.isGasGiant) {
            NBTTagList fluidList = new NBTTagList();
            for (Fluid f : this.getHarvestableGasses()) {
                fluidList.func_74742_a((NBTBase)new NBTTagString(f.getName()));
            }
            nbt.func_74782_a("fluids", (NBTBase)fluidList);
        }
        if (this.oceanBlock != null) {
            nbt.func_74778_a("oceanBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.oceanBlock.func_177230_c())).toString());
            nbt.func_74768_a("oceanBlockMeta", this.oceanBlock.func_177230_c().func_176201_c(this.oceanBlock));
        }
        if (this.fillerBlock != null) {
            nbt.func_74778_a("fillBlock", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.fillerBlock.func_177230_c())).toString());
            nbt.func_74768_a("fillBlockMeta", this.fillerBlock.func_177230_c().func_176201_c(this.fillerBlock));
        }
        this.writeTechnicalNBT(nbt);
    }

    @Override
    public int getAverageTemp() {
        this.averageTemperature = AstronomicalBodyHelper.getAverageTemperature(this.getStar(), this.getSolarOrbitalDistance(), this.getAtmosphereDensity());
        return this.averageTemperature;
    }

    public IBlockState getOceanBlock() {
        return this.oceanBlock;
    }

    public void setOceanBlock(IBlockState block) {
        this.oceanBlock = block;
    }

    public IBlockState getStoneBlock() {
        return this.fillerBlock;
    }

    public void setStoneBlock(IBlockState block) {
        this.fillerBlock = block;
    }

    @Override
    public float getAtmosphereDensityAtHeight(double y) {
        return (float)this.atmosphereDensity * MathHelper.func_76131_a((float)((float)(1.0 + (256.0 - y) / 200.0)), (float)0.0f, (float)1.0f) / 100.0f;
    }

    public float[] getFogColorAtHeight(double y, Vec3d fogColor) {
        float atmDensity = this.getAtmosphereDensityAtHeight(y);
        return new float[]{(float)((double)atmDensity * fogColor.field_72450_a), (float)((double)atmDensity * fogColor.field_72448_b), (float)((double)atmDensity * fogColor.field_72449_c)};
    }

    public boolean isHabitable() {
        return this.getAtmosphere().isBreathable() && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.COLD, Temps.HOT);
    }

    public double[] getPlanetPosition() {
        double orbitalDistance = this.orbitalDist;
        double theta = this.orbitTheta;
        double phi = this.orbitalPhi;
        return new double[]{orbitalDistance * Math.cos(theta), orbitalDistance * Math.sin(phi), orbitalDistance * Math.sin(theta)};
    }

    @Override
    public int getStarId() {
        return this.starId;
    }

    public String toString() {
        return String.format("Dimension ID: %d.  Dimension Name: %s.  Parent Star %d ", this.getId(), this.getName(), this.getStarId());
    }

    @Override
    public double getOrbitTheta() {
        return this.orbitTheta;
    }

    @Override
    public int getOrbitalDist() {
        return this.orbitalDist;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(int sealevel) {
        this.seaLevel = MathHelper.func_76125_a((int)sealevel, (int)0, (int)255);
    }

    public int getGenType() {
        return this.generatorType;
    }

    public void setGenType(int genType) {
        this.generatorType = genType;
    }

    public void setGenerateCraters(boolean canGenerateCraters) {
        this.canGenerateCraters = canGenerateCraters;
    }

    public boolean canGenerateCraters() {
        return this.canGenerateCraters;
    }

    public float getCraterMultiplier() {
        return this.craterFrequencyMultiplier;
    }

    public void setCraterMultiplier(float craterFrequencyMultiplier) {
        this.craterFrequencyMultiplier = craterFrequencyMultiplier;
    }

    public void setGenerateGeodes(boolean canGenerateGeodes) {
        this.canGenerateGeodes = canGenerateGeodes;
    }

    public boolean canGenerateGeodes() {
        return this.canGenerateGeodes;
    }

    public float getGeodeMultiplier() {
        return this.volcanoFrequencyMultiplier;
    }

    public void setGeodeMultiplier(float geodeFrequencyMultiplier) {
        this.geodeFrequencyMultiplier = geodeFrequencyMultiplier;
    }

    public void setGenerateVolcanos(boolean canGenerateVolcanos) {
        this.canGenerateVolcanoes = canGenerateVolcanos;
    }

    public boolean canGenerateVolcanos() {
        return this.canGenerateVolcanoes;
    }

    public float getVolcanoMultiplier() {
        return this.volcanoFrequencyMultiplier;
    }

    public void setVolcanoMultiplier(float volcanoFrequencyMultiplier) {
        this.volcanoFrequencyMultiplier = volcanoFrequencyMultiplier;
    }

    public void setGenerateStructures(boolean canGenerateStructures) {
        this.canGenerateStructures = canGenerateStructures;
    }

    public boolean canGenerateStructures() {
        return this.canGenerateStructures;
    }

    public void setGenerateCaves(boolean canGenerateCaves) {
        this.canGenerateCaves = canGenerateCaves;
    }

    public boolean canGenerateCaves() {
        return this.canGenerateCaves;
    }

    @Override
    public float getRenderSizePlanetView() {
        return (this.isMoon() ? 8.0f : 10.0f) * Math.max(this.getGravitationalMultiplier() * this.getGravitationalMultiplier(), 0.5f) * 100.0f;
    }

    @Override
    public float getRenderSizeSolarView() {
        return (this.isMoon() ? 0.2f : 1.0f) * Math.max(this.getGravitationalMultiplier() * this.getGravitationalMultiplier(), 0.5f) * 100.0f;
    }

    @Override
    public SpacePosition getSpacePosition() {
        float distanceMultiplier = this.isMoon() ? 75.0f : 100.0f;
        SpacePosition spacePosition = new SpacePosition();
        spacePosition.star = this.getStar();
        spacePosition.world = this;
        spacePosition.isInInterplanetarySpace = this.isMoon();
        spacePosition.pitch = 0.0;
        spacePosition.roll = 0.0;
        spacePosition.yaw = 0.0;
        spacePosition = spacePosition.getFromSpherical(distanceMultiplier * (float)this.orbitalDist + (float)(this.isMoon() ? 100 : 0), this.orbitTheta);
        return spacePosition;
    }

    @Override
    public float[] getRingColor() {
        return this.ringColor;
    }

    @Override
    public float[] getSkyColor() {
        return this.skyColor;
    }

    public static enum PlanetIcons {
        EARTHLIKE(new ResourceLocation("advancedrocketry:textures/planets/Earthlike.png")),
        LAVA(new ResourceLocation("advancedrocketry:textures/planets/Lava.png")),
        MARSLIKE(new ResourceLocation("advancedrocketry:textures/planets/marslike.png")),
        MOON(new ResourceLocation("advancedrocketry:textures/planets/moon.png")),
        WATERWORLD(new ResourceLocation("advancedrocketry:textures/planets/WaterWorld.png")),
        ICEWORLD(new ResourceLocation("advancedrocketry:textures/planets/IceWorld.png")),
        DESERT(new ResourceLocation("advancedrocketry:textures/planets/desertworld.png")),
        CARBON(new ResourceLocation("advancedrocketry:textures/planets/carbonworld.png")),
        VENUSIAN(new ResourceLocation("advancedrocketry:textures/planets/venusian.png")),
        GASGIANTBLUE(new ResourceLocation("advancedrocketry:textures/planets/GasGiantBlue.png")),
        GASGIANTRED(new ResourceLocation("advancedrocketry:textures/planets/GasGiantred.png")),
        GASGIANTBROWN(new ResourceLocation("advancedrocketry:textures/planets/gasgiantbrown.png")),
        ASTEROID(new ResourceLocation("advancedrocketry:textures/planets/asteroid.png")),
        UNKNOWN(new ResourceLocation("advancedrocketry:textures/planets/Unknown.png"));

        private ResourceLocation resource;
        private ResourceLocation resourceLEO;

        private PlanetIcons(ResourceLocation resource) {
            this.resource = resource;
            this.resourceLEO = new ResourceLocation(resource.toString().substring(0, resource.toString().length() - 4) + "LEO.jpg");
        }

        private PlanetIcons(ResourceLocation resource, ResourceLocation leo) {
            this.resource = resource;
            this.resourceLEO = leo;
        }

        public ResourceLocation getResource() {
            return this.resource;
        }

        public ResourceLocation getResourceLEO() {
            return this.resourceLEO;
        }
    }

    public static enum AtmosphereTypes {
        SUPERHIGHPRESSURE(800),
        HIGHPRESSURE(200),
        NORMAL(75),
        LOW(25),
        NONE(0);

        private final int value;

        private AtmosphereTypes(int value) {
            this.value = value;
        }

        public static AtmosphereTypes getAtmosphereTypeFromValue(int value) {
            for (AtmosphereTypes type : AtmosphereTypes.values()) {
                if (value <= type.value) continue;
                return type;
            }
            return NONE;
        }

        public int getAtmosphereValue() {
            return this.value;
        }

        public boolean denserThan(AtmosphereTypes type) {
            return this.compareTo(type) < 0;
        }

        public boolean lessDenseThan(AtmosphereTypes type) {
            return this.compareTo(type) > 0;
        }
    }

    public static enum Temps {
        TOOHOT(450),
        HOT(325),
        NORMAL(275),
        COLD(250),
        FRIGID(175),
        SNOWBALL(0);

        private final int temp;

        private Temps(int i) {
            this.temp = i;
        }

        public static Temps getTempFromValue(int value) {
            for (Temps type : Temps.values()) {
                if (value < type.temp) continue;
                return type;
            }
            return SNOWBALL;
        }

        @Deprecated
        public int getTemp() {
            return this.temp;
        }

        public boolean hotterThan(Temps type) {
            return this.compareTo(type) < 0;
        }

        public boolean hotterOrEquals(Temps type) {
            return this.compareTo(type) <= 0;
        }

        public boolean colderThan(Temps type) {
            return this.compareTo(type) > 0;
        }

        public boolean isInRange(Temps lowerBound, Temps upperBound) {
            return this.compareTo(lowerBound) <= 0 && this.compareTo(upperBound) >= 0;
        }
    }
}

