/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.backwardCompat.ModelFormatException;
import zmaster587.advancedRocketry.backwardCompat.WavefrontObject;
import zmaster587.advancedRocketry.client.render.multiblocks.RendererWarpCore;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityUIPlanet;
import zmaster587.libVulpes.render.RenderHelper;

public class RenderPlanetUIEntity
extends Render<EntityUIPlanet>
implements IRenderFactory<EntityUIPlanet> {
    public static ResourceLocation planetUIBG = new ResourceLocation("advancedrocketry:textures/gui/planetUIOverlay.png");
    public static ResourceLocation planetUIFG = new ResourceLocation("advancedrocketry:textures/gui/planetUIOverlayFG.png");
    private static WavefrontObject sphere;

    public RenderPlanetUIEntity(RenderManager renderManager) {
        super(renderManager);
    }

    public Render<? super EntityUIPlanet> createRenderFor(RenderManager manager) {
        return new RenderPlanetUIEntity(manager);
    }

    protected ResourceLocation getEntityTexture(EntityUIPlanet entity) {
        return DimensionProperties.PlanetIcons.EARTHLIKE.getResource();
    }

    public void doRender(EntityUIPlanet entity, double x, double y, double z, float entityYaw, float partialTicks) {
        DimensionProperties properties = entity.getProperties();
        if (properties == null) {
            return;
        }
        float sizeScale = Math.max(properties.gravitationalMultiplier * properties.gravitationalMultiplier * entity.getScale(), 0.5f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + sizeScale * 0.03f), (float)((float)z));
        GL11.glScalef((float)(0.1f * sizeScale), (float)(0.1f * sizeScale), (float)(0.1f * sizeScale));
        GlStateManager.func_179140_f();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(properties.getPlanetIconLEO());
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)1, (int)770);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(entity.field_70170_p.func_82737_E() & 0xFFL), (float)0.0f, (float)1.0f, (float)0.0f);
        sphere.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotated((double)(-(properties.orbitTheta * 180.0 / Math.PI)), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.func_179112_b((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.shadow3);
        GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)0.75f);
        sphere.renderAll();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        if (properties.hasRings) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179131_c((float)properties.ringColor[0], (float)properties.ringColor[1], (float)properties.ringColor[2], (float)0.5f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.planetRings);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderBottomFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(DimensionProperties.planetRingShadow);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderTopFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            RenderHelper.renderBottomFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-1.0, (double)-1.0, (double)1.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.func_178181_a().func_78381_a();
        }
        GL11.glPopMatrix();
        if (properties.hasAtmosphere()) {
            GL11.glPushMatrix();
            GlStateManager.func_179090_x();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)properties.skyColor[0], (float)properties.skyColor[1], (float)properties.skyColor[2], (float)0.1f);
            for (int i = 0; i < 5; ++i) {
                GL11.glScalef((float)1.02f, (float)1.02f, (float)1.02f);
                sphere.renderAll();
            }
            GlStateManager.func_179098_w();
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GlStateManager.func_179112_b((int)770, (int)771);
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179090_x();
        for (int i = 0; i < 4; ++i) {
            float myTime = (float)((long)(i * 4) + entity.field_70170_p.func_82737_E() & 0xFL) / 16.0f;
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)1.0f, (float)(0.2f * (1.0f - myTime)));
            buf.func_181668_a(7, DefaultVertexFormats.field_181708_h);
            RenderHelper.renderTopFace((BufferBuilder)buf, (double)((double)myTime - 0.5), (double)-0.5, (double)-0.5, (double)0.5, (double)0.5);
            RenderHelper.renderBottomFace((BufferBuilder)buf, (double)((double)myTime - 0.5), (double)-0.5, (double)-0.5, (double)0.5, (double)0.5);
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        if (entity.isSelected()) {
            GlStateManager.func_179090_x();
            double speedRotate = 0.025;
            GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)1.0f, (float)0.6f);
            GL11.glTranslated((double)0.0, (double)-1.25, (double)0.0);
            GL11.glPushMatrix();
            GL11.glRotated((double)(speedRotate * (double)System.currentTimeMillis() % 360.0), (double)0.0, (double)1.0, (double)0.0);
            RendererWarpCore.model.renderOnly("Rotate1");
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotated((double)(180.0 + speedRotate * (double)System.currentTimeMillis() % 360.0), (double)0.0, (double)1.0, (double)0.0);
            RendererWarpCore.model.renderOnly("Rotate1");
            GL11.glPopMatrix();
            GlStateManager.func_179098_w();
        }
        GL11.glPopMatrix();
        RayTraceResult hitObj = Minecraft.func_71410_x().field_71476_x;
        if (hitObj != null && hitObj.field_72308_g == entity) {
            GL11.glPushMatrix();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslated((double)x, (double)(y + (double)(sizeScale * 0.03f)), (double)z);
            sizeScale = 0.1f * sizeScale;
            GL11.glScaled((double)sizeScale, (double)sizeScale, (double)sizeScale);
            RenderHelper.setupPlayerFacingMatrix((double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.field_72307_f.field_72449_c, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72450_a), (double)0.0, (double)0.0, (double)0.0);
            buffer = Tessellator.func_178181_a().func_178180_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(planetUIFG);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            this.renderMassIndicator(buffer, Math.min(properties.gravitationalMultiplier / 2.0f, 1.0f));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(planetUIBG);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)1.0, (double)-40.0, (double)-25.0, (double)40.0, (double)55.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0);
            Tessellator.func_178181_a().func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(planetUIFG);
            this.renderATMIndicator(buffer, Math.min((float)properties.getAtmosphereDensity() / 200.0f, 1.0f));
            this.renderTemperatureIndicator(buffer, Math.min((float)properties.getAverageTemp() / 400.0f, 1.0f));
            RenderHelper.cleanupPlayerFacingMatrix();
            RenderHelper.renderTag((double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.field_72307_f.field_72449_c, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72450_a), (String)properties.getName(), (double)0.0, (double)0.9, (double)0.0, (int)5);
            RenderHelper.renderTag((double)Minecraft.func_71410_x().field_71439_g.func_70092_e(hitObj.field_72307_f.field_72449_c, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72450_a), (String)("NumMoons: " + properties.getChildPlanets().size()), (double)0.0, (double)0.6, (double)0.0, (int)5);
            GL11.glPopMatrix();
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    protected void renderMassIndicator(BufferBuilder buffer, float percent) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float maxUV = (1.0f - percent) * 0.5f;
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-20.0, (double)(-5.0f + 41.0f * (1.0f - percent)), (double)20.0, (double)36.0, (double)0.5, (double)0.0, (double)0.5, (double)maxUV);
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void renderATMIndicator(BufferBuilder buffer, float percent) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)6.0, (double)(20.0f + (1.0f - percent) * 33.0f), (double)39.0, (double)53.0, (double)0.5624f, (double)0.984f, (double)0.984f, (double)maxUV);
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void renderTemperatureIndicator(BufferBuilder buffer, float percent) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float maxUV = (1.0f - percent) * 0.406f + 0.578f;
        RenderHelper.renderNorthFaceWithUV((BufferBuilder)buffer, (double)0.0, (double)-38.0, (double)(21.4f + (1.0f - percent) * 33.0f), (double)-4.0, (double)53.0, (double)0.016f, (double)0.4376f, (double)0.984f, (double)maxUV);
        Tessellator.func_178181_a().func_78381_a();
    }

    static {
        try {
            sphere = new WavefrontObject(new ResourceLocation("advancedrocketry:models/atmosphere.obj"));
        }
        catch (ModelFormatException e) {
            throw new RuntimeException(e);
        }
    }
}

