/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.block.BlockFuelTank;
import zmaster587.advancedRocketry.tile.TileBrokenPart;
import zmaster587.advancedRocketry.util.IBrokenPartBlock;
import zmaster587.libVulpes.block.BlockFullyRotatable;

public class BlockRocketMotor
extends BlockFullyRotatable
implements IRocketEngine,
IBrokenPartBlock {
    public BlockRocketMotor(Material mat) {
        super(mat);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
    }

    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c() instanceof BlockFuelTank) {
            return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
        }
        if (world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() instanceof BlockFuelTank) {
            return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        }
        if (world.func_180495_p(pos.func_177982_a(1, 0, 0)).func_177230_c() instanceof BlockFuelTank) {
            return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
        }
        if (world.func_180495_p(pos.func_177982_a(-1, 0, 0)).func_177230_c() instanceof BlockFuelTank) {
            return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
        }
        if (world.func_180495_p(pos.func_177982_a(0, 0, 1)).func_177230_c() instanceof BlockFuelTank) {
            return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
        }
        if (world.func_180495_p(pos.func_177982_a(0, 0, -1)).func_177230_c() instanceof BlockFuelTank) {
            return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        }
        return super.func_176221_a(state, world, pos);
    }

    @Override
    public int getThrust(World world, BlockPos pos) {
        return 10;
    }

    @Override
    public int getFuelConsumptionRate(World world, int x, int y, int z) {
        return 1;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149637_q(@Nonnull IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN));
        TileEntity te = world.func_175625_s(pos);
        ((TileBrokenPart)te).setStage(stack.func_77952_i());
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!world.field_72995_K && !player.func_184812_l_()) {
            TileBrokenPart tile = (TileBrokenPart)te;
            ItemStack drop = this.getDropItem(state, world, tile);
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 5) {
            return this.func_176223_P();
        }
        return super.func_176203_a(meta);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileBrokenPart(10, 2.0f * (float)ARConfiguration.getCurrentConfig().increaseWearIntensityProb);
    }

    @Override
    public ItemStack getDropItem(IBlockState state, World world, @Nullable TileBrokenPart te) {
        ItemStack drop = new ItemStack(this.func_180660_a(state, world.field_73012_v, 0));
        if (te != null) {
            drop.func_77964_b(te.getStage());
        }
        return drop;
    }
}

