/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.libVulpes.util.AdjacencyGraph;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class AreaBlob {
    protected final AdjacencyGraph<HashedBlockPosition> graph;
    protected IBlobHandler blobHandler;
    private Object data;

    public AreaBlob(@Nonnull IBlobHandler blobHandler) {
        this.blobHandler = blobHandler;
        this.graph = new AdjacencyGraph();
        this.data = null;
    }

    public boolean isPositionAllowed(World world, HashedBlockPosition pos, List<AreaBlob> otherBlobs) {
        return true;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object obj) {
        this.data = obj;
    }

    public int getBlobMaxRadius() {
        return this.blobHandler.getMaxBlobRadius();
    }

    public void addBlock(int x, int y, int z, @Nonnull List<AreaBlob> otherBlobs) {
        HashedBlockPosition blockPos = new HashedBlockPosition(x, y, z);
        this.addBlock(blockPos, otherBlobs);
    }

    public void addBlock(@Nonnull HashedBlockPosition blockPos, List<AreaBlob> otherBlobs) {
        if (!this.graph.contains((Object)blockPos) && this.blobHandler.canFormBlob()) {
            this.graph.add((Object)blockPos, this.getPositionsToAdd(blockPos));
        }
    }

    @Nonnull
    public HashedBlockPosition getRootPosition() {
        return this.blobHandler.getRootPosition();
    }

    @Nonnull
    protected HashSet<HashedBlockPosition> getPositionsToAdd(@Nonnull HashedBlockPosition blockPos) {
        HashSet<HashedBlockPosition> set = new HashSet<HashedBlockPosition>();
        for (EnumFacing direction : EnumFacing.values()) {
            HashedBlockPosition offset = blockPos.getPositionAtOffset(direction);
            if (!this.graph.contains((Object)offset)) continue;
            set.add(offset);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(@Nonnull HashedBlockPosition position) {
        boolean contains;
        AdjacencyGraph<HashedBlockPosition> adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            contains = this.graph.contains((Object)position);
        }
        return contains;
    }

    public boolean contains(int x, int y, int z) {
        return this.contains(new HashedBlockPosition(x, y, z));
    }

    public boolean canBlobsOverlap(int x, int y, int z, AreaBlob otherBlob) {
        return this.blobHandler.canBlobsOverlap(new HashedBlockPosition(x, y, z), otherBlob);
    }

    public void removeBlock(@Nonnull HashedBlockPosition blockPos) {
        this.graph.remove((Object)blockPos);
        for (EnumFacing direction : EnumFacing.values()) {
            HashedBlockPosition newBlock = blockPos.getPositionAtOffset(direction);
            if (!this.graph.contains((Object)newBlock) || this.graph.doesPathExist((Object)newBlock, (Object)this.blobHandler.getRootPosition())) continue;
            this.graph.removeAllNodesConnectedTo((Object)newBlock);
        }
    }

    public void clearBlob() {
        this.graph.clear();
    }

    public Set<HashedBlockPosition> getLocations() {
        return this.graph.getKeys();
    }

    public int getBlobSize() {
        return this.graph.size();
    }
}

