/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry;

import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandWeather;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerDemo;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.repack.gloomyfolken.hooklib.asm.Hook;
import zmaster587.advancedRocketry.repack.gloomyfolken.hooklib.asm.ReturnCondition;
import zmaster587.advancedRocketry.world.WorldServerNotMulti;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;

public class ARHooks {
    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void initDimension(DimensionManager mgr, int dim) {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType((int)dim);
        }
        catch (Exception e) {
            FMLLog.log.error("Cannot Hotload Dim: {}", (Object)dim, (Object)e);
            return;
        }
        MinecraftServer mcServer = overworld.func_73046_m();
        ISaveHandler savehandler = overworld.func_72860_G();
        WorldServer world = dim == 0 ? overworld : (WorldServer)new WorldServerNotMulti(mcServer, savehandler, dim, overworld, mcServer.field_71304_b).func_175643_b();
        world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(mcServer, world));
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        if (!mcServer.func_71264_H()) {
            world.func_72912_H().func_76060_a(mcServer.func_71265_f());
        }
        mcServer.func_147139_a(mcServer.func_147135_j());
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void loadAllWorlds(MinecraftServer server, String saveName, String worldNameIn, long seed, WorldType type, String generatorOptions) {
        WorldSettings worldsettings;
        server.func_71237_c(saveName);
        server.func_71192_d("menu.loadingLevel");
        ISaveHandler isavehandler = server.field_71310_m.func_75804_a(saveName, true);
        server.func_175584_a(server.func_71270_I(), isavehandler);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null) {
            if (server.func_71242_L()) {
                worldsettings = WorldServerDemo.field_73071_a;
            } else {
                worldsettings = new WorldSettings(seed, server.func_71265_f(), server.func_71225_e(), server.func_71199_h(), type);
                worldsettings.func_82750_a(generatorOptions);
                if (server.field_71289_N) {
                    worldsettings.func_77159_a();
                }
            }
            worldinfo = new WorldInfo(worldsettings, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
            worldsettings = new WorldSettings(worldinfo);
        }
        WorldServer overWorld = (WorldServer)(server.func_71242_L() ? new WorldServerDemo(server, isavehandler, worldinfo, 0, server.field_71304_b).func_175643_b() : new WorldServer(server, isavehandler, worldinfo, 0, server.field_71304_b).func_175643_b());
        overWorld.func_72963_a(worldsettings);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = dim == 0 ? overWorld : (WorldServer)new WorldServerNotMulti(server, isavehandler, dim, overWorld, server.field_71304_b).func_175643_b();
            world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(server, world));
            if (!server.func_71264_H()) {
                world.func_72912_H().func_76060_a(server.func_71265_f());
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        }
        server.field_71318_t.func_72364_a(new WorldServer[]{overWorld});
        server.func_147139_a(server.func_147135_j());
        server.func_71222_d();
    }

    @SideOnly(value=Side.CLIENT)
    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void loadAllWorlds(IntegratedServer server, String saveName, String worldNameIn, long seed, WorldType type, String generatorOptions) {
        server.func_71237_c(saveName);
        ISaveHandler isavehandler = server.func_71254_M().func_75804_a(saveName, true);
        server.func_175584_a(server.func_71270_I(), isavehandler);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null) {
            worldinfo = new WorldInfo(server.field_71350_m, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
        }
        WorldServer overWorld = server.func_71242_L() ? (WorldServer)new WorldServerDemo((MinecraftServer)server, isavehandler, worldinfo, 0, server.field_71304_b).func_175643_b() : (WorldServer)new WorldServer((MinecraftServer)server, isavehandler, worldinfo, 0, server.field_71304_b).func_175643_b();
        overWorld.func_72963_a(server.field_71350_m);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            WorldServer world = dim == 0 ? overWorld : (WorldServer)new WorldServerNotMulti((MinecraftServer)server, isavehandler, dim, overWorld, server.field_71304_b).func_175643_b();
            world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler((MinecraftServer)server, world));
            if (!server.func_71264_H()) {
                world.func_72912_H().func_76060_a(server.func_71265_f());
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        }
        server.func_184103_al().func_72364_a(new WorldServer[]{overWorld});
        if (overWorld.func_72912_H().func_176130_y() == null) {
            server.func_147139_a(server.field_71349_l.field_71474_y.field_74318_M);
        }
        server.func_71222_d();
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void execute(CommandWeather command, MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1 && args.length <= 2) {
            int i = (300 + new Random().nextInt(600)) * 20;
            if (args.length >= 2) {
                i = CommandBase.func_175764_a((String)args[1], (int)1, (int)1000000) * 20;
            }
            World world = sender.func_130014_f_();
            WorldInfo worldinfo = world.func_72912_H();
            WorldProvider provider = world.field_73011_w;
            DimensionProperties props = null;
            if (provider instanceof WorldProviderPlanet) {
                props = ((WorldProviderPlanet)provider).getDimensionProperties();
            }
            if ("clear".equalsIgnoreCase(args[0])) {
                if (props != null && (props.getRainMarker() == 1 || props.getThunderMarker() == 1)) {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.weather.always_not_clear", (Object[])new Object[0]);
                    return;
                }
                worldinfo.func_176142_i(i);
                worldinfo.func_76080_g(0);
                worldinfo.func_76090_f(0);
                worldinfo.func_76084_b(false);
                worldinfo.func_76069_a(false);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.weather.clear", (Object[])new Object[0]);
            } else if ("rain".equalsIgnoreCase(args[0])) {
                if (props != null && props.getRainMarker() == -1) {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.weather.cannot_rain", (Object[])new Object[0]);
                    return;
                }
                worldinfo.func_176142_i(0);
                worldinfo.func_76080_g(i);
                worldinfo.func_76090_f(i);
                worldinfo.func_76084_b(true);
                worldinfo.func_76069_a(false);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.weather.rain", (Object[])new Object[0]);
            } else {
                if (!"thunder".equalsIgnoreCase(args[0])) {
                    throw new WrongUsageException("commands.weather.usage", new Object[0]);
                }
                if (props != null && props.getThunderMarker() == -1) {
                    CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.weather.cannot_thunder", (Object[])new Object[0]);
                    return;
                }
                worldinfo.func_176142_i(0);
                worldinfo.func_76080_g(i);
                worldinfo.func_76090_f(i);
                worldinfo.func_76084_b(true);
                worldinfo.func_76069_a(true);
                CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)"commands.weather.thunder", (Object[])new Object[0]);
            }
        } else {
            throw new WrongUsageException("commands.weather.usage", new Object[0]);
        }
    }
}

