/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.google.common.collect.Lists;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class RedwoodTreeGenerator
extends BaseTreeGenerator {
    private Random rand;
    private World world;
    private BlockPos basePos = BlockPos.field_177992_a;
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double branchSlope = 0.381;
    double scaleWidth = 1.0;
    double leafDensity = 1.0;
    int trunkSize = 1;
    int heightLimitLimit = 12;
    int leafDistanceLimit = 4;
    List<FoliageCoordinates> foliageCoords;
    public final IBlockState bark;
    public final IBlockState heart;
    public final IBlockState root;
    public final IBlockState leaves;
    public final boolean useHeight;
    public final boolean isSapling;

    public RedwoodTreeGenerator(IBlockState bark, IBlockState heart, IBlockState root, IBlockState leaves, boolean useHeight, boolean isSapling) {
        this.bark = bark;
        this.heart = heart;
        this.root = root;
        this.leaves = leaves;
        this.useHeight = useHeight;
        this.isSapling = isSapling;
    }

    public RedwoodTreeGenerator(IBlockState log, IBlockState heart, IBlockState root, IBlockState leaves) {
        this(log, heart, root, leaves, true, true);
    }

    void generateLeafNodeList() {
        int k;
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int j = this.basePos.func_177956_o() + this.height;
        this.foliageCoords = Lists.newArrayList();
        this.foliageCoords.add(new FoliageCoordinates(this.basePos.func_177981_b(k), j));
        for (k = this.heightLimit - this.leafDistanceLimit; k >= 0; --k) {
            float f = this.layerSize(k);
            if (!(f >= 0.0f)) continue;
            for (int l = 0; l < i; ++l) {
                BlockPos blockpos1;
                double d3;
                double d1;
                double d0 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                double d2 = d0 * Math.sin(d1 = (double)(this.rand.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = this.basePos.func_177963_a(d2, -1.0, d3 = d0 * Math.cos(d1) + 0.5);
                if (this.checkBlockLine(blockpos, blockpos1 = blockpos.func_177981_b(this.leafDistanceLimit)) != -1) continue;
                int i1 = this.basePos.func_177958_n() - blockpos.func_177958_n();
                int j1 = this.basePos.func_177952_p() - blockpos.func_177952_p();
                double d4 = (double)blockpos.func_177956_o() - Math.sqrt(i1 * i1 + j1 * j1) * this.branchSlope;
                int k1 = d4 > (double)j ? j : (int)d4;
                BlockPos blockpos2 = new BlockPos(this.basePos.func_177958_n(), k1, this.basePos.func_177952_p());
                if (this.checkBlockLine(blockpos2, blockpos) != -1) continue;
                this.foliageCoords.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
    }

    void crosSection(BlockPos pos, float size, IBlockState state) {
        int i = (int)((double)size + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                IBlockState stateAtPos;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(size * size)) || !(stateAtPos = this.world.func_180495_p(blockpos = pos.func_177982_a(j, 0, k))).func_177230_c().isAir(stateAtPos, (IBlockAccess)this.world, blockpos) && !stateAtPos.func_177230_c().isLeaves(stateAtPos, (IBlockAccess)this.world, blockpos)) continue;
                this.setBlockAndMetadata(this.world, blockpos, state);
            }
        }
    }

    float layerSize(int y) {
        if ((float)y < (float)this.heightLimit * 0.3f) {
            return -1.0f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = f - (float)y;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    float leafSize(int y) {
        return y >= 0 && y < this.leafDistanceLimit ? (y != 0 && y != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void generateLeafNode(BlockPos pos) {
        for (int i = 0; i < this.leafDistanceLimit; ++i) {
            this.crosSection(pos.func_177981_b(i), this.leafSize(i), this.leaves);
        }
    }

    void limb(BlockPos pos1, BlockPos pos2, IBlockState state) {
        BlockPos blockpos = pos2.func_177982_a(-pos1.func_177958_n(), -pos1.func_177956_o(), -pos1.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = pos1.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            this.setBlockAndMetadata(this.world, blockpos1, state);
        }
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        return k > i && k > j ? k : (j > i ? j : i);
    }

    void generateLeaves() {
        for (FoliageCoordinates foliagecoordinates : this.foliageCoords) {
            this.generateLeafNode(foliagecoordinates);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void generateLeafNodeBases() {
        for (FoliageCoordinates foliagecoordinates : this.foliageCoords) {
            int i = foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(this.basePos.func_177958_n(), i, this.basePos.func_177952_p());
            if (blockpos.equals((Object)foliagecoordinates) || !this.leafNodeNeedsBase(i - this.basePos.func_177956_o())) continue;
            this.limb(blockpos, foliagecoordinates, this.bark);
        }
    }

    int checkBlockLine(BlockPos posOne, BlockPos posTwo) {
        BlockPos blockpos = posTwo.func_177982_a(-posOne.func_177958_n(), -posOne.func_177956_o(), -posOne.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        if (i == 0) {
            return -1;
        }
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = posOne.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (this.isReplaceable(this.world, blockpos1)) continue;
            return j;
        }
        return -1;
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        if (this.isReplaceable(world, pos)) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.canGrowInto(state.func_177230_c());
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd;
    }

    BlockPos findGround(World world, BlockPos pos) {
        if (world.func_175624_G() == WorldType.field_77138_c && this.isSapling) {
            boolean foundGround = false;
            int height = Config.flatSeaLevel + 64;
            do {
                BlockPos position;
                Block underBlock;
                if ((underBlock = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), --height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && underBlock != Blocks.field_150349_c && height >= Config.flatSeaLevel) continue;
                foundGround = true;
            } while (!foundGround);
            return new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
        }
        boolean foundGround = false;
        int height = Config.seaLevel + 64;
        do {
            BlockPos position;
            Block underBlock;
            if ((underBlock = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), --height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && underBlock != Blocks.field_150349_c && height >= Config.seaLevel) continue;
            foundGround = true;
        } while (!foundGround);
        return new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
    }

    public boolean isValidSpawn(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        boolean ground = block == Blocks.field_150346_d || block == Blocks.field_150349_c;
        boolean transparent = !world.func_180495_p(pos.func_177984_a()).func_185913_b();
        return ground && transparent;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World world, BlockPos pos) {
        BlockPos groundPosition = pos;
        if (!this.useHeight && !this.isValidSpawn(world, groundPosition = this.findGround(world, pos))) {
            return;
        }
        int treeHeight = random.nextInt(60) + 80;
        this.world = world;
        this.basePos = groundPosition;
        this.rand = new Random(random.nextLong());
        this.heightLimit = 5 + this.rand.nextInt(this.heightLimitLimit);
        if (treeHeight > 120) {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight * 1 / 10) {
                    this.genRing13(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 10) {
                    this.genRing12(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 10) {
                    this.genRing11(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 10) {
                    this.genRing10(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 10) {
                    this.genRing9(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growLowBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 6 / 10) {
                    this.genRing8(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growLowBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 7 / 10) {
                    this.genRing7(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growMiddleBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 8 / 10) {
                    this.genRing6(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growMiddleBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 9 / 10) {
                    this.genRing5(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growHighBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                this.genRing3(world, random, groundPosition.func_177981_b(currentHeight));
                this.growHighBranch(world, random, groundPosition.func_177981_b(currentHeight));
            }
            this.growBigRoots(world, random, groundPosition.func_177977_b());
            this.growTop(world, random, groundPosition.func_177981_b(this.height));
        } else if (treeHeight > 100) {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight * 1 / 8) {
                    this.genRing11(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 8) {
                    this.genRing10(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 8) {
                    this.genRing9(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 8) {
                    this.genRing8(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 8) {
                    this.genRing7(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growMiddleBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 6 / 8) {
                    this.genRing6(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growMiddleBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 7 / 8) {
                    this.genRing5(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growHighBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                this.genRing3(world, random, groundPosition.func_177981_b(currentHeight));
                this.growHighBranch(world, random, groundPosition.func_177981_b(currentHeight));
            }
            this.growMediumRoots(world, random, groundPosition.func_177977_b());
            this.growTop(world, random, groundPosition.func_177981_b(this.height));
        } else {
            for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
                if (currentHeight < treeHeight * 1 / 6) {
                    this.genRing9(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 2 / 6) {
                    this.genRing8(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 3 / 6) {
                    this.genRing7(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 4 / 6) {
                    this.genRing6(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growMiddleBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                if (currentHeight < treeHeight * 5 / 6) {
                    this.genRing5(world, random, groundPosition.func_177981_b(currentHeight));
                    this.growHighBranch(world, random, groundPosition.func_177981_b(currentHeight));
                    continue;
                }
                this.genRing3(world, random, groundPosition.func_177981_b(currentHeight));
                this.growHighBranch(world, random, groundPosition.func_177981_b(currentHeight));
            }
            this.growSmallRoots(world, random, groundPosition.func_177977_b());
            this.growTop(world, random, groundPosition.func_177981_b(this.height));
        }
    }

    public boolean growTop(World world, Random random, BlockPos pos) {
        this.basePos = pos.func_177981_b(4);
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.basePos = pos.func_177981_b(4);
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.basePos = pos;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        this.basePos = pos;
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        return false;
    }

    public boolean growHighBranch(World world, Random random, BlockPos pos) {
        int xPos = pos.func_177958_n();
        int yPos = pos.func_177956_o();
        int zPos = pos.func_177952_p();
        for (int iter = 0; iter < 3; ++iter) {
            this.basePos = new BlockPos(xPos + random.nextInt(21) - 10, yPos, zPos + random.nextInt(21) - 10);
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
        }
        return false;
    }

    public boolean growMiddleBranch(World world, Random random, BlockPos pos) {
        int xPos = pos.func_177958_n();
        int yPos = pos.func_177956_o();
        int zPos = pos.func_177952_p();
        for (int iter = 0; iter < 6; ++iter) {
            this.basePos = new BlockPos(xPos + random.nextInt(31) - 15, yPos, zPos + random.nextInt(31) - 15);
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
        }
        return false;
    }

    public boolean growLowBranch(World world, Random random, BlockPos pos) {
        int xPos = pos.func_177958_n();
        int yPos = pos.func_177956_o();
        int zPos = pos.func_177952_p();
        this.basePos = new BlockPos(xPos + random.nextInt(17) - 8, yPos, zPos + random.nextInt(17) - 8);
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        if (random.nextInt(2) == 0) {
            this.basePos = new BlockPos(xPos + random.nextInt(17) - 8, yPos, zPos + random.nextInt(17) - 8);
            this.generateLeafNodeList();
            this.generateLeaves();
            this.generateLeafNodeBases();
        }
        this.basePos = new BlockPos(xPos + random.nextInt(17) - 8, yPos, zPos + random.nextInt(17) - 8);
        this.generateLeafNodeList();
        this.generateLeaves();
        this.generateLeafNodeBases();
        return false;
    }

    public boolean growSmallRoots(World world, Random random, BlockPos pos) {
        this.genRing9(world, random, pos);
        this.smallRoot1(world, random, pos.func_177979_c(1));
        this.smallRoot1(world, random, pos.func_177979_c(2));
        this.smallRoot1(world, random, pos.func_177979_c(3));
        this.smallRoot2(world, random, pos.func_177979_c(4));
        this.smallRoot2(world, random, pos.func_177979_c(5));
        this.smallRoot3(world, random, pos.func_177979_c(6));
        this.smallRoot3(world, random, pos.func_177979_c(7));
        this.smallRoot3(world, random, pos.func_177979_c(8));
        this.smallRoot3(world, random, pos.func_177979_c(9));
        this.smallRoot4(world, random, pos.func_177979_c(10));
        this.smallRoot4(world, random, pos.func_177979_c(11));
        return true;
    }

    public boolean growMediumRoots(World world, Random random, BlockPos pos) {
        this.genRing11(world, random, pos);
        this.mediumRoot1(world, random, pos.func_177979_c(1));
        this.mediumRoot1(world, random, pos.func_177979_c(2));
        this.mediumRoot1(world, random, pos.func_177979_c(3));
        this.mediumRoot2(world, random, pos.func_177979_c(4));
        this.mediumRoot2(world, random, pos.func_177979_c(5));
        this.mediumRoot3(world, random, pos.func_177979_c(6));
        this.mediumRoot3(world, random, pos.func_177979_c(7));
        this.mediumRoot3(world, random, pos.func_177979_c(8));
        this.mediumRoot3(world, random, pos.func_177979_c(9));
        this.mediumRoot4(world, random, pos.func_177979_c(10));
        this.mediumRoot4(world, random, pos.func_177979_c(11));
        this.mediumRoot5(world, random, pos.func_177979_c(12));
        this.mediumRoot5(world, random, pos.func_177979_c(13));
        this.mediumRoot5(world, random, pos.func_177979_c(14));
        return true;
    }

    public boolean growBigRoots(World world, Random random, BlockPos pos) {
        this.genRing13(world, random, pos);
        this.bigRoot1(world, random, pos.func_177979_c(1));
        this.bigRoot1(world, random, pos.func_177979_c(2));
        this.bigRoot1(world, random, pos.func_177979_c(3));
        this.bigRoot2(world, random, pos.func_177979_c(4));
        this.bigRoot2(world, random, pos.func_177979_c(5));
        this.bigRoot3(world, random, pos.func_177979_c(6));
        this.bigRoot3(world, random, pos.func_177979_c(7));
        this.bigRoot3(world, random, pos.func_177979_c(8));
        this.bigRoot3(world, random, pos.func_177979_c(9));
        this.bigRoot4(world, random, pos.func_177979_c(10));
        this.bigRoot4(world, random, pos.func_177979_c(11));
        this.bigRoot5(world, random, pos.func_177979_c(12));
        this.bigRoot5(world, random, pos.func_177979_c(13));
        this.bigRoot5(world, random, pos.func_177979_c(14));
        this.bigRoot6(world, random, pos.func_177979_c(15));
        this.bigRoot6(world, random, pos.func_177979_c(16));
        this.bigRoot6(world, random, pos.func_177979_c(17));
        this.bigRoot6(world, random, pos.func_177979_c(18));
        return true;
    }

    public boolean smallRoot1(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.root);
        }
        return true;
    }

    public boolean smallRoot2(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.root);
        }
        return true;
    }

    public boolean smallRoot3(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
        }
        return true;
    }

    public boolean smallRoot4(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
        }
        return true;
    }

    public boolean mediumRoot1(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 1), this.root);
        }
        return true;
    }

    public boolean mediumRoot2(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.root);
        }
        return true;
    }

    public boolean mediumRoot3(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
        }
        return true;
    }

    public boolean mediumRoot4(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
        }
        return true;
    }

    public boolean mediumRoot5(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
        }
        return true;
    }

    public boolean bigRoot1(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 2), this.root);
        }
        return true;
    }

    public boolean bigRoot2(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 6), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 1), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 4), this.root);
        }
        return true;
    }

    public boolean bigRoot3(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.root);
        }
        return true;
    }

    public boolean bigRoot4(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.root);
        }
        return true;
    }

    public boolean bigRoot5(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.root);
        }
        return true;
    }

    public boolean bigRoot6(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.root);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.root);
        }
        return true;
    }

    public boolean genRing13(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 2), this.bark);
        }
        return true;
    }

    public boolean genRing12(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-6, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 5), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 6), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(6, 0, 1), this.bark);
        }
        return true;
    }

    public boolean genRing11(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-5, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 5), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(5, 0, 1), this.bark);
        }
        return true;
    }

    public boolean genRing10(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 2), this.bark);
        }
        return true;
    }

    public boolean genRing9(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-4, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 4), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(4, 0, 1), this.bark);
        }
        return true;
    }

    public boolean genRing8(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 2), this.bark);
        }
        return true;
    }

    public boolean genRing7(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-3, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 3), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(3, 0, 1), this.bark);
        }
        return true;
    }

    public boolean genRing6(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 2), this.bark);
        }
        return true;
    }

    public boolean genRing5(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(2, 0, 1), this.bark);
        }
        return true;
    }

    public boolean genRing4(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-2, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -2), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.heart);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.bark);
        }
        return true;
    }

    public boolean genRing3s(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.bark);
        }
        return true;
    }

    public boolean genRing3(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos, this.heart);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, 1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(1, 0, 1), this.bark);
        }
        return true;
    }

    public boolean genRing2(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(-1, 0, 0), this.bark);
            this.setBlockAndMetadata(world, pos.func_177982_a(0, 0, -1), this.bark);
            this.setBlockAndMetadata(world, pos, this.bark);
        }
        return true;
    }

    public boolean genRing1(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h && pos.func_177956_o() > 0) {
            this.setBlockAndMetadata(world, pos, this.bark);
        }
        return true;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int branchBase) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = branchBase;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

