/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModReinforced
extends ArmorModifierTrait {
    private static final float chancePerLevel = 0.2f;

    public ModReinforced() {
        super("reinforced", 5254787, 5, 0);
    }

    private float getReinforcedChance(NBTTagCompound modifierTag) {
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        return (float)data.level * 0.2f;
    }

    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        if (this.getReinforcedChance(modifierTag) >= 1.0f) {
            rootCompound.func_74757_a("Unbreakable", true);
        }
    }

    @Override
    public int onArmorDamage(ItemStack armor, DamageSource source, int damage, int newDamage, EntityPlayer player, int slot) {
        if (player.func_130014_f_().field_72995_K) {
            return 0;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)armor, (String)this.identifier);
        float chance = this.getReinforcedChance(tag);
        if (chance >= random.nextFloat()) {
            newDamage -= damage;
        }
        return Math.max(0, newDamage);
    }

    public String getLocalizedDesc() {
        return String.format(super.getLocalizedDesc(), Util.dfPercent.format(0.2f));
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)modifierTag);
        if (data.level == this.maxLevel) {
            return Util.translate((String)"modifier.%s.unbreakable", (Object[])new Object[]{TinkerModifiers.modReinforced.getIdentifier()});
        }
        return super.getTooltip(modifierTag, detailed);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        if (I18n.func_94522_b((String)loc)) {
            float chance = this.getReinforcedChance(modifierTag);
            String chanceStr = Util.dfPercent.format(chance);
            if (chance >= 1.0f) {
                chanceStr = Util.translate((String)"modifier.%s.unbreakable", (Object[])new Object[]{TinkerModifiers.modReinforced.getIdentifier()});
            }
            return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{chanceStr}));
        }
        return super.getExtraInfo(tool, modifierTag);
    }
}

