/*
 * Decompiled with CFR 0.152.
 */
package phylogeny.proportionaldestructionparticles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import phylogeny.proportionaldestructionparticles.ConfigMod;
import phylogeny.proportionaldestructionparticles.IProportionalDestructionParticleManager;
import phylogeny.proportionaldestructionparticles.api.ChiselsAndBitsAPIProxy;

public class ParticleManagerMod
extends ParticleManager
implements IProportionalDestructionParticleManager {
    public ParticleManagerMod(World world, TextureManager renderer) {
        super(world, renderer);
    }

    public void func_180533_a(BlockPos pos, IBlockState state) {
        if (ParticleManagerMod.addBlockDestroyEffects(pos, state, this.field_78878_a, this, 4.0)) {
            super.func_180533_a(pos, state);
        }
    }

    public static boolean addBlockDestroyEffects(BlockPos pos, IBlockState state, World world, IProportionalDestructionParticleManager particleManager, double particlesPerAxis) {
        if (!ConfigMod.CLIENT.enabled) {
            return true;
        }
        state = state.func_185899_b((IBlockAccess)world, pos);
        IBlockState stateParticle = null;
        if (ChiselsAndBitsAPIProxy.isBlockChiseled(world, pos)) {
            if (!ConfigMod.CLIENT.particlesPerBit) {
                stateParticle = ChiselsAndBitsAPIProxy.getPrimaryState(world, pos, state);
            }
        } else {
            if (state.func_177230_c().addDestroyEffects(world, pos, (ParticleManager)particleManager)) {
                return false;
            }
            stateParticle = state;
        }
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            ArrayList masks = Lists.newArrayList();
            if (ConfigMod.CLIENT.collisionBoxes) {
                state.func_185908_a(world, pos, TileEntity.INFINITE_EXTENT_AABB, (List)masks, null, true);
                masks.removeIf(box -> box == null || box.field_72336_d - box.field_72340_a == 0.0 || box.field_72337_e - box.field_72338_b == 0.0 || box.field_72334_f - box.field_72339_c == 0.0);
            }
            if (masks.isEmpty()) {
                AxisAlignedBB bounds = state.func_185900_c((IBlockAccess)world, pos);
                if (!ConfigMod.CLIENT.collisionBoxes && Block.field_185505_j.equals((Object)bounds) || bounds == null) {
                    return true;
                }
                masks.add(bounds.func_186670_a(pos));
            }
            if (stateParticle == null) {
                return !ChiselsAndBitsAPIProxy.spawnDestructionParticlesPerBit(world, pos, particleManager, particlesPerAxis, masks);
            }
            if (ConfigMod.CLIENT.random) {
                double volumeTotal = 1.0;
                double particlesCountTotal = particlesPerAxis * particlesPerAxis * particlesPerAxis;
                for (AxisAlignedBB mask : masks) {
                    mask = mask.func_186662_g(ConfigMod.CLIENT.boxGrowth).func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                    double d0 = mask.field_72336_d - mask.field_72340_a;
                    double d1 = mask.field_72337_e - mask.field_72338_b;
                    double d2 = mask.field_72334_f - mask.field_72339_c;
                    double count = Math.round(d0 * d1 * d2 / volumeTotal * particlesCountTotal);
                    mask = mask.func_186664_h(ConfigMod.CLIENT.boxGrowth);
                    mask = new AxisAlignedBB(Math.max(mask.field_72340_a, 0.125), Math.max(mask.field_72338_b, 0.125), Math.max(mask.field_72339_c, 0.125), Math.min(mask.field_72336_d, 0.875), Math.min(mask.field_72337_e, 0.875), Math.min(mask.field_72334_f, 0.875));
                    double dx = mask.field_72336_d - mask.field_72340_a;
                    double dy = mask.field_72337_e - mask.field_72338_b;
                    double dz = mask.field_72334_f - mask.field_72339_c;
                    int i = 0;
                    while ((double)i < count) {
                        d0 = mask.field_72340_a + dx * world.field_73012_v.nextDouble();
                        d1 = mask.field_72338_b + dy * world.field_73012_v.nextDouble();
                        d2 = mask.field_72339_c + dz * world.field_73012_v.nextDouble();
                        particleManager.addDestructionParticle(pos, stateParticle, world, d0 + (double)pos.func_177958_n(), d1 + (double)pos.func_177956_o(), d2 + (double)pos.func_177952_p(), d0 - 0.5, d1 - 0.5, d2 - 0.5);
                        ++i;
                    }
                }
                return false;
            }
            int j = 0;
            while ((double)j < particlesPerAxis) {
                int k = 0;
                while ((double)k < particlesPerAxis) {
                    int l = 0;
                    while ((double)l < particlesPerAxis) {
                        double d0 = ((double)j + 0.5) / particlesPerAxis;
                        double d1 = ((double)k + 0.5) / particlesPerAxis;
                        double d2 = ((double)l + 0.5) / particlesPerAxis;
                        double x = d0 + (double)pos.func_177958_n();
                        double y = d1 + (double)pos.func_177956_o();
                        double z = d2 + (double)pos.func_177952_p();
                        for (AxisAlignedBB mask : masks) {
                            if (!ParticleManagerMod.maskContainsVector(x, y, z, mask.func_186662_g(ConfigMod.CLIENT.boxGrowth))) continue;
                            particleManager.addDestructionParticle(pos, stateParticle, world, x, y, z, d0 - 0.5, d1 - 0.5, d2 - 0.5);
                            break;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
        }
        return false;
    }

    public static boolean maskContainsVector(double x, double y, double z, AxisAlignedBB mask) {
        if (x > mask.field_72340_a && x < mask.field_72336_d) {
            if (y > mask.field_72338_b && y < mask.field_72337_e) {
                return z > mask.field_72339_c && z < mask.field_72334_f;
            }
            return false;
        }
        return false;
    }

    @Override
    public void addDestructionParticle(BlockPos pos, IBlockState state, World world, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        this.func_78873_a((Particle)new ParticleDiggingMod(world, x, y, z, xMotion, yMotion, zMotion, state).func_174846_a(pos));
    }

    private static class ParticleDiggingMod
    extends ParticleDigging {
        protected ParticleDiggingMod(World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, IBlockState state) {
            super(world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, state);
        }
    }
}

