/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.common.capability.base.AbstractCapability;

public class NBTHelper {
    public static NBTTagCompound getStackNBTSafe(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean areItemStackTagsEqualWithoutCapabilities(ItemStack a, ItemStack b, AbstractCapability<?, ?, ?> ... exclusions) {
        ArrayList<String> strExclusions = new ArrayList<String>();
        for (AbstractCapability<?, ?, ?> exclusion : exclusions) {
            strExclusions.add("ForgeCaps." + exclusion.getID().toString());
        }
        return NBTHelper.areItemStackTagsEqual(a, b, strExclusions);
    }

    public static boolean areItemStackTagsEqual(ItemStack a, ItemStack b, Collection<String> exclusions) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a.func_77978_p() == null && b.func_77978_p() == null) {
                return true;
            }
            if (a.func_77978_p() == null ^ b.func_77978_p() == null) {
                return false;
            }
            return NBTHelper.areNBTCompoundsEquals(a.func_77978_p(), b.func_77978_p(), exclusions);
        }
        return false;
    }

    public static boolean areNBTCompoundsEquals(NBTTagCompound a, NBTTagCompound b, Collection<String> exclusions) {
        Stack<String> tagOwners = new Stack<String>();
        Stack<NBTTagCompound> aTagCompounds = new Stack<NBTTagCompound>();
        Stack<NBTTagCompound> bTagCompounds = new Stack<NBTTagCompound>();
        tagOwners.push("");
        aTagCompounds.push(a);
        bTagCompounds.push(b);
        while (!aTagCompounds.isEmpty()) {
            String tagOwner = (String)tagOwners.pop();
            NBTTagCompound aCurrentTagCompound = (NBTTagCompound)aTagCompounds.pop();
            NBTTagCompound bCurrentTagCompound = (NBTTagCompound)bTagCompounds.pop();
            Set aKeys = aCurrentTagCompound.func_150296_c();
            Set bKeys = bCurrentTagCompound.func_150296_c();
            for (String key : bKeys) {
                if (exclusions.contains(key) || aKeys.contains(key)) continue;
                return false;
            }
            for (String key : aKeys) {
                String totalKey;
                String string = totalKey = tagOwner == "" ? key : tagOwner + '.' + key;
                if (exclusions.contains(totalKey)) continue;
                NBTBase aTag = aCurrentTagCompound.func_74781_a(key);
                NBTBase bTag = bCurrentTagCompound.func_74781_a(key);
                if (aTag instanceof NBTTagCompound && bTag instanceof NBTTagCompound) {
                    tagOwners.push(totalKey);
                    aTagCompounds.push((NBTTagCompound)aTag);
                    bTagCompounds.push((NBTTagCompound)bTag);
                    continue;
                }
                if (aTag.equals((Object)bTag)) continue;
                return false;
            }
        }
        return true;
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tag, IInventory inventory) {
        return NBTHelper.saveAllItems(tag, inventory, true);
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tag, IInventory inventory, boolean saveEmpty) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d() || saveEmpty) {
            tag.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        return tag;
    }

    public static void loadAllItems(NBTTagCompound tag, IInventory inventory) {
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= inventory.func_70302_i_()) continue;
            inventory.func_70299_a(j, new ItemStack(nbttagcompound));
        }
    }
}

