/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.hwyla;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.config.FormattingConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidRegistry;
import thebetweenlands.common.block.farming.BlockBarnacle_1_2;
import thebetweenlands.common.block.farming.BlockBarnacle_3_4;
import thebetweenlands.common.registries.BlockRegistry;

public class UnderwaterBarnacleProvider
implements IWailaDataProvider {
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        IBlockState state = accessor.getBlockState();
        String name = new TextComponentTranslation("tile.thebetweenlands.barnacle_1_2.name", new Object[0]).func_150254_d();
        if (block instanceof BlockBarnacle_1_2 || block instanceof BlockBarnacle_3_4) {
            if (block == BlockRegistry.BARNACLE_1_2) {
                if (block.func_176201_c(state) <= 5) {
                    name = new TextComponentTranslation("tooltip.thebetweenlands.barnacle_stage_1.name", new Object[0]).func_150254_d();
                }
                if (block.func_176201_c(state) > 5 && block.func_176201_c(state) <= 11) {
                    name = new TextComponentTranslation("tooltip.thebetweenlands.barnacle_stage_2.name", new Object[0]).func_150254_d();
                }
            }
            if (block == BlockRegistry.BARNACLE_3_4) {
                if (block.func_176201_c(state) <= 5) {
                    name = new TextComponentTranslation("tooltip.thebetweenlands.barnacle_stage_3.name", new Object[0]).func_150254_d();
                }
                if (block.func_176201_c(state) > 5 && block.func_176201_c(state) <= 11) {
                    name = new TextComponentTranslation("tooltip.thebetweenlands.barnacle_stage_4.name", new Object[0]).func_150254_d();
                }
            }
            ItemStack patchedStack = new ItemStack(Item.func_150898_a((Block)BlockRegistry.BARNACLE_1_2)).func_190924_f(name);
            return patchedStack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        tooltip.clear();
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            String name = null;
            String displayName = DisplayUtil.itemDisplayNameShort((ItemStack)itemStack);
            if (displayName != null && !displayName.endsWith("Unnamed")) {
                name = displayName;
            }
            if (name != null) {
                tooltip.add(name);
            }
            if (ConfigHandler.instance().getConfig("general", "waila.cfg.metadata", true) && !Strings.isNullOrEmpty((String)FormattingConfig.metaFormat)) {
                tooltip.add("\u00a7r" + String.format(FormattingConfig.metaFormat, accessor.getBlock().getRegistryName().toString(), accessor.getMetadata()));
            }
        }
        return tooltip;
    }
}

