/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.storage.IWorldStorage;
import thebetweenlands.api.storage.LocalRegion;
import thebetweenlands.api.storage.StorageID;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class LocationTokenBucket
extends LocationStorage
implements ITickable {
    private ResourceLocation bucketId;
    private boolean useWorldtime = true;
    private int expirationTime = 1200;
    private int minTokensPerTick = 1;
    private int maxTokensPerTick = 1;
    private double limitMultiplier = 0.99;
    private final List<Ticket> tickets = new ArrayList<Ticket>();
    private final Map<ResourceLocation, Ticket> key2tickets = new HashMap<ResourceLocation, Ticket>();
    private long lastCheckedTime;
    private float sharedTokenFraction;
    private long sharedTokens;

    public LocationTokenBucket(IWorldStorage worldStorage, StorageID id, LocalRegion region) {
        super(worldStorage, id, region, "token_bucket", EnumLocationType.NONE);
    }

    public LocationTokenBucket(IWorldStorage worldStorage, StorageID id, LocalRegion region, AxisAlignedBB aabb, ResourceLocation bucketId) {
        this(worldStorage, id, region);
        this.addBounds(aabb);
        this.bucketId = bucketId;
        this.lastCheckedTime = worldStorage.getWorld().func_82737_E();
    }

    public ResourceLocation getBucketId() {
        return this.bucketId;
    }

    public LocationTokenBucket setUseWorldTime(boolean useWorldTime) {
        this.useWorldtime = useWorldTime;
        this.markDirty();
        return this;
    }

    public LocationTokenBucket setExpirationTime(int time) {
        this.expirationTime = time;
        this.markDirty();
        return this;
    }

    public void refreshTicket(ResourceLocation key, AxisAlignedBB area) {
        if (area.func_72326_a(this.getBoundingBox())) {
            Ticket ticket = this.key2tickets.get(key);
            if (ticket == null) {
                ticket = new Ticket(key, area);
                this.tickets.add(ticket);
                this.key2tickets.put(key, ticket);
            }
            ticket.counter = 0;
            this.sharedTokens += ticket.reservedTokens;
            ticket.reservedTokens = 0L;
            this.markDirty();
        }
    }

    public LocationTokenBucket setMinTokensPerTick(int min) {
        this.minTokensPerTick = MathHelper.func_76125_a((int)min, (int)0, (int)this.maxTokensPerTick);
        this.markDirty();
        return this;
    }

    public LocationTokenBucket setMaxTokensPerTick(int max) {
        this.maxTokensPerTick = Math.max(this.minTokensPerTick, max);
        this.markDirty();
        return this;
    }

    public LocationTokenBucket setTokensPerTick(int min, int max) {
        this.minTokensPerTick = Math.max(0, min);
        this.setMaxTokensPerTick(max);
        this.markDirty();
        return this;
    }

    public LocationTokenBucket setLimitMultiplier(double multiplier) {
        this.limitMultiplier = multiplier;
        return this;
    }

    public long getTokens() {
        return this.sharedTokens;
    }

    public long consumeTokens(long tokens) {
        long consumed = Math.max(0L, Math.min(tokens, this.sharedTokens));
        this.sharedTokens -= consumed;
        this.markDirty();
        return consumed;
    }

    public boolean consumeTokensAtomically(long tokens) {
        if (this.sharedTokens >= tokens) {
            this.sharedTokens -= tokens;
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.bucketId = new ResourceLocation(nbt.func_74779_i("bucketId"));
        this.useWorldtime = nbt.func_74767_n("fillWhenUnloaded");
        this.expirationTime = nbt.func_74762_e("expirationTime");
        this.minTokensPerTick = nbt.func_74762_e("minTokensPerTick");
        this.maxTokensPerTick = nbt.func_74762_e("maxTokensPerTick");
        this.lastCheckedTime = nbt.func_74763_f("lastCheckedTime");
        this.sharedTokens = nbt.func_74763_f("tokens");
        this.tickets.clear();
        this.key2tickets.clear();
        NBTTagList ticketsNbt = nbt.func_150295_c("tickets", 10);
        for (int i = 0; i < ticketsNbt.func_74745_c(); ++i) {
            NBTTagCompound ticketNbt = ticketsNbt.func_150305_b(i);
            ResourceLocation key = new ResourceLocation(ticketNbt.func_74779_i("key"));
            Ticket ticket = new Ticket(key, new AxisAlignedBB(ticketNbt.func_74769_h("minX"), ticketNbt.func_74769_h("minY"), ticketNbt.func_74769_h("minZ"), ticketNbt.func_74769_h("maxX"), ticketNbt.func_74769_h("maxY"), ticketNbt.func_74769_h("maxZ")));
            ticket.counter = ticketNbt.func_74762_e("counter");
            ticket.reservedTokens = ticketNbt.func_74763_f("reservedTokens");
            this.tickets.add(ticket);
            this.key2tickets.put(key, ticket);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74778_a("bucketId", this.bucketId.toString());
        nbt.func_74757_a("fillWhenUnloaded", this.useWorldtime);
        nbt.func_74768_a("expirationTime", this.expirationTime);
        nbt.func_74768_a("minTokensPerTick", this.minTokensPerTick);
        nbt.func_74768_a("maxTokensPerTick", this.maxTokensPerTick);
        nbt.func_74772_a("lastCheckedTime", this.lastCheckedTime);
        nbt.func_74772_a("tokens", this.sharedTokens);
        NBTTagList ticketsNbt = new NBTTagList();
        for (Ticket ticket : this.tickets) {
            NBTTagCompound ticketNbt = new NBTTagCompound();
            ticketNbt.func_74768_a("counter", ticket.counter);
            ticketNbt.func_74772_a("reservedTokens", ticket.reservedTokens);
            ticketNbt.func_74778_a("key", ticket.key.toString());
            ticketNbt.func_74780_a("minX", ((Ticket)ticket).area.field_72340_a);
            ticketNbt.func_74780_a("minY", ((Ticket)ticket).area.field_72338_b);
            ticketNbt.func_74780_a("minZ", ((Ticket)ticket).area.field_72339_c);
            ticketNbt.func_74780_a("maxX", ((Ticket)ticket).area.field_72336_d);
            ticketNbt.func_74780_a("maxY", ((Ticket)ticket).area.field_72337_e);
            ticketNbt.func_74780_a("maxZ", ((Ticket)ticket).area.field_72334_f);
            ticketsNbt.func_74742_a((NBTBase)ticketNbt);
        }
        nbt.func_74782_a("tickets", (NBTBase)ticketsNbt);
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73660_a() {
        int n;
        World world = this.getWorldStorage().getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos.PooledMutableBlockPos checkPos1 = BlockPos.PooledMutableBlockPos.func_185346_s();
        BlockPos.PooledMutableBlockPos checkPos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            Iterator<Ticket> it = this.tickets.iterator();
            while (it.hasNext()) {
                Ticket ticket = it.next();
                checkPos1.func_189532_c(((Ticket)ticket).area.field_72340_a, ((Ticket)ticket).area.field_72338_b, ((Ticket)ticket).area.field_72339_c);
                checkPos2.func_189532_c(((Ticket)ticket).area.field_72336_d, ((Ticket)ticket).area.field_72337_e, ((Ticket)ticket).area.field_72334_f);
                ticket.loaded = world.func_175707_a((BlockPos)checkPos1, (BlockPos)checkPos2);
                if (!ticket.loaded) continue;
                ticket.counter++;
                if (ticket.counter < this.expirationTime) continue;
                it.remove();
                this.key2tickets.remove(ticket.key);
            }
        }
        finally {
            checkPos1.func_185344_t();
            checkPos2.func_185344_t();
        }
        if (this.tickets.isEmpty()) {
            this.getWorldStorage().getLocalStorageHandler().removeLocalStorage(this);
            return;
        }
        long worldTime = world.func_82737_E();
        long ticks = this.useWorldtime ? Math.max(worldTime - this.lastCheckedTime, 0L) : 1L;
        this.lastCheckedTime = worldTime;
        long decay = Math.max(this.sharedTokens - (long)Math.floor((double)this.sharedTokens * this.limitMultiplier) - 1L, 0L);
        long newTokens = Math.max(this.generateTokens(ticks) - decay, 0L);
        if (newTokens < (long)(n = this.tickets.size())) {
            int i = 0;
            while ((long)i < newTokens) {
                Ticket ticket = this.tickets.get(world.field_73012_v.nextInt(n));
                if (ticket.loaded) {
                    ++this.sharedTokens;
                } else {
                    ticket.reservedTokens++;
                }
                ++i;
            }
        } else {
            long f = newTokens / (long)n;
            long r = newTokens % (long)n;
            int i = 0;
            for (Ticket ticket : this.tickets) {
                long ticketFraction = (long)(++i) <= r ? f + 1L : f;
                if (ticket.loaded) {
                    this.sharedTokens += ticketFraction;
                    continue;
                }
                Ticket ticket2 = ticket;
                ticket2.reservedTokens = ticket2.reservedTokens + ticketFraction;
            }
        }
        if (BetweenlandsConfig.DEBUG.debug && worldTime % 20L == 0L) {
            int reservedTokens = 0;
            for (Ticket ticket : this.tickets) {
                reservedTokens = (int)((long)reservedTokens + ticket.reservedTokens);
            }
            this.setName("token_bucket_" + this.bucketId + "_" + this.sharedTokens + "_" + reservedTokens);
        }
        this.markDirty();
    }

    protected long generateTokens(long ticks) {
        if (ticks == 1L) {
            return this.getWorldStorage().getWorld().field_73012_v.nextInt(Math.max(this.maxTokensPerTick - this.minTokensPerTick, 0) + 1) + this.minTokensPerTick;
        }
        float tokens = (float)(ticks * (long)(this.maxTokensPerTick + this.minTokensPerTick)) / 2.0f;
        return this.getWorldStorage().getWorld().field_73012_v.nextBoolean() ? (long)MathHelper.func_76141_d((float)tokens) : (long)MathHelper.func_76123_f((float)tokens);
    }

    private static class Ticket {
        private final ResourceLocation key;
        private final AxisAlignedBB area;
        private int counter;
        private float reservedTokenFraction;
        private long reservedTokens;
        private boolean loaded = true;

        private Ticket(ResourceLocation key, AxisAlignedBB area) {
            this.key = key;
            this.area = area;
        }
    }
}

