/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.layer;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import thebetweenlands.common.world.gen.layer.GenLayerBetweenlands;
import thebetweenlands.common.world.gen.layer.InstancedIntCache;

public class GenLayerSurrounded
extends GenLayerBetweenlands {
    private final int checkRange;
    private final float spawnChance;
    private final int surrounding;
    private final int biome;

    public GenLayerSurrounded(InstancedIntCache cache, long seed, GenLayer parentGenLayer, Biome surrounding, Biome biome, int checkRange, float spawnChance) {
        super(cache, seed);
        this.field_75909_a = parentGenLayer;
        this.checkRange = checkRange;
        this.spawnChance = spawnChance;
        this.surrounding = Biome.func_185362_a((Biome)surrounding);
        this.biome = Biome.func_185362_a((Biome)biome);
    }

    public int[] func_75904_a(int areaX, int areaZ, int sizeX, int sizeZ) {
        int[] currentBiomeInts = this.field_75909_a.func_75904_a(areaX - this.checkRange, areaZ - this.checkRange, sizeX + this.checkRange * 2, sizeZ + this.checkRange * 2);
        int[] biomeInts = this.cache.getIntCache(sizeX * sizeZ);
        for (int zz = 0; zz < sizeZ; ++zz) {
            for (int xx = 0; xx < sizeX; ++xx) {
                this.func_75903_a(areaX + xx, areaZ + zz);
                biomeInts[xx + zz * sizeX] = currentBiomeInts[xx + this.checkRange + (zz + this.checkRange) * (sizeX + this.checkRange * 2)];
                boolean surrounded = true;
                block2: for (int xo = -this.checkRange; xo <= this.checkRange; ++xo) {
                    for (int zo = -this.checkRange; zo <= this.checkRange; ++zo) {
                        int biomeID;
                        if (xo * xo + zo * zo > this.checkRange * this.checkRange + 1 || (biomeID = currentBiomeInts[xx + this.checkRange + xo + (zz + this.checkRange + zo) * (sizeX + this.checkRange * 2)]) == this.surrounding) continue;
                        surrounded = false;
                        break block2;
                    }
                }
                if (!surrounded || !((float)this.func_75902_a(10000) <= this.spawnChance * 10000.0f)) continue;
                biomeInts[xx + zz * sizeX] = this.biome;
            }
        }
        return biomeInts;
    }
}

