/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature.tree;

import java.util.Random;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.tree.WorldGenGiantTreeTrunk;

public class Fungus {
    private int posX;
    private int posY;
    private int posZ;
    private int radius;

    public Fungus(BlockPos pos, int radius) {
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.radius = radius;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public void generate(World world, Random rand) {
        for (int y = this.posY; y > this.posY - this.radius; y -= 2) {
            if (this.radius > 1) {
                --this.radius;
            }
            BlockPos center = new BlockPos(this.posX, y, this.posZ);
            Stack<BlockPos> pendingCoords = new Stack<BlockPos>();
            pendingCoords.add(center);
            while (!pendingCoords.isEmpty()) {
                BlockPos coord = (BlockPos)pendingCoords.pop();
                if (world.func_180495_p(coord).func_185904_a().func_76222_j() || world.func_180495_p(coord.func_177984_a()).func_185904_a().func_76222_j()) {
                    world.func_175656_a(coord, BlockRegistry.SHELF_FUNGUS.func_176223_P());
                }
                for (EnumFacing direction : WorldGenGiantTreeTrunk.DIRECTIONS) {
                    BlockPos neighborCoord = new BlockPos(coord.func_177958_n() + direction.func_82601_c(), coord.func_177956_o(), coord.func_177952_p() + direction.func_82599_e());
                    IBlockState block = world.func_180495_p(neighborCoord);
                    IBlockState above = world.func_180495_p(neighborCoord.func_177984_a());
                    if (pendingCoords.contains(neighborCoord) || this.getDistanceBetweenChunkCoordinates(center, neighborCoord) > this.radius || !block.func_185904_a().func_76222_j() && (!above.func_185904_a().func_76222_j() || block.func_177230_c() == BlockRegistry.SHELF_FUNGUS)) continue;
                    pendingCoords.add(neighborCoord);
                }
            }
        }
    }

    private int getDistanceBetweenChunkCoordinates(BlockPos a, BlockPos b) {
        return (int)Math.round(Math.sqrt(a.func_177954_c((double)b.func_177958_n(), (double)b.func_177956_o(), (double)b.func_177952_p())));
    }
}

