/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.container.BlockSmokingRack;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.recipe.misc.SmokingRackRecipe;
import thebetweenlands.common.registries.BlockRegistry;

public class TileEntitySmokingRack
extends TileEntity
implements ITickable,
IInventory {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    public int MAX_SMOKING_TIME = 200;
    public int curing_modifier_1 = 1;
    public int curing_modifier_2 = 1;
    public int curing_modifier_3 = 1;
    public int smoke_progress = 0;
    public int slot_1_progress = 0;
    public int slot_2_progress = 0;
    public int slot_3_progress = 0;
    public boolean active;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        BlockPos pos = this.func_174877_v();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistry.PEAT_SMOULDERING && !this.active) {
            this.active = true;
            this.markForUpdate();
        }
        if (this.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() != BlockRegistry.PEAT_SMOULDERING && this.active) {
            this.active = false;
            this.markForUpdate();
        }
        if (this.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockSmokingRack && this.active) {
            if (this.updateFuelState()) {
                this.setSmokeProgress(this.getSmokeProgress() + 1);
                if (this.getSmokeProgress() % 10 == 0) {
                    this.markForUpdate();
                }
                if (this.getSmokeProgress() > this.MAX_SMOKING_TIME) {
                    this.consumeFuel();
                }
            }
            for (int i = 0; i < 3; ++i) {
                if (this.canSmokeSlots(1 + i, 4 + i)) {
                    this.updateCuringModifier(1 + i);
                    this.setSlotProgress(1 + i, this.getSlotProgress(1 + i) + 1);
                    if (this.getSlotProgress(1 + i) < this.MAX_SMOKING_TIME * this.curing_modifier_1) continue;
                    this.smokeItem(1 + i, 4 + i);
                    continue;
                }
                if (this.getSlotProgress(1 + i) <= 0) continue;
                this.setSlotProgress(1 + i, 0);
                this.markForUpdate();
            }
        } else {
            if (this.getSmokeProgress() > 0) {
                this.setSmokeProgress(0);
                this.markForUpdate();
            }
            for (int i = 0; i < 3; ++i) {
                if (this.getSlotProgress(1 + i) <= 0) continue;
                this.setSlotProgress(1 + i, 0);
                this.markForUpdate();
            }
        }
    }

    private void setSlotProgress(int slot, int counter) {
        switch (slot) {
            case 0: {
                break;
            }
            case 1: {
                this.slot_1_progress = counter;
                break;
            }
            case 2: {
                this.slot_2_progress = counter;
                break;
            }
            case 3: {
                this.slot_3_progress = counter;
            }
        }
    }

    private int getSlotProgress(int slot) {
        switch (slot) {
            case 0: {
                break;
            }
            case 1: {
                return this.slot_1_progress;
            }
            case 2: {
                return this.slot_2_progress;
            }
            case 3: {
                return this.slot_3_progress;
            }
        }
        return 0;
    }

    public Entity getRenderEntity(int slot) {
        ItemStack stack = (ItemStack)this.getItems().get(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMob && ((ItemMob)stack.func_77973_b()).hasEntityData(stack)) {
            return ((ItemMob)stack.func_77973_b()).createCapturedEntity(this.field_145850_b, 0.0, 0.0, 0.0, stack, false);
        }
        return null;
    }

    public void consumeFuel() {
        ItemStack fuelStack = (ItemStack)this.getItems().get(0);
        this.setSmokeProgress(0);
        this.markForUpdate();
        fuelStack.func_190918_g(1);
    }

    private boolean canSmokeSlots(int input, int output) {
        NBTTagCompound entityNbt;
        if (!this.active || !this.updateFuelState() || ((ItemStack)this.getItems().get(input)).func_190926_b() || !((ItemStack)this.getItems().get(output)).func_190926_b()) {
            return false;
        }
        ItemStack result = SmokingRackRecipe.getRecipeOutput((ItemStack)this.getItems().get(input));
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack stack = (ItemStack)this.getItems().get(input);
        return stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMob) || !((ItemMob)stack.func_77973_b()).hasEntityData(stack) || (entityNbt = ((ItemMob)stack.func_77973_b()).getEntityData(stack)) == null || !entityNbt.func_74764_b("fishColour") || entityNbt.func_74771_c("fishColour") != 0 && entityNbt.func_74771_c("fishColour") != 1;
    }

    private int updateCuringModifier(int slot) {
        int modifier = SmokingRackRecipe.getSmokingRecipe((ItemStack)this.getItems().get(slot)).getSmokingTime((ItemStack)this.getItems().get(slot));
        if (modifier <= 0) {
            modifier = 1;
        }
        switch (slot) {
            case 0: {
                break;
            }
            case 1: {
                if (this.curing_modifier_1 == modifier) break;
                this.curing_modifier_1 = modifier;
                this.markForUpdate();
                break;
            }
            case 2: {
                if (this.curing_modifier_2 == modifier) break;
                this.curing_modifier_2 = modifier;
                this.markForUpdate();
                break;
            }
            case 3: {
                if (this.curing_modifier_3 == modifier) break;
                this.curing_modifier_3 = modifier;
                this.markForUpdate();
            }
        }
        return modifier;
    }

    public boolean updateFuelState() {
        ItemStack fuelStack = (ItemStack)this.getItems().get(0);
        if (!fuelStack.func_190926_b()) {
            return true;
        }
        if (this.getSmokeProgress() > 0) {
            this.setSmokeProgress(0);
            this.markForUpdate();
        }
        return false;
    }

    public void smokeItem(int input, int output) {
        if (this.canSmokeSlots(input, output)) {
            ItemStack itemstack = (ItemStack)this.getItems().get(input);
            ItemStack result = SmokingRackRecipe.getRecipeOutput(itemstack);
            ItemStack itemstack2 = (ItemStack)this.getItems().get(output);
            if (itemstack2.func_190926_b()) {
                this.getItems().set(output, (Object)result.func_77946_l());
            }
            this.setSlotProgress(input, 0);
            this.markForUpdate();
            itemstack.func_190918_g(1);
        }
    }

    public void setSmokeProgress(int duration) {
        this.smoke_progress = duration;
    }

    private int getSmokeProgress() {
        return this.smoke_progress;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSmokeProgressScaled(int index, int count) {
        return this.getSmokeProgress() * count / this.MAX_SMOKING_TIME;
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemProgressScaledTop(int index, int count) {
        return this.getSlotProgress(1) * count / (this.MAX_SMOKING_TIME * this.curing_modifier_1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemProgressScaledMid(int index, int count) {
        return this.getSlotProgress(2) * count / (this.MAX_SMOKING_TIME * this.curing_modifier_2);
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemProgressScaledBottom(int index, int count) {
        return this.getSlotProgress(3) * count / (this.MAX_SMOKING_TIME * this.curing_modifier_3);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b(0.0, 1.0, 0.0);
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadFromNbt(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.saveToNbt(nbt);
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (nbt.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
        }
        this.active = nbt.func_74767_n("active");
        this.smoke_progress = nbt.func_74762_e("smoke_progress");
        this.slot_1_progress = nbt.func_74762_e("slot_1_progress");
        this.slot_2_progress = nbt.func_74762_e("slot_2_progress");
        this.slot_3_progress = nbt.func_74762_e("slot_3_progress");
        this.curing_modifier_1 = nbt.func_74762_e("curing_modifier_1");
        this.curing_modifier_2 = nbt.func_74762_e("curing_modifier_2");
        this.curing_modifier_3 = nbt.func_74762_e("curing_modifier_3");
    }

    public NBTTagCompound saveToNbt(NBTTagCompound nbt) {
        ItemStackHelper.func_191281_a((NBTTagCompound)nbt, this.inventory, (boolean)false);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("smoke_progress", this.smoke_progress);
        nbt.func_74768_a("slot_1_progress", this.slot_1_progress);
        nbt.func_74768_a("slot_2_progress", this.slot_2_progress);
        nbt.func_74768_a("slot_3_progress", this.slot_3_progress);
        nbt.func_74768_a("curing_modifier_1", this.curing_modifier_1);
        nbt.func_74768_a("curing_modifier_2", this.curing_modifier_2);
        nbt.func_74768_a("curing_modifier_3", this.curing_modifier_3);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public String func_70005_c_() {
        return new TextComponentTranslation("tile.thebetweenlands.smoking_rack.name", new Object[0]).func_150254_d();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

