/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.plant.BlockWeedwoodBush;
import thebetweenlands.common.block.plant.BlockWeedwoodBushInfested;
import thebetweenlands.common.network.clientbound.MessageInfestWeedwoodBush;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.FluidTankTile;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityGrubHub
extends TileEntityBasicInventory
implements ITickable {
    public FluidTankTile tank = new FluidTankTile(8000){

        @Override
        public boolean canFillFluidType(FluidStack fluid) {
            return this.canFill() && fluid.getFluid() == FluidRegistry.DRINKABLE_BREW && fluid.tag != null && fluid.tag.func_74764_b("type") && fluid.tag.func_74762_e("type") == 2;
        }
    };
    private IItemHandler itemHandler;
    public int switchTextureCount = 0;

    public TileEntityGrubHub() {
        super(1, "container.bl.grub_hub");
        this.tank.setTileEntity(this);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.func_145831_w().func_82737_E() % 10L == 0L) {
            this.checkCanInfestOrHarvest(this.func_145831_w());
        }
        if (this.field_145850_b.field_72995_K && this.switchTextureCount > 0) {
            --this.switchTextureCount;
        }
    }

    private void checkCanInfestOrHarvest(World world) {
        AxisAlignedBB axisalignedbb = this.areaOfEffect();
        int minX = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)axisalignedbb.field_72336_d);
        int minY = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)axisalignedbb.field_72334_f);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    IBlockState state = this.func_145831_w().func_180495_p((BlockPos)mutablePos.func_181079_c(x, y, z));
                    if (state.func_177230_c() instanceof BlockWeedwoodBush && !(state.func_177230_c() instanceof BlockWeedwoodBushInfested) && this.tank.getFluidAmount() >= 50) {
                        this.infestBush(mutablePos);
                        continue;
                    }
                    if (!(state.func_177230_c() instanceof BlockWeedwoodBushInfested) || state.func_177230_c() != BlockRegistry.WEEDWOOD_BUSH_INFESTED_2 || !this.canAddGrub(0)) continue;
                    this.harvestGrub(mutablePos);
                }
            }
        }
    }

    private void harvestGrub(BlockPos.MutableBlockPos mutablePos) {
        this.func_145831_w().func_184133_a(null, this.field_174879_c, (SoundEvent)SoundRegistry.GRUB_HUB_SUCK, SoundCategory.BLOCKS, 0.5f, 1.0f);
        this.func_145831_w().func_180501_a((BlockPos)mutablePos, BlockRegistry.WEEDWOOD_BUSH.func_176223_P(), 3);
        ItemStack contents = this.func_70301_a(0);
        ItemStack silk_grub = new ItemStack(ItemRegistry.SILK_GRUB, 1);
        if (contents.func_190926_b()) {
            this.func_70299_a(0, silk_grub);
        } else {
            contents.func_190917_f(1);
        }
        this.markForUpdate();
        this.func_70296_d();
    }

    private boolean canAddGrub(int slot) {
        ItemStack contents = this.func_70301_a(slot);
        return contents.func_190926_b() ? true : !contents.func_190926_b() && contents.func_77973_b() == ItemRegistry.SILK_GRUB && contents.func_190916_E() < this.func_70297_j_();
    }

    private void infestBush(BlockPos.MutableBlockPos mutablePos) {
        this.func_145831_w().func_184133_a(null, this.field_174879_c, (SoundEvent)SoundRegistry.GRUB_HUB_MIST, SoundCategory.BLOCKS, 0.5f, 1.0f);
        this.func_145831_w().func_180501_a((BlockPos)mutablePos, BlockRegistry.WEEDWOOD_BUSH_INFESTED_0.func_176223_P(), 3);
        this.tank.drain(50, true);
        this.markForUpdate();
        this.func_70296_d();
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageInfestWeedwoodBush(this, mutablePos.func_185334_h()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 32.0));
    }

    public AxisAlignedBB areaOfEffect() {
        return new AxisAlignedBB(this.field_174879_c.func_177977_b()).func_72314_b(1.0, 0.0, 1.0);
    }

    public int getTankFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readPacketNbt(packet.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writePacketNbt(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writePacketNbt(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readPacketNbt(nbt);
    }

    protected NBTTagCompound writePacketNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    protected void readPacketNbt(NBTTagCompound nbt) {
        NBTTagCompound compound = nbt;
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.readInventoryNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        int[] SLOTS = new int[this.func_70302_i_()];
        for (int index = 0; index < SLOTS.length; ++index) {
            SLOTS[index] = index;
        }
        return SLOTS;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return stack.func_77973_b() == ItemRegistry.SILK_GRUB;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == ItemRegistry.SILK_GRUB;
    }
}

