/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import thebetweenlands.common.entity.EntityFishingTackleBoxSeat;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.util.InventoryUtils;

public class TileEntityFishingTackleBox
extends TileEntity
implements ITickable,
IInventory {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    public final float MAX_OPEN = 120.0f;
    public final float MIN_OPEN = 0.0f;
    public final float OPEN_SPEED = 10.0f;
    public final float CLOSE_SPEED = 10.0f;
    private boolean open = false;
    private float lid_angle = 0.0f;

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void func_73660_a() {
        this.lid_angle = this.open ? Math.min(this.lid_angle + 10.0f, 120.0f) : Math.max(this.lid_angle - 10.0f, 0.0f);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadFromNbt(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.saveToNbt(nbt);
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (nbt.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
        }
        this.open = nbt.func_74767_n("open");
        this.lid_angle = nbt.func_74760_g("lid_angle");
    }

    public NBTTagCompound saveToNbt(NBTTagCompound nbt) {
        ItemStackHelper.func_191281_a((NBTTagCompound)nbt, this.inventory, (boolean)false);
        nbt.func_74757_a("open", this.open);
        nbt.func_74776_a("lid_angle", this.lid_angle);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public float getLidAngle(float partialTicks) {
        return this.open ? Math.min(this.lid_angle + 10.0f * partialTicks, 120.0f) : Math.max(this.lid_angle - 10.0f * partialTicks, 0.0f);
    }

    public void seatPlayer(EntityPlayer player, BlockPos pos) {
        EntityFishingTackleBoxSeat entitySeat = new EntityFishingTackleBoxSeat(this.field_145850_b);
        entitySeat.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        entitySeat.setSeatOffset(0.1f);
        this.field_145850_b.func_72838_d((Entity)entitySeat);
        player.func_184205_a((Entity)entitySeat, true);
        if (player instanceof EntityPlayerMP) {
            AdvancementCriterionRegistry.SIT_ON_TACKLE_BOX.trigger((EntityPlayerMP)player);
        }
    }

    public String func_70005_c_() {
        return new TextComponentTranslation("tile.thebetweenlands.fishing_tackle_box.name", new Object[0]).func_150254_d();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return !InventoryUtils.isDisallowedInInventories(itemstack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

