/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.farming.BlockGenericCrop;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;

public class TileEntityDugSoil
extends TileEntity {
    private int compost = 0;
    private int decay = 0;
    private int purifiedHarvests = 0;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.decay = nbt.func_74762_e("decay");
        this.compost = nbt.func_74762_e("compost");
        this.purifiedHarvests = nbt.func_74762_e("purifiedHarvests");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("compost", this.compost);
        nbt.func_74768_a("decay", this.decay);
        nbt.func_74768_a("purifiedHarvests", this.purifiedHarvests);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("compost", this.compost);
        nbt.func_74768_a("decay", this.decay);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.decay = nbt.func_74762_e("decay");
        this.compost = nbt.func_74762_e("compost");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void copy(TileEntityDugSoil other) {
        this.setDecay(other.decay);
        this.setCompost(other.compost);
    }

    public void setPurifiedHarvests(int harvests) {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockGenericDugSoil soil = (BlockGenericDugSoil)blockState.func_177230_c();
        if (soil.isPurified(this.field_145850_b, this.field_174879_c, blockState)) {
            if (harvests < 0) {
                harvests = 0;
            }
            int maxHarvests = soil.getPurifiedHarvests(this.field_145850_b, this.field_174879_c, blockState);
            this.purifiedHarvests = harvests;
            if (this.purifiedHarvests >= maxHarvests) {
                this.field_145850_b.func_180501_a(this.field_174879_c, soil.getUnpurifiedDugSoil(this.field_145850_b, this.field_174879_c, blockState), 3);
                BlockGenericDugSoil.copy(this.field_145850_b, this.field_174879_c, this);
            }
        } else {
            this.purifiedHarvests = 0;
        }
        this.func_70296_d();
    }

    public int getPurifiedHarvests() {
        return this.purifiedHarvests;
    }

    public void setCompost(int compost) {
        if (compost < 0) {
            compost = 0;
        }
        boolean wasComposted = this.isComposted();
        this.compost = compost;
        if (wasComposted != this.isComposted()) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!this.isFullyDecayed()) {
                this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a((IProperty)BlockGenericDugSoil.DECAYED, (Comparable)Boolean.valueOf(this.isFullyDecayed())).func_177226_a((IProperty)BlockGenericDugSoil.COMPOSTED, (Comparable)Boolean.valueOf(this.isComposted())), 3);
            } else {
                this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a((IProperty)BlockGenericDugSoil.DECAYED, (Comparable)Boolean.valueOf(this.isFullyDecayed())).func_177226_a((IProperty)BlockGenericDugSoil.COMPOSTED, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        this.func_70296_d();
    }

    public int getCompost() {
        return this.compost;
    }

    public boolean isComposted() {
        return this.compost > 0;
    }

    public void setDecay(int decay) {
        if (decay < 0) {
            decay = 0;
        }
        boolean wasDecayed = this.isFullyDecayed();
        this.decay = Math.min(20, decay);
        if (wasDecayed != this.isFullyDecayed()) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            blockState = this.isFullyDecayed() ? blockState.func_177226_a((IProperty)BlockGenericDugSoil.DECAYED, (Comparable)Boolean.valueOf(this.isFullyDecayed())).func_177226_a((IProperty)BlockGenericDugSoil.COMPOSTED, (Comparable)Boolean.valueOf(false)) : blockState.func_177226_a((IProperty)BlockGenericDugSoil.DECAYED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockGenericDugSoil.COMPOSTED, (Comparable)Boolean.valueOf(this.isComposted()));
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState, 3);
            IBlockState blockUp = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
            if (blockUp.func_177230_c() instanceof BlockGenericCrop) {
                IBlockState cropBlockState;
                BlockPos pos = this.field_174879_c.func_177984_a();
                for (int i = 0; i < ((BlockGenericCrop)blockUp.func_177230_c()).getMaxHeight() && (cropBlockState = this.field_145850_b.func_180495_p(pos)).func_177230_c() instanceof BlockGenericCrop; ++i) {
                    if (this.isFullyDecayed()) {
                        this.field_145850_b.func_180501_a(pos, cropBlockState.func_177226_a((IProperty)BlockGenericCrop.DECAYED, (Comparable)Boolean.valueOf(true)), 3);
                    } else {
                        this.field_145850_b.func_180501_a(pos, cropBlockState.func_177226_a((IProperty)BlockGenericCrop.DECAYED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    pos = pos.func_177984_a();
                }
            }
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        this.func_70296_d();
    }

    public int getDecay() {
        return this.decay;
    }

    public boolean isFullyDecayed() {
        return this.decay >= 20;
    }
}

