/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thebetweenlands.common.item.EnumBLDrinkableBrew;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.registries.BlockRegistry;

public class FluidRegistry {
    public static final FluidMultipleBlocks SWAMP_WATER = (FluidMultipleBlocks)new FluidMultipleBlocks("swamp_water", new ResourceLocation("thebetweenlands:fluids/swamp_water_still"), new ResourceLocation("thebetweenlands:fluids/swamp_water_flowing")).setDensity(1000).setViscosity(1000);
    public static final Fluid STAGNANT_WATER = new Fluid("stagnant_water", new ResourceLocation("thebetweenlands:fluids/stagnant_water_still"), new ResourceLocation("thebetweenlands:fluids/stagnant_water_flowing")).setDensity(1000).setViscosity(1000);
    public static final Fluid TAR = new Fluid("tar", new ResourceLocation("thebetweenlands:fluids/tar_still"), new ResourceLocation("thebetweenlands:fluids/tar_flowing")).setDensity(2000).setViscosity(2000).setTemperature(330);
    public static final Fluid RUBBER = new Fluid("rubber", new ResourceLocation("thebetweenlands:fluids/rubber_still"), new ResourceLocation("thebetweenlands:fluids/rubber_flowing")).setDensity(1200).setViscosity(1500);
    public static final Fluid FOG = new Fluid("fog", new ResourceLocation("thebetweenlands:fluids/fog"), new ResourceLocation("thebetweenlands:fluids/fog")).setDensity(2).setViscosity(10).setGaseous(true);
    public static final Fluid SHALLOWBREATH = new Fluid("shallowbreath", new ResourceLocation("thebetweenlands:fluids/shallowbreath"), new ResourceLocation("thebetweenlands:fluids/shallowbreath")).setDensity(2).setViscosity(10).setGaseous(true);
    public static final Fluid DYE_FLUID = new Fluid("dye_fluid", new ResourceLocation("thebetweenlands:fluids/dye_fluid_still"), new ResourceLocation("thebetweenlands:fluids/dye_fluid_flowing")){

        public int getColor(FluidStack stack) {
            if (stack.tag != null && stack.tag.func_74764_b("type")) {
                return EnumBLDyeColor.byMetadata(stack.tag.func_74762_e("type")).getColorValue() | 0xFF000000;
            }
            return -1;
        }

        public String getUnlocalizedName(FluidStack stack) {
            if (stack.tag != null && stack.tag.func_74764_b("type")) {
                String type = "dye_fluid." + EnumBLDyeColor.byMetadata(stack.tag.func_74762_e("type")).getDyeColorName();
                this.setUnlocalizedName(type);
                return this.getUnlocalizedName() + type;
            }
            return this.getUnlocalizedName();
        }

        public String getLocalizedName(FluidStack stack) {
            if (stack.tag != null && stack.tag.func_74764_b("type")) {
                String type = "dye_fluid." + EnumBLDyeColor.byMetadata(stack.tag.func_74762_e("type")).getDyeColorName();
                this.setUnlocalizedName(type);
                return I18n.func_74838_a((String)this.getUnlocalizedName());
            }
            return this.getUnlocalizedName();
        }
    }.setDensity(1000).setViscosity(1000);
    public static final Fluid DRINKABLE_BREW = new Fluid("drinkable_brew", new ResourceLocation("thebetweenlands:fluids/drinkable_brew_still"), new ResourceLocation("thebetweenlands:fluids/drinkable_brew_flowing")){

        public int getColor(FluidStack stack) {
            if (stack.tag != null && stack.tag.func_74764_b("type")) {
                return EnumBLDrinkableBrew.byMetadata(stack.tag.func_74762_e("type")).getColorValue() | 0xFF000000;
            }
            return -1;
        }

        public String getUnlocalizedName(FluidStack stack) {
            if (stack.tag != null && stack.tag.func_74764_b("type")) {
                String type = "drinkable_brew." + EnumBLDrinkableBrew.byMetadata(stack.tag.func_74762_e("type")).getBrewName();
                this.setUnlocalizedName(type);
                return this.getUnlocalizedName() + type;
            }
            return this.getUnlocalizedName();
        }

        public String getLocalizedName(FluidStack stack) {
            if (stack.tag != null && stack.tag.func_74764_b("type")) {
                String type = "drinkable_brew." + EnumBLDrinkableBrew.byMetadata(stack.tag.func_74762_e("type")).getBrewName();
                this.setUnlocalizedName(type);
                return I18n.func_74838_a((String)this.getUnlocalizedName());
            }
            return this.getUnlocalizedName();
        }
    }.setDensity(1000).setViscosity(1000);
    public static final Fluid CLEAN_WATER = new Fluid("clean_water", new ResourceLocation("thebetweenlands:fluids/clean_water_still"), new ResourceLocation("thebetweenlands:fluids/clean_water_flowing")).setDensity(1000).setViscosity(1000);
    public static final Fluid FISH_OIL = new Fluid("fish_oil", new ResourceLocation("thebetweenlands:fluids/fish_oil_still"), new ResourceLocation("thebetweenlands:fluids/fish_oil_flowing")).setDensity(1000).setViscosity(1000);
    public static final List<Fluid> REGISTERED_FLUIDS = new ArrayList<Fluid>();

    private FluidRegistry() {
    }

    public static void preInit() {
        try {
            for (Field f : FluidRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Fluid)) continue;
                Fluid fluid = (Fluid)obj;
                net.minecraftforge.fluids.FluidRegistry.registerFluid((Fluid)fluid);
                if (fluid != FOG && fluid != SHALLOWBREATH) {
                    net.minecraftforge.fluids.FluidRegistry.addBucketForFluid((Fluid)fluid);
                }
                REGISTERED_FLUIDS.add((Fluid)obj);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void init() {
        SWAMP_WATER.setOriginalBlock(BlockRegistry.SWAMP_WATER);
    }

    public static class FluidMultipleBlocks
    extends Fluid {
        public FluidMultipleBlocks(String fluidName, ResourceLocation still, ResourceLocation flowing) {
            super(fluidName, still, flowing);
        }

        public Fluid setBlock(Block block) {
            return this;
        }

        public Fluid setOriginalBlock(Block block) {
            this.block = block;
            return this;
        }
    }
}

