/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import com.google.common.base.Throwables;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.api.recipes.ICrabPotFilterRecipeBubbler;
import thebetweenlands.api.recipes.ICrabPotFilterRecipeSilt;
import thebetweenlands.api.recipes.IDruidAltarRecipe;
import thebetweenlands.api.recipes.IPestleAndMortarRecipe;
import thebetweenlands.api.recipes.IPurifierRecipe;
import thebetweenlands.api.recipes.ISmokingRackRecipe;
import thebetweenlands.api.recipes.ISteepingPotRecipe;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.recipe.custom.CustomAnimatorRecipes;
import thebetweenlands.common.recipe.custom.CustomAnimatorRepairableRecipes;
import thebetweenlands.common.recipe.custom.CustomCompostBinRecipes;
import thebetweenlands.common.recipe.custom.CustomCrabPotFilterRecipesBubbler;
import thebetweenlands.common.recipe.custom.CustomCrabPotFilterRecipesSilt;
import thebetweenlands.common.recipe.custom.CustomDruidAltarRecipes;
import thebetweenlands.common.recipe.custom.CustomPestleAndMortarRecipes;
import thebetweenlands.common.recipe.custom.CustomPurifierRecipes;
import thebetweenlands.common.recipe.custom.CustomRecipes;
import thebetweenlands.common.recipe.custom.CustomSmokingRackRecipes;
import thebetweenlands.common.recipe.custom.CustomSteepingPotRecipes;

public class CustomRecipeRegistry {
    private static final List<CustomRecipes<?>> RECIPE_TYPES = new ArrayList();
    public static CustomRecipes<IAnimatorRecipe> animatorRecipes;
    public static CustomRecipes<IAnimatorRecipe> animatorRepairableRecipes;
    public static CustomRecipes<IPurifierRecipe> purifiedRecipes;
    public static CustomRecipes<ICompostBinRecipe> compostBinRecipes;
    public static CustomRecipes<IDruidAltarRecipe> druidAltarRecipes;
    public static CustomRecipes<IPestleAndMortarRecipe> pestleAndMortarRecipes;
    public static CustomRecipes<ISmokingRackRecipe> smokingRackRecipes;
    public static CustomRecipes<ICrabPotFilterRecipeSilt> crabPotFilterRecipesSilt;
    public static CustomRecipes<ICrabPotFilterRecipeBubbler> crabPotFilterRecipesBubbler;
    public static CustomRecipes<ISteepingPotRecipe> steepingPot;

    private CustomRecipeRegistry() {
    }

    public static void preInit() {
        animatorRecipes = new CustomAnimatorRecipes();
        RECIPE_TYPES.add(animatorRecipes);
        animatorRepairableRecipes = new CustomAnimatorRepairableRecipes();
        RECIPE_TYPES.add(animatorRepairableRecipes);
        purifiedRecipes = new CustomPurifierRecipes();
        RECIPE_TYPES.add(purifiedRecipes);
        compostBinRecipes = new CustomCompostBinRecipes();
        RECIPE_TYPES.add(compostBinRecipes);
        druidAltarRecipes = new CustomDruidAltarRecipes();
        RECIPE_TYPES.add(druidAltarRecipes);
        pestleAndMortarRecipes = new CustomPestleAndMortarRecipes();
        RECIPE_TYPES.add(pestleAndMortarRecipes);
        smokingRackRecipes = new CustomSmokingRackRecipes();
        RECIPE_TYPES.add(smokingRackRecipes);
        crabPotFilterRecipesSilt = new CustomCrabPotFilterRecipesSilt();
        RECIPE_TYPES.add(crabPotFilterRecipesSilt);
        crabPotFilterRecipesBubbler = new CustomCrabPotFilterRecipesBubbler();
        RECIPE_TYPES.add(crabPotFilterRecipesBubbler);
        steepingPot = new CustomSteepingPotRecipes();
        RECIPE_TYPES.add(steepingPot);
    }

    public static boolean loadCustomRecipes() {
        CustomRecipeRegistry.unregisterCustomRecipes();
        for (CustomRecipes<?> recipe : RECIPE_TYPES) {
            recipe.clear();
        }
        File customRecipesFile = new File(BetweenlandsConfig.configDir, "recipes.json");
        boolean noError = true;
        if (customRecipesFile.exists()) {
            try (JsonReader jsonReader = new JsonReader((Reader)new FileReader(customRecipesFile));){
                JsonObject jsonObj = new JsonParser().parse(jsonReader).getAsJsonObject();
                for (CustomRecipes<?> recipes : RECIPE_TYPES) {
                    if (!jsonObj.has(recipes.getName())) continue;
                    try {
                        JsonArray arr = jsonObj.get(recipes.getName()).getAsJsonArray();
                        recipes.parse(arr);
                    }
                    catch (CustomRecipes.InvalidRecipeException ex) {
                        TheBetweenlands.logger.throwing((Throwable)ex);
                        noError = false;
                    }
                }
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        CustomRecipeRegistry.registerCustomRecipes();
        return noError;
    }

    public static void registerCustomRecipes() {
        for (CustomRecipes<?> recipes : RECIPE_TYPES) {
            recipes.registerRecipes();
        }
    }

    public static void unregisterCustomRecipes() {
        for (CustomRecipes<?> recipes : RECIPE_TYPES) {
            recipes.unregisterRecipes();
        }
    }
}

