/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.item.misc.ItemMobAnadia;
import thebetweenlands.common.registries.ItemRegistry;

public class LootFunctionSetAnadiaProperties
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Optional<Boolean> randomize;
    private final Optional<RandomValueRange> fishColour;
    private final Optional<RandomValueRange> fishSize;
    private final Optional<LootEntry> headItem;
    private final Optional<LootEntry> bodyItem;
    private final Optional<LootEntry> tailItem;
    private final Optional<RandomValueRange> headType;
    private final Optional<RandomValueRange> bodyType;
    private final Optional<RandomValueRange> tailType;
    private final Optional<Boolean> lootFish;
    private final Optional<Boolean> rotten;

    public LootFunctionSetAnadiaProperties(LootCondition[] conditionsIn, Optional<Boolean> randomize, Optional<RandomValueRange> fishColour, Optional<RandomValueRange> fishSize, Optional<LootEntry> headItem, Optional<LootEntry> bodyItem, Optional<LootEntry> tailItem, Optional<RandomValueRange> headType, Optional<RandomValueRange> bodyType, Optional<RandomValueRange> tailType, Optional<Boolean> lootFish, Optional<Boolean> rotten) {
        super(conditionsIn);
        this.randomize = randomize;
        this.fishColour = fishColour;
        this.fishSize = fishSize;
        this.headItem = headItem;
        this.bodyItem = bodyItem;
        this.tailItem = tailItem;
        this.headType = headType;
        this.bodyType = bodyType;
        this.tailType = tailType;
        this.lootFish = lootFish;
        this.rotten = rotten;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (stack.func_77973_b() != ItemRegistry.ANADIA) {
            LOGGER.warn("Loot item {} is not an anadia item stack", (Object)stack);
        } else {
            Entity entity = ((ItemMobAnadia)stack.func_77973_b()).createCapturedEntity((World)context.getWorld(), 0.0, 0.0, 0.0, stack, false);
            if (!(entity instanceof EntityAnadia)) {
                LOGGER.warn("Loot item {} contains a {} and not an anadia entity", (Object)stack, (Object)entity.getClass().getName());
            } else {
                ItemStack partStack;
                EntityAnadia anadia = (EntityAnadia)entity;
                if (this.randomize.orElse(false).booleanValue()) {
                    anadia.randomizeAnadiaProperties();
                }
                if (this.fishColour.isPresent()) {
                    anadia.setFishColour(EntityAnadia.EnumAnadiaColor.get(this.fishColour.get().func_186511_a(rand)));
                }
                if (this.fishSize.isPresent()) {
                    anadia.setFishSize(this.fishSize.get().func_186507_b(rand));
                }
                if (this.lootFish.isPresent()) {
                    anadia.setAsLootFish(this.lootFish.get());
                }
                if (this.headType.isPresent()) {
                    anadia.setHeadType(EntityAnadia.EnumAnadiaHeadParts.get(this.headType.get().func_186511_a(rand)));
                }
                if (this.bodyType.isPresent()) {
                    anadia.setBodyType(EntityAnadia.EnumAnadiaBodyParts.get(this.bodyType.get().func_186511_a(rand)));
                }
                if (this.tailType.isPresent()) {
                    anadia.setTailType(EntityAnadia.EnumAnadiaTailParts.get(this.tailType.get().func_186511_a(rand)));
                }
                if (this.headItem.isPresent()) {
                    partStack = this.getItem(anadia, this.headItem.get(), rand, context);
                    if (!partStack.func_190926_b()) {
                        anadia.setHeadItem(partStack);
                    } else {
                        LOGGER.warn("Head item generated by loot entry {} is empty", (Object)this.headItem.get().getEntryName());
                    }
                }
                if (this.bodyItem.isPresent()) {
                    partStack = this.getItem(anadia, this.bodyItem.get(), rand, context);
                    if (!partStack.func_190926_b()) {
                        anadia.setBodyItem(partStack);
                    } else {
                        LOGGER.warn("Body item generated by loot entry {} is empty", (Object)this.bodyItem.get().getEntryName());
                    }
                }
                if (this.tailItem.isPresent()) {
                    partStack = this.getItem(anadia, this.tailItem.get(), rand, context);
                    if (!partStack.func_190926_b()) {
                        anadia.setTailItem(partStack);
                    } else {
                        LOGGER.warn("Tail item generated by loot entry {} is empty", (Object)this.tailItem.get().getEntryName());
                    }
                }
                stack = ItemRegistry.ANADIA.capture((Entity)anadia);
                ((ItemMobAnadia)stack.func_77973_b()).setRotten((World)context.getWorld(), stack, this.rotten.orElse(false));
            }
        }
        return stack;
    }

    private ItemStack getItem(EntityAnadia anadia, LootEntry entry, Random rand, LootContext context) {
        LootContext.Builder lootBuilder = new LootContext.Builder(context.getWorld()).func_186472_a((Entity)anadia);
        ArrayList loot = new ArrayList();
        entry.func_186363_a(loot, rand, lootBuilder.func_186471_a());
        if (!loot.isEmpty()) {
            return (ItemStack)loot.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public static class Serializer
    extends LootFunction.Serializer<LootFunctionSetAnadiaProperties> {
        public Serializer() {
            super(new ResourceLocation("thebetweenlands", "set_anadia_properties"), LootFunctionSetAnadiaProperties.class);
        }

        public void serialize(JsonObject object, LootFunctionSetAnadiaProperties functionClazz, JsonSerializationContext context) {
        }

        public LootFunctionSetAnadiaProperties deserialize(JsonObject object, JsonDeserializationContext context, LootCondition[] conditionsIn) {
            return new LootFunctionSetAnadiaProperties(conditionsIn, Optional.ofNullable(object.has("randomize") ? Boolean.valueOf(JsonUtils.func_151216_b((JsonElement)object.get("randomize"), (String)"randomize")) : null), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"fish_color", null, (JsonDeserializationContext)context, RandomValueRange.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"fish_size", null, (JsonDeserializationContext)context, RandomValueRange.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"head_item", null, (JsonDeserializationContext)context, LootEntry.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"body_item", null, (JsonDeserializationContext)context, LootEntry.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"tail_item", null, (JsonDeserializationContext)context, LootEntry.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"head_type", null, (JsonDeserializationContext)context, RandomValueRange.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"body_type", null, (JsonDeserializationContext)context, RandomValueRange.class)), Optional.ofNullable(JsonUtils.func_188177_a((JsonObject)object, (String)"tail_type", null, (JsonDeserializationContext)context, RandomValueRange.class)), Optional.ofNullable(object.has("loot_fish") ? Boolean.valueOf(JsonUtils.func_151216_b((JsonElement)object.get("loot_fish"), (String)"loot_fish")) : null), Optional.ofNullable(object.has("rotten") ? Boolean.valueOf(JsonUtils.func_151216_b((JsonElement)object.get("rotten"), (String)"rotten")) : null));
        }
    }
}

