/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.CorrosionHelper;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.EntityFishBait;
import thebetweenlands.common.entity.projectiles.EntityBetweenstonePebble;
import thebetweenlands.common.item.BLMaterialRegistry;
import thebetweenlands.common.item.misc.ItemFishBait;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class ItemSimpleSlingshot
extends Item
implements ICorrodible,
IAnimatorRepairable {
    public ItemSimpleSlingshot() {
        this.field_77777_bU = 1;
        this.func_77656_e(64);
        this.func_77637_a(BLCreativeTabs.GEARS);
        CorrosionHelper.addCorrosionPropertyOverrides(this);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return entityIn.func_184607_cu().func_77973_b() != ItemRegistry.SIMPLE_SLINGSHOT ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    protected ItemStack findAmmo(EntityPlayer player) {
        if (this.isSlingShotAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isSlingShotAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!this.isSlingShotAmmo(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isSlingShotAmmo(ItemStack stack) {
        return !stack.func_190926_b() && (ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.isItemOf(stack) || stack.func_77973_b() == ItemRegistry.FISH_BAIT);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean infinite = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammo = this.findAmmo(player);
            int usedTicks = this.func_77626_a(stack) - timeLeft;
            if ((usedTicks = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)usedTicks, (!ammo.func_190926_b() || infinite ? 1 : 0) != 0)) < 0) {
                return;
            }
            if ((!ammo.func_190926_b() || infinite) && ammo.func_190926_b()) {
                ammo = new ItemStack(ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.getItem());
            }
            float strength = ItemSimpleSlingshot.getAmmoVelocity(usedTicks);
            if ((strength *= CorrosionHelper.getModifier(stack)) >= 0.1f) {
                if (!world.field_72995_K) {
                    Item itemAmmo;
                    if (ammo.func_77973_b() == ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.getItem()) {
                        int k;
                        int j;
                        itemAmmo = (ItemMisc)ammo.func_77973_b();
                        EntityBetweenstonePebble pebble = this.createPebbleAmmo(world, ammo, (EntityLivingBase)player);
                        pebble.shoot((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, strength * 3.0f, 1.0f);
                        if (strength == 1.0f) {
                            pebble.setIsCritical(true);
                        }
                        if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            pebble.setDamage(pebble.getDamage() + (double)j * 0.5 + 0.5);
                        }
                        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            pebble.setKnockbackStrength(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            pebble.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        this.fireAmmo(player, stack, pebble, strength);
                    }
                    if (ammo.func_77973_b() == ItemRegistry.FISH_BAIT) {
                        itemAmmo = (ItemFishBait)ammo.func_77973_b();
                        EntityFishBait bait = (EntityFishBait)itemAmmo.createEntity(world, (Entity)player, ammo.func_77946_l());
                        bait.func_174871_r();
                        ammo.func_77972_a(1, (EntityLivingBase)player);
                        bait.shoot((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, strength * 3.0f, 1.0f);
                        this.fireBaitAmmo(player, stack, bait, strength);
                    }
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.SLINGSHOT_SHOOT, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + strength * 0.5f);
                if (!infinite && ammo.func_77973_b() == ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.getItem()) {
                    ammo.func_190918_g(1);
                }
                if (ammo.func_190916_E() == 0) {
                    player.field_71071_by.func_184437_d(ammo);
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    public EntityBetweenstonePebble createPebbleAmmo(World world, ItemStack stack, EntityLivingBase shooter) {
        EntityBetweenstonePebble pebble = new EntityBetweenstonePebble(world, shooter);
        return pebble;
    }

    protected void fireAmmo(EntityPlayer player, ItemStack stack, EntityBetweenstonePebble ammo, float strength) {
        player.field_70170_p.func_72838_d((Entity)ammo);
    }

    protected void fireBaitAmmo(EntityPlayer player, ItemStack stack, EntityFishBait ammo, float strength) {
        player.field_70170_p.func_72838_d((Entity)ammo);
    }

    public static float getAmmoVelocity(int charge) {
        float strength = (float)charge / 20.0f;
        if ((strength = (strength * strength + strength * 2.0f) / 3.0f * 1.15f) > 1.0f) {
            strength = 1.0f;
        }
        return strength;
    }

    public int func_77626_a(ItemStack stack) {
        return 100000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = playerIn.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)(flag = !this.findAmmo(playerIn).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return CorrosionHelper.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return CorrosionHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return CorrosionHelper.getDestroySpeed(super.func_150893_a(stack, state), stack, state);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrosionHelper.updateCorrosion(itemStack, world, holder, slot, isHeldItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.bl.simple_slingshot", new Object[0]).func_150254_d());
        CorrosionHelper.addCorrosionTooltips(stack, tooltip, flagIn.func_194127_a());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onUpdateFov(FOVUpdateEvent event) {
        ItemStack activeItem = event.getEntity().func_184607_cu();
        if (!activeItem.func_190926_b() && activeItem.func_77973_b() instanceof ItemSimpleSlingshot) {
            int usedTicks = activeItem.func_77973_b().func_77626_a(activeItem) - event.getEntity().func_184605_cv();
            float strength = (float)usedTicks / 20.0f;
            if ((strength = (strength * strength + strength * 2.0f) / 3.0f * 1.15f) > 1.0f) {
                strength = 1.0f;
            }
            event.setNewfov(1.0f - strength * 0.25f);
        }
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(BLMaterialRegistry.TOOL_WEEDWOOD);
    }
}

