/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.projectiles.EntityBLFishHook;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.NBTHelper;
import thebetweenlands.util.TranslationHelper;

public class ItemBLFishingRod
extends Item {
    private static final ImmutableList<String> STACK_NBT_EXCLUSIONS = ImmutableList.of((Object)"baited");
    private static Field f_ItemRenderer_equippedProgressMainHand;
    private static Field f_ItemRenderer_prevEquippedProgressMainHand;
    private static Field f_ItemRenderer_equippedProgressOffHand;
    private static Field f_ItemRenderer_prevEquippedProgressOffHand;

    public ItemBLFishingRod() {
        this.func_77656_e(256);
        this.func_77625_d(1);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.func_185043_a(new ResourceLocation("cast"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                boolean offHand;
                if (entityIn == null) {
                    return 0.0f;
                }
                boolean mainHand = entityIn.func_184614_ca() == stack;
                boolean bl = offHand = entityIn.func_184592_cb() == stack;
                if (entityIn.func_184614_ca().func_77973_b() instanceof ItemBLFishingRod) {
                    offHand = false;
                }
                return (mainHand || offHand) && entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).field_71104_cf != null && ((EntityPlayer)entityIn).field_71104_cf instanceof EntityBLFishHook ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77952_i() == stack.func_77958_k()) {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.tool.broken_rod", (Object[])new Object[]{stack.func_82833_r()}), 0));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("baited")) {
            tooltip.add(TranslationHelper.translateToLocal("tooltip.bl.fishing_rod.baited", stack.func_77978_p().func_74767_n("baited")));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
            if (!nbt.func_74764_b("baited") || stack.func_77952_i() == this.getMaxDamage(stack)) {
                nbt.func_74757_a("baited", false);
            }
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityIn;
                if (player.func_184614_ca() == stack) {
                    if (!nbt.func_74767_n("bl.fishing_rod.equipped") && player.func_184592_cb().func_190926_b()) {
                        nbt.func_74768_a("bl.fishing_rod.equipped_slot", -1);
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack invStack = player.field_71071_by.func_70301_a(i);
                            if (invStack.func_190926_b() || invStack.func_77973_b() != ItemRegistry.NET) continue;
                            player.func_184611_a(EnumHand.OFF_HAND, invStack);
                            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                            nbt.func_74768_a("bl.fishing_rod.equipped_slot", i);
                            break;
                        }
                    }
                    nbt.func_74757_a("bl.fishing_rod.equipped", true);
                } else if (nbt.func_74767_n("bl.fishing_rod.equipped")) {
                    int equippedSlot = nbt.func_74762_e("bl.fishing_rod.equipped_slot");
                    if (equippedSlot >= 0 && equippedSlot < player.field_71071_by.func_70302_i_() && !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == ItemRegistry.NET) {
                        if (player.field_71071_by.func_70301_a(equippedSlot).func_190926_b()) {
                            player.field_71071_by.func_70299_a(equippedSlot, player.func_184592_cb());
                            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                        } else {
                            ItemStack net = player.func_184592_cb();
                            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                            if (!player.field_71071_by.func_70441_a(net)) {
                                player.func_184611_a(EnumHand.OFF_HAND, net);
                            }
                        }
                    }
                    nbt.func_74757_a("bl.fishing_rod.equipped", false);
                    nbt.func_74768_a("bl.fishing_rod.equipped_slot", -1);
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77952_i() == this.getMaxDamage(stack)) {
            if (!world.field_72995_K && player.field_71104_cf != null) {
                player.field_71104_cf.func_70106_y();
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.AMBIENT, 1.0f, 1.0f);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("baited")) {
                stack.func_77978_p().func_74757_a("baited", false);
            }
        }
        if (player.field_71104_cf != null) {
            int i = player.field_71104_cf.func_146034_e();
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.BL_FISHING_REEL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!world.field_72995_K && player.field_71104_cf != null) {
                if (player.field_71104_cf.field_146043_c != null && !player.field_71104_cf.func_184218_aH()) {
                    player.field_71104_cf.field_146043_c = null;
                }
                if (player.field_71104_cf.field_146043_c != null && stack.func_77978_p().func_74764_b("baited")) {
                    if (stack.func_77978_p().func_74767_n("baited")) {
                        stack.func_77978_p().func_74757_a("baited", false);
                    }
                    if (((EntityAnadia)player.field_71104_cf.field_146043_c).getStaminaTicks() % 20 == 0 && ((EntityAnadia)player.field_71104_cf.field_146043_c).getStaminaTicks() != 0) {
                        stack.func_77972_a(i, (EntityLivingBase)player);
                        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.BL_FISHING_ROD_CREAK, SoundCategory.NEUTRAL, 0.2f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    }
                }
                if (player.field_71104_cf.field_146043_c == null && (int)player.field_71104_cf.func_70032_d((Entity)player.field_71104_cf.func_190619_l()) > 0) {
                    stack.func_77972_a(i, (EntityLivingBase)player);
                }
                if ((int)player.field_71104_cf.func_70032_d((Entity)player.field_71104_cf.func_190619_l()) <= 0 && !player.field_71104_cf.func_184218_aH()) {
                    player.field_71104_cf.func_70106_y();
                }
            }
        } else {
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundRegistry.BL_FISHING_CAST, SoundCategory.NEUTRAL, 0.2f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K && player.field_71104_cf == null) {
                EntityBLFishHook entityFishHook = new EntityBLFishHook(world, player);
                if (stack.func_77978_p().func_74767_n("baited")) {
                    entityFishHook.setBaited(true);
                }
                world.func_72838_d((Entity)entityFishHook);
            }
            player.func_184609_a(handIn);
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        ItemStack otherStack = handIn == EnumHand.MAIN_HAND ? player.func_184592_cb() : player.func_184614_ca();
        if (!otherStack.func_190926_b() && otherStack.func_77973_b() == ItemRegistry.NET) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = stack.func_77958_k();
        if (damage > maxDamage) {
            damage = maxDamage;
        }
        super.setDamage(stack, damage);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && !NBTHelper.areItemStackTagsEqual(oldStack, newStack, STACK_NBT_EXCLUSIONS);
    }

    public int func_77619_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71104_cf != null) {
            ItemRenderer itemRenderer = Minecraft.func_71410_x().field_71460_t.field_78516_c;
            try {
                ItemStack stackOffhand;
                ItemStack stackMainhand;
                if (f_ItemRenderer_equippedProgressMainHand == null) {
                    f_ItemRenderer_equippedProgressMainHand = ReflectionHelper.findField(ItemRenderer.class, (String[])new String[]{"equippedProgressMainHand", "field_187469_f", "f"});
                    f_ItemRenderer_prevEquippedProgressMainHand = ReflectionHelper.findField(ItemRenderer.class, (String[])new String[]{"prevEquippedProgressMainHand", "field_187470_g", "g"});
                    f_ItemRenderer_equippedProgressOffHand = ReflectionHelper.findField(ItemRenderer.class, (String[])new String[]{"equippedProgressOffHand", "field_187471_h", "h"});
                    f_ItemRenderer_prevEquippedProgressOffHand = ReflectionHelper.findField(ItemRenderer.class, (String[])new String[]{"prevEquippedProgressOffHand", "field_187472_i", "i"});
                }
                if (!(stackMainhand = player.func_184614_ca()).func_190926_b() && stackMainhand.func_77973_b() instanceof ItemBLFishingRod) {
                    f_ItemRenderer_equippedProgressMainHand.set(itemRenderer, Float.valueOf(1.0f));
                    f_ItemRenderer_prevEquippedProgressMainHand.set(itemRenderer, Float.valueOf(1.0f));
                }
                if (!(stackOffhand = player.func_184592_cb()).func_190926_b() && stackOffhand.func_77973_b() instanceof ItemBLFishingRod) {
                    f_ItemRenderer_equippedProgressOffHand.set(itemRenderer, Float.valueOf(1.0f));
                    f_ItemRenderer_prevEquippedProgressOffHand.set(itemRenderer, Float.valueOf(1.0f));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

