/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.projectiles.EntityGlowingGoop;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;
import thebetweenlands.common.registries.BlockRegistry;

public class ItemGlowingGoop
extends ItemBlock {
    public ItemGlowingGoop() {
        super(BlockRegistry.GLOWING_GOOP);
        this.func_77637_a(BLCreativeTabs.ITEMS);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.bl.item.glowing_goop", (Object[])new Object[0]));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!this.canUse(playerIn.func_184586_b(handIn))) {
            return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player instanceof EntityPlayer && this.canUse(stack)) {
            Vec3d forward = player.func_70040_Z();
            float yaw = player.field_70177_z;
            float pitch = player.field_70125_A - 90.0f;
            float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
            float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
            Vec3d up = new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
            Vec3d right = forward.func_72431_c(up).func_72432_b();
            Vec3d source = player.func_174791_d().func_72441_c(0.0, (double)(player.func_70047_e() - 0.2f), 0.0).func_178787_e(forward.func_186678_a((double)0.4f)).func_178787_e(right.func_186678_a((double)0.3f));
            player.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, source.field_72450_a + (double)(player.field_70170_p.field_73012_v.nextFloat() * 0.5f) - 0.25, source.field_72448_b + (double)(player.field_70170_p.field_73012_v.nextFloat() * 0.5f) - 0.25, source.field_72449_c + (double)(player.field_70170_p.field_73012_v.nextFloat() * 0.5f) - 0.25, 0.0, 0.0, 0.0, new int[0]);
        }
        super.onUsingTick(stack, player, count);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        int useTime;
        if (!this.canUse(stack)) {
            return;
        }
        if (!world.field_72995_K && entityLiving instanceof EntityPlayer && (useTime = this.func_77626_a(stack) - timeLeft) > 20) {
            EntityGlowingGoop goop = new EntityGlowingGoop(world, entityLiving);
            goop.func_184538_a((Entity)entityLiving, entityLiving.field_70125_A, entityLiving.field_70177_z, -10.0f, 1.2f, 3.5f);
            world.func_72838_d((Entity)goop);
            world.func_184133_a(null, entityLiving.func_180425_c(), SoundEvents.field_187882_fq, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            if (!((EntityPlayer)entityLiving).func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!this.canUse(stack)) {
            return false;
        }
        Block block = this.field_150939_a;
        if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
            block = BlockRegistry.GLOWING_GOOP_UNDERWATER;
            newState = block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player, EnumHand.MAIN_HAND);
        }
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == block) {
            ItemGlowingGoop.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    private boolean canUse(ItemStack stack) {
        return ItemAmphibiousArmor.getUpgradeItemStoredDamage(stack) == 0;
    }
}

