/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.entity.EntityBLItemFrame;
import thebetweenlands.common.item.EnumBLDyeColor;
import thebetweenlands.common.item.ITintedItem;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemBLItemFrame
extends Item
implements ItemRegistry.IMultipleItemModelDefinition,
ITintedItem {
    public ItemBLItemFrame() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(BLCreativeTabs.ITEMS);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        BlockPos blockpos = pos.func_177972_a(facing);
        if (playerIn.func_175151_a(blockpos, facing, stack)) {
            EntityHanging entityhanging = this.createEntity(worldIn, blockpos, facing, stack.func_77952_i());
            if (entityhanging.func_70518_d()) {
                if (!worldIn.field_72995_K) {
                    entityhanging.func_184523_o();
                    worldIn.func_72838_d((Entity)entityhanging);
                }
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private EntityHanging createEntity(World worldIn, BlockPos pos, EnumFacing clickedSide, int color) {
        return new EntityBLItemFrame(worldIn, pos, clickedSide, color);
    }

    public String func_77667_c(ItemStack stack) {
        int i = stack.func_77960_j();
        return super.func_77658_a() + "." + EnumBLDyeColor.byMetadata(i).getTranslationKey();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            Stream.of(EnumBLDyeColor.values()).forEach(t -> list.add((Object)new ItemStack((Item)this, 1, t.getMetadata())));
        }
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (EnumBLDyeColor color : EnumBLDyeColor.values()) {
            models.put(color.getMetadata(), new ResourceLocation("thebetweenlands", "item_frame"));
        }
        return models;
    }

    @Override
    public int getColorMultiplier(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return EnumBLDyeColor.byMetadata(stack.func_77952_i()).getColorValue();
        }
        return -1;
    }
}

