/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.equipment.ItemAmulet;
import thebetweenlands.common.registries.CapabilityRegistry;

public class ItemAmuletSlot
extends Item {
    public ItemAmuletSlot() {
        this.func_77625_d(1);
        this.func_77656_e(30);
        this.func_77637_a(BLCreativeTabs.SPECIALS);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.field_185296_A;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185296_A);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
                ItemAmuletSlot.removeAmuletSlot((EntityLivingBase)player);
            } else {
                ItemAmuletSlot.addAmuletSlot(player, stack, (EntityLivingBase)player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && (ItemAmulet.canPlayerAddAmulet(player, (Entity)target) || player.field_71075_bZ.field_75098_d)) {
            if (player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
                ItemAmuletSlot.removeAmuletSlot(target);
            } else if (ItemAmuletSlot.addAmuletSlot(player, stack, target)) {
                player.func_184609_a(hand);
            }
        }
        return true;
    }

    public static boolean addAmuletSlot(EntityPlayer player, ItemStack stack, EntityLivingBase entity) {
        IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null) {
            if (cap.getAmuletSlots() < 3 || player.field_71075_bZ.field_75098_d) {
                cap.setAmuletSlots(cap.getAmuletSlots() + 1);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (entity instanceof EntityPlayer) {
                        stack.func_77972_a(5, (EntityLivingBase)player);
                    } else {
                        stack.func_77972_a(2, (EntityLivingBase)player);
                    }
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.amulet.slot.added", new Object[0]), true);
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.amulet.slot.full", new Object[0]), true);
        }
        return false;
    }

    public static void removeAmuletSlot(EntityLivingBase entity) {
        IEquipmentCapability cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
        if (cap != null && cap.getAmuletSlots() > 1) {
            cap.setAmuletSlots(cap.getAmuletSlots() - 1);
        }
    }
}

