/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;

public class ItemBlockEnum<T extends Enum<T>>
extends ItemBlock {
    private final T[] values;
    private final boolean hasGenericMetaSelector;
    private final char separator;
    private final String[] unlocalizedNames;

    public static <T extends Enum<T>> ItemBlockEnum<T> create(Block block, Class<T> cls) {
        return new ItemBlockEnum(block, (Enum[])cls.getEnumConstants(), '.', IGenericMetaSelector.class.isAssignableFrom(cls));
    }

    public static <T extends Enum<T>> ItemBlockEnum<T> create(Block block, Class<T> cls, char separator) {
        return new ItemBlockEnum(block, (Enum[])cls.getEnumConstants(), separator, IGenericMetaSelector.class.isAssignableFrom(cls));
    }

    protected ItemBlockEnum(Block block, T[] values, char separator, boolean hasGenericMetaSelector) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.values = values;
        this.separator = separator;
        this.hasGenericMetaSelector = hasGenericMetaSelector;
        this.unlocalizedNames = new String[values.length];
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        T match = null;
        if (this.hasGenericMetaSelector) {
            for (T type : this.values) {
                if (!((IGenericMetaSelector)type).isMetadataMatching(stack.func_77960_j())) continue;
                match = type;
                break;
            }
        }
        if (match == null) {
            if (stack.func_77960_j() >= this.values.length) {
                return "item.thebetweenlands.enum.unknown";
            }
            match = this.values[stack.func_77960_j()];
        }
        return this.getTranslationKey(match);
    }

    private String getTranslationKey(T value) {
        String name = this.unlocalizedNames[((Enum)value).ordinal()];
        if (name == null) {
            this.unlocalizedNames[((Enum)value).ordinal()] = name = super.func_77658_a() + this.separator + ((IStringSerializable)value).func_176610_l().toLowerCase(Locale.ENGLISH);
        }
        return name;
    }

    public static interface IGenericMetaSelector {
        public boolean isMetadataMatching(int var1);
    }
}

