/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.inventory.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import thebetweenlands.common.inventory.slot.SlotOutput;
import thebetweenlands.common.inventory.slot.SlotRestrictionListNoMeta;
import thebetweenlands.common.inventory.slot.SlotRestrictionNoMeta;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityFishTrimmingTable;

public class ContainerFishTrimmingTable
extends Container {
    private final EntityPlayer player;
    public List<ItemStack> acceptedItems = new ArrayList<ItemStack>();
    public ItemStack axe = new ItemStack(ItemRegistry.BONE_AXE);
    public TileEntityFishTrimmingTable trimmingTable;

    public ContainerFishTrimmingTable(EntityPlayer player, TileEntityFishTrimmingTable tile) {
        InventoryPlayer playerInventory = player.field_71071_by;
        this.player = player;
        this.trimmingTable = tile;
        this.acceptedItems.add(new ItemStack((Item)ItemRegistry.ANADIA));
        this.acceptedItems.add(new ItemStack((Item)ItemRegistry.SILT_CRAB));
        this.acceptedItems.add(new ItemStack((Item)ItemRegistry.BUBBLER_CRAB));
        this.func_75146_a(new SlotRestrictionListNoMeta((IInventory)this.trimmingTable, 0, 80, 27, this.getItemList(), 1, this));
        this.func_75146_a(new SlotTrimmingOutput((IInventory)this.trimmingTable, 1, 44, 77, this));
        this.func_75146_a(new SlotTrimmingOutput((IInventory)this.trimmingTable, 2, 80, 77, this));
        this.func_75146_a(new SlotTrimmingOutput((IInventory)this.trimmingTable, 3, 116, 77, this));
        this.func_75146_a(new SlotTrimmingOutput((IInventory)this.trimmingTable, 4, 8, 113, this));
        this.func_75146_a(new SlotRestrictionNoMeta((IInventory)this.trimmingTable, 5, 152, 113, this.axe, 1));
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 145 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 203));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            if (slotIndex > 5) {
                if ((stack1.func_77973_b() == ItemRegistry.ANADIA || stack1.func_77973_b() == ItemRegistry.SILT_CRAB || stack1.func_77973_b() == ItemRegistry.BUBBLER_CRAB) && ((ItemMob)stack1.func_77973_b()).hasEntityData(stack1) && !this.func_75135_a(stack1, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (stack1.func_77973_b() == ItemRegistry.BONE_AXE && !this.func_75135_a(stack1, 5, 6, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(stack1, 1, 5, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stack1, 6, this.field_75151_b.size(), false)) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack2 = slot.func_190901_a(player, stack1);
            if (slotIndex == 1 || slotIndex == 2 || slotIndex == 3 || slotIndex == 4) {
                player.func_71019_a(stack2, false);
            }
        }
        return stack;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        BlockPos pos = this.trimmingTable.func_174877_v();
        if (playerIn.field_70170_p.func_175625_s(pos) != this.trimmingTable) {
            return false;
        }
        return playerIn.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    public List<ItemStack> getItemList() {
        return this.acceptedItems;
    }

    public void chop(EntityPlayerMP player) {
        if ((this.trimmingTable.hasAnadia() || this.trimmingTable.hasSiltCrab() || this.trimmingTable.hasBubblerCrab()) && this.trimmingTable.hasChopper() && this.trimmingTable.allResultSlotsEmpty()) {
            int numItems = 0;
            for (int i = 1; i <= 4; ++i) {
                ItemStack result = this.trimmingTable.getSlotResult(i, numItems);
                numItems += result.func_190916_E();
                this.func_75139_a(i).func_75215_d(result);
            }
            this.trimmingTable.func_70301_a(5).func_77972_a(1, (EntityLivingBase)player);
            this.trimmingTable.func_70299_a(0, this.trimmingTable.getSlotResult(0, 0));
            this.func_75130_a((IInventory)this.trimmingTable);
            player.field_70170_p.func_184133_a(null, this.trimmingTable.func_174877_v(), (SoundEvent)SoundRegistry.FISH_CHOP, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private class SlotTrimmingOutput
    extends SlotOutput {
        private int prevCount;

        public SlotTrimmingOutput(IInventory inventoryIn, int index, int xPosition, int yPosition, Container container) {
            super(inventoryIn, index, xPosition, yPosition, container);
            this.updateCount();
        }

        private void updateCount() {
            this.prevCount = this.func_75211_c().func_190916_E();
        }

        public void func_75218_e() {
            int removed;
            int index;
            super.func_75218_e();
            if (!(ContainerFishTrimmingTable.this.trimmingTable.func_70301_a(4).func_190926_b() || (index = this.getSlotIndex()) != 1 && index != 2 && index != 3 || (removed = Math.max(0, this.prevCount - this.func_75211_c().func_190916_E())) <= 0)) {
                ContainerFishTrimmingTable.this.trimmingTable.func_70301_a(4).func_190918_g(removed);
                ContainerFishTrimmingTable.this.trimmingTable.func_70296_d();
                ContainerFishTrimmingTable.this.func_75130_a((IInventory)ContainerFishTrimmingTable.this.trimmingTable);
            }
            this.updateCount();
        }

        public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            if (thePlayer instanceof EntityPlayerMP) {
                AdvancementCriterionRegistry.TRIM_FISH.trigger((EntityPlayerMP)thePlayer);
            }
            if (this.getSlotIndex() == 4) {
                ContainerFishTrimmingTable.this.trimmingTable.func_70299_a(1, ItemStack.field_190927_a);
                ContainerFishTrimmingTable.this.trimmingTable.func_70299_a(2, ItemStack.field_190927_a);
                ContainerFishTrimmingTable.this.trimmingTable.func_70299_a(3, ItemStack.field_190927_a);
                ContainerFishTrimmingTable.this.func_75130_a((IInventory)ContainerFishTrimmingTable.this.trimmingTable);
            }
            return super.func_190901_a(thePlayer, stack);
        }
    }
}

