/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.event.EventRift;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.common.world.teleporter.TeleporterHandler;

public class PlayerJoinWorldHandler {
    public static final String NOT_FIRST_JOIN_NBT = "thebetweenlands.not_first_join";
    public static final String NOT_FIRST_SPAWN_NBT = "thebetweenlands.not_first_spawn";

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer && BetweenlandsConfig.WORLD_AND_DIMENSION.activateRiftOnFirstJoin && event.getWorld().field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            boolean isFirstTimeInDimension;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            NBTTagCompound dataNbt = player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            boolean bl = isFirstTimeInDimension = !persistentNbt.func_150297_b(NOT_FIRST_JOIN_NBT, 1) || !persistentNbt.func_74767_n(NOT_FIRST_JOIN_NBT);
            if (isFirstTimeInDimension) {
                int minActiveTicks = BetweenlandsConfig.WORLD_AND_DIMENSION.minRiftOnFirstJoinDuration * 20;
                EventRift rift = BetweenlandsWorldStorage.forWorld((World)event.getWorld()).getEnvironmentEventRegistry().rift;
                if (!rift.isActive()) {
                    rift.setActive(true);
                }
                if (rift.getTicks() < minActiveTicks) {
                    rift.setTicks(minActiveTicks);
                }
                persistentNbt.func_74757_a(NOT_FIRST_JOIN_NBT, true);
                dataNbt.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && BetweenlandsConfig.WORLD_AND_DIMENSION.startInBetweenlands && event.player.field_70170_p.field_73011_w.getDimension() != BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && event.player.field_70170_p instanceof WorldServer) {
            boolean isFirstTimeSpawning;
            NBTTagCompound dataNbt = event.player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            boolean bl = isFirstTimeSpawning = !persistentNbt.func_150297_b(NOT_FIRST_SPAWN_NBT, 1) || !persistentNbt.func_74767_n(NOT_FIRST_SPAWN_NBT);
            if (isFirstTimeSpawning) {
                persistentNbt.func_74757_a(NOT_FIRST_SPAWN_NBT, true);
                dataNbt.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
                WorldServer blWorld = ((WorldServer)event.player.field_70170_p).func_73046_m().func_71218_a(BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
                TeleporterHandler.transferToDim((Entity)event.player, (World)blWorld, BetweenlandsConfig.WORLD_AND_DIMENSION.startInPortal, true);
            }
        }
    }
}

