/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityAnadia;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityFishingSpear
extends Entity
implements IProjectile,
IThrowableEntity {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityFishingSpear.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityFishingSpear.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> ANIMATED = EntityDataManager.func_187226_a(EntityFishingSpear.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ITEMSTACK_DAMAGE = EntityDataManager.func_187226_a(EntityFishingSpear.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile;
    protected int inData;
    protected boolean inGround;
    protected int timeInGround;
    public int arrowShake;
    public Entity shootingEntity;
    protected int ticksInGround;
    protected int ticksInAir;
    protected double damage = 0.0;
    private boolean returnHome;
    public int returningTicks;
    private static final byte EVENT_DEAD = 111;

    public EntityFishingSpear(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityFishingSpear(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public EntityFishingSpear(World world, EntityLivingBase shooter) {
        this(world, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shootingEntity = shooter;
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        this.shootingEntity = entity;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityFishingSpear.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(ITEMSTACK_DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATED, (Object)false);
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70107_b(double x, double y, double z) {
        if (!this.inGround) {
            super.func_70107_b(x, y, z);
        }
    }

    public void moveToTarget(double targetX, double targetY, double targetZ, float velocity) {
        float distSq = MathHelper.func_76133_a((double)(targetX * targetX + targetY * targetY + targetZ * targetZ));
        targetX /= (double)distSq;
        targetY /= (double)distSq;
        targetZ /= (double)distSq;
        this.field_70159_w = targetX *= (double)velocity;
        this.field_70181_x = targetY *= (double)velocity;
        this.field_70179_y = targetZ *= (double)velocity;
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getItemStackDamage() >= 64) {
            this.func_130014_f_().func_72960_a((Entity)this, (byte)111);
            this.func_70106_y();
        }
        if (this.timeInGround > 4 && this.getType() == 2 && this.getAnimated()) {
            this.returnHome = true;
        }
        Entity entityOwner = this.getThrower();
        if ((this.returnHome || this.field_70145_X) && entityOwner != null && this.getType() == 2) {
            this.field_70145_X = true;
            this.inGround = false;
            double targetX = entityOwner.field_70165_t - this.field_70165_t;
            double targetY = entityOwner.field_70163_u + (double)entityOwner.func_70047_e() - this.field_70163_u + (double)this.field_70131_O * 0.5;
            double targetZ = entityOwner.field_70161_v - this.field_70161_v;
            this.moveToTarget(targetX, targetY, targetZ, 0.5f);
            double wiggleSpeed = Math.sin((double)(this.field_70173_aa + this.func_145782_y()) * 0.5) * 0.05;
            double wiggleOffsetX = Math.cos(this.field_70177_z * 0.01f);
            double wiggleOffsetZ = Math.sin(this.field_70177_z * 0.01f);
            this.field_70159_w += wiggleSpeed * wiggleOffsetX;
            this.field_70179_y += wiggleSpeed * wiggleOffsetZ;
            if (this.field_70170_p.field_72995_K) {
                this.field_70137_T = this.field_70163_u;
            }
            if (this.returningTicks == 0) {
                this.func_184185_a(SoundRegistry.SPEAR_RETURN_1, 1.0f, 1.0f);
            }
            ++this.returningTicks;
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && !this.field_70145_X && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            int j = block.func_176201_c(iblockstate);
            if (!(block == this.inTile && j == this.inData || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05)))) {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= 6000) {
                    this.func_70106_y();
                }
            }
            ++this.timeInGround;
        } else {
            this.timeInGround = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = this.findEntityOnPath(vec3d1, vec3d);
            if (this.field_70145_X) {
                raytraceresult = null;
            }
            if (entity != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null) {
                this.onHit(raytraceresult);
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit(raytraceresult);
            }
            if (this.getIsCritical()) {
                for (int k = 0; k < 4; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            if (this.shootingEntity != null && this.func_70032_d(this.shootingEntity) > 4.0f) {
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
            } else {
                this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)(-f4)) * 57.29577951308232);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float drag = 0.99f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                drag = this.getWaterDrag();
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.05f;
            }
            this.field_70159_w *= (double)drag;
            this.field_70181_x *= (double)drag;
            this.field_70179_y *= (double)drag;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (!this.field_70145_X) {
                this.func_145775_I();
            }
        }
    }

    public float getWaterDrag() {
        switch (this.getType()) {
            case 0: {
                return 0.6f;
            }
            case 1: 
            case 2: {
                return 0.99f;
            }
        }
        return 0.99f;
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            DamageSource damagesource;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            if (entity instanceof EntityAnadia) {
                this.setDamage(((EntityAnadia)entity).func_110138_aP());
                f = 1.0f;
            } else if (entity instanceof EntityAngler) {
                this.setDamage(((EntityAngler)entity).func_110138_aP());
                f = 1.0f;
            } else if (this.returningTicks > 0 && entity != this.shootingEntity) {
                this.setDamage(4.0);
            }
            int i = MathHelper.func_76143_f((double)((double)f * this.damage));
            if (this.getIsCritical()) {
                i += this.field_70146_Z.nextInt(i / 2 + 2);
            }
            if (entity.func_70097_a(damagesource = this.shootingEntity == null ? DamageSource.func_76356_a((Entity)this, (Entity)this) : DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), (float)i)) {
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.shootingEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.setItemStackDamage(this.getItemStackDamage() + 1);
                    }
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundRegistry.SPEAR_LAND, 1.0f, 1.0f);
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
            }
        } else {
            if (!(this.field_70170_p.field_72995_K || this.inGround || this.func_70090_H())) {
                this.setItemStackDamage(this.getItemStackDamage() + 2);
            }
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.inData = this.inTile.func_176201_c(iblockstate);
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(SoundRegistry.SPEAR_LAND, 1.0f, 1.0f);
            this.func_184185_a(iblockstate.func_177230_c().getSoundType(iblockstate, this.field_70170_p, blockpos, null).func_185845_c(), 1.5f, 1.5f);
            this.inGround = true;
            this.arrowShake = 7;
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.inGround) {
            this.xTile = MathHelper.func_76128_c((double)this.field_70165_t);
            this.yTile = MathHelper.func_76128_c((double)this.field_70163_u);
            this.zTile = MathHelper.func_76128_c((double)this.field_70161_v);
        }
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        Entity hit = null;
        double minDstSq = 0.0;
        for (Entity entity : list) {
            double dstSq;
            AxisAlignedBB checkBox;
            RayTraceResult rayTrace;
            if (!this.isNotShootingEntity(entity) && this.ticksInAir < 5 || (rayTrace = (checkBox = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null || !((dstSq = start.func_72436_e(rayTrace.field_72307_f)) < minDstSq) && minDstSq != 0.0) continue;
            hit = entity;
            minDstSq = dstSq;
        }
        return hit;
    }

    private boolean isNotShootingEntity(Entity entity) {
        if (entity == this.shootingEntity) {
            return false;
        }
        if (!(this.shootingEntity instanceof EntityPlayer) && this.shootingEntity != null && this.shootingEntity.func_184187_bx() == entity) {
            return false;
        }
        return !(this.shootingEntity instanceof EntityPlayer) || this.shootingEntity == null || !(entity instanceof IEntityOwnable) || ((IEntityOwnable)entity).func_70902_q() != this.shootingEntity || !this.shootingEntity.func_184182_bu().contains(entity);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74777_a("life", (short)this.ticksInGround);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        compound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        compound.func_74780_a("damage", this.damage);
        compound.func_74757_a("crit", this.getIsCritical());
        compound.func_74768_a("itemStackDamage", this.getItemStackDamage());
        compound.func_74774_a("type", this.getType());
        compound.func_74757_a("animated", this.getAnimated());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.ticksInGround = compound.func_74765_d("life");
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        boolean bl = this.inGround = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        this.setIsCritical(compound.func_74767_n("crit"));
        this.setItemStackDamage(compound.func_74762_e("itemStackDamage"));
        this.setType(compound.func_74771_c("type"));
        this.setAnimated(compound.func_74767_n("animated"));
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0 || !this.field_70170_p.field_72995_K && this.func_70090_H()) {
            if (entityIn.field_71075_bZ.field_75098_d) {
                this.func_70106_y();
            } else if (this.field_70173_aa >= 20 && entityIn.field_71071_by.func_70441_a(this.getEntityItem())) {
                this.field_70170_p.func_184133_a(null, entityIn.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 1.0f, 1.0f);
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        } else if (!this.field_70170_p.field_72995_K && !this.inGround && this.arrowShake <= 0 || !this.field_70170_p.field_72995_K && this.func_70090_H()) {
            if (entityIn.field_71075_bZ.field_75098_d && this.field_70173_aa >= 4) {
                this.func_70106_y();
            } else if (this.field_70173_aa >= 4 && entityIn == this.getThrower() && this.getType() == 2 && this.getAnimated() && entityIn.field_71071_by.func_70441_a(this.getEntityItem())) {
                this.field_70170_p.func_184133_a(null, entityIn.func_180425_c(), (SoundEvent)SoundRegistry.SPEAR_RETURN_2, SoundCategory.PLAYERS, 1.0f, 1.0f);
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 111) {
            for (int count = 0; count <= 10; ++count) {
                BLParticles.ITEM_BREAKING.spawn(this.func_130014_f_(), this.field_70165_t + (this.func_130014_f_().field_73012_v.nextDouble() - 0.5), this.field_70163_u + (this.func_130014_f_().field_73012_v.nextDouble() - 0.5), this.field_70161_v + (this.func_130014_f_().field_73012_v.nextDouble() - 0.5), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(new ItemStack(ItemRegistry.FISHING_SPEAR)));
            }
        }
    }

    protected ItemStack getEntityItem() {
        ItemStack damagedStack = ItemStack.field_190927_a;
        switch (this.getType()) {
            case 0: {
                damagedStack = new ItemStack(ItemRegistry.FISHING_SPEAR);
                break;
            }
            case 1: {
                damagedStack = new ItemStack(ItemRegistry.FISHING_SPEAR_AMPHIBIOUS);
                break;
            }
            case 2: {
                damagedStack = new ItemStack(ItemRegistry.FISHING_SPEAR_AMPHIBIOUS_ROBUST);
                if (!damagedStack.func_77942_o()) {
                    damagedStack.func_77982_d(new NBTTagCompound());
                }
                damagedStack.func_77978_p().func_74757_a("animated", this.getAnimated());
            }
        }
        damagedStack.func_77964_b(this.getItemStackDamage());
        return damagedStack;
    }

    public void setItemStackDamage(int amount) {
        this.field_70180_af.func_187227_b(ITEMSTACK_DAMAGE, (Object)amount);
    }

    public int getItemStackDamage() {
        return (Integer)this.field_70180_af.func_187225_a(ITEMSTACK_DAMAGE);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    public double getDamage() {
        return this.damage;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setIsCritical(boolean critical) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (critical) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        return (b0 & 1) != 0;
    }

    public void setType(byte type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    public byte getType() {
        return (Byte)this.field_70180_af.func_187225_a(TYPE);
    }

    public void setAnimated(boolean animated) {
        this.field_70180_af.func_187227_b(ANIMATED, (Object)animated);
    }

    public boolean getAnimated() {
        return (Boolean)this.field_70180_af.func_187225_a(ANIMATED);
    }

    public void setEnchantmentEffectsFromEntity(EntityLivingBase entity, float amount) {
        this.setDamage((double)(amount * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
    }

    public boolean isInBlock() {
        return this.inGround;
    }
}

