/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntityMovingWallFace;
import thebetweenlands.common.entity.mobs.EntityWallFace;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityWallLivingRoot
extends EntityMovingWallFace
implements IMob,
IEntityMultiPart {
    public static final byte EVENT_DEATH = 3;
    public static final byte EVENT_HURT_SOUND = 82;
    public static final IAttribute MAX_ARM_LENGTH = new RangedAttribute(null, "bl.maxRootArmLength", 2.5, 0.0, 16.0).func_111117_a("Maximum length of root arm").func_111112_a(true);
    private static final DataParameter<Integer> REL_TIP_X = EntityDataManager.func_187226_a(EntityWallLivingRoot.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> REL_TIP_Y = EntityDataManager.func_187226_a(EntityWallLivingRoot.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> REL_TIP_Z = EntityDataManager.func_187226_a(EntityWallLivingRoot.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean rootTipPositionSet = false;
    public final MultiPartEntityPart rootTip;
    private MultiPartEntityPart[] parts;
    private EnumFacing segmentsFacing = EnumFacing.NORTH;
    public List<ArmSegment> armSegments = new ArrayList<ArmSegment>();
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite wallSprite;
    protected int armMovementTicks;

    public EntityWallLivingRoot(World world) {
        super(world);
        this.lookMoveSpeedMultiplier = 8.0f;
        this.field_70728_aV = 7;
        this.parts = new MultiPartEntityPart[this.getNumSegments() + 1];
        this.parts[0] = this.rootTip = new MultiPartEntityPart((IEntityMultiPart)this, "rootTip", this.getNodeSize(0), this.getNodeSize(0));
        for (int i = 0; i < this.getNumSegments(); ++i) {
            this.parts[i + 1] = new MultiPartEntityPart((IEntityMultiPart)this, "rootNode" + i, this.getNodeSize(this.getNumSegments() - i + 1), this.getNodeSize(this.getNumSegments() - i + 1));
        }
    }

    protected float getNodeSize(int node) {
        return 0.3f;
    }

    protected float[][] getArmCrossSection() {
        float width = this.getFullArmWidth();
        return new float[][]{{-width, width}, {-width, -width}, {width, -width}, {width, width}};
    }

    protected int getNumSegments() {
        return 8;
    }

    protected float getFullArmWidth() {
        return 0.2f;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.armMovementTicks = this.field_70170_p.field_73012_v.nextInt(10000);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REL_TIP_X, (Object)0);
        this.field_70180_af.func_187214_a(REL_TIP_Y, (Object)0);
        this.field_70180_af.func_187214_a(REL_TIP_Z, (Object)0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved(this, true){

            protected double func_111175_f() {
                return 8.0;
            }
        });
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null).func_190882_b(120));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityMovingWallFace.AITrackTarget<EntityWallLivingRoot>(this, true, 28.0){

            @Override
            protected boolean canMove() {
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIArmAttack(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.08);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
        this.func_110140_aT().func_111150_b(MAX_ARM_LENGTH);
    }

    public Vec3d getTipPos() {
        return new Vec3d(this.field_70165_t + (double)((float)((Integer)this.field_70180_af.func_187225_a(REL_TIP_X)).intValue() / 512.0f), this.field_70163_u + (double)((float)((Integer)this.field_70180_af.func_187225_a(REL_TIP_Y)).intValue() / 512.0f), this.field_70161_v + (double)((float)((Integer)this.field_70180_af.func_187225_a(REL_TIP_Z)).intValue() / 512.0f));
    }

    public void setTipPos(Vec3d pos) {
        this.field_70180_af.func_187227_b(REL_TIP_X, (Object)((int)((pos.field_72450_a - this.field_70165_t) * 512.0)));
        this.field_70180_af.func_187227_b(REL_TIP_Y, (Object)((int)((pos.field_72448_b - this.field_70163_u) * 512.0)));
        this.field_70180_af.func_187227_b(REL_TIP_Z, (Object)((int)((pos.field_72449_c - this.field_70161_v) * 512.0)));
    }

    protected Vec3d updateTargetTipPos(Vec3d armStartWorld, float maxArmLength, Vec3d dirFwd, Vec3d dirUp) {
        float flailingStrength = this.field_82175_bq ? 1.0f - this.field_70733_aJ : (this.field_70737_aN > 0 ? (float)this.field_70737_aN / (float)this.field_70738_aO * 0.5f : 0.0f);
        this.armMovementTicks += 1 + (int)(flailingStrength * 10.0f);
        float idleX = MathHelper.func_76134_b((float)((float)this.armMovementTicks / 9.0f)) * 0.75f;
        float idleY = MathHelper.func_76126_a((float)((float)this.armMovementTicks / 7.0f)) * 0.75f;
        float idleZ = (MathHelper.func_76134_b((float)((float)this.armMovementTicks / 15.0f)) + 1.0f) * 0.25f;
        Vec3d targetTipPos = armStartWorld.func_178787_e(dirFwd.func_186678_a((double)maxArmLength));
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            targetTipPos = target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0);
        }
        float forwardPos = (float)dirFwd.func_72430_b(targetTipPos.func_178788_d(armStartWorld));
        float offsetZ = 0.0f;
        if (forwardPos < 1.0f) {
            offsetZ = 1.0f - forwardPos;
        }
        targetTipPos = targetTipPos.func_178787_e(dirUp.func_186678_a((double)idleY)).func_178787_e(dirFwd.func_72431_c(dirUp).func_186678_a((double)idleX)).func_178787_e(dirFwd.func_186678_a((double)(offsetZ - idleZ)));
        Vec3d tipPos = this.rootTip.func_174791_d();
        Vec3d tipDiff = targetTipPos.func_178788_d(tipPos);
        targetTipPos = tipPos.func_178787_e(tipDiff.func_72432_b().func_186678_a(Math.min(tipDiff.func_72433_c(), 0.1 + (double)flailingStrength * 0.9)));
        return targetTipPos;
    }

    protected float getArmLengthSlack() {
        return 0.0f;
    }

    @Override
    public void func_70071_h_() {
        Vec3d dir;
        int i;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        float maxArmLength = (float)this.func_110148_a(MAX_ARM_LENGTH).func_111126_e() * this.getArmSize(1.0f);
        float segmentLength = maxArmLength / (float)(this.getNumSegments() - 2);
        Vec3d dirFwd = new Vec3d((double)this.getFacing().func_82601_c(), (double)this.getFacing().func_96559_d(), (double)this.getFacing().func_82599_e());
        Vec3d dirUp = new Vec3d((double)this.getFacingUp().func_82601_c(), (double)this.getFacingUp().func_96559_d(), (double)this.getFacingUp().func_82599_e());
        Vec3d armStart = new Vec3d(0.0, (double)(this.field_70131_O / 2.0f), 0.0).func_72441_c(-dirFwd.field_72450_a * (double)(this.field_70130_N / 2.0f - 0.1f), -dirFwd.field_72448_b * (double)(this.field_70131_O / 2.0f - 0.1f), -dirFwd.field_72449_c * (double)(this.field_70130_N / 2.0f - 0.1f));
        Vec3d ikArmStart = new Vec3d(0.0, (double)(this.field_70131_O / 2.0f), 0.0).func_178787_e(dirFwd.func_186678_a((double)0.1f));
        for (MultiPartEntityPart part : this.parts) {
            part.func_70071_h_();
        }
        if (!this.rootTipPositionSet) {
            Vec3d tipPos = this.func_174791_d().func_178787_e(armStart.func_178787_e(dirFwd.func_186678_a((double)maxArmLength)).func_72441_c(0.0, (double)(-this.rootTip.field_70131_O / 2.0f), 0.0));
            this.setTipPos(tipPos);
            this.rootTip.func_70107_b(tipPos.field_72450_a, tipPos.field_72448_b, tipPos.field_72449_c);
            this.rootTipPositionSet = true;
        }
        Vec3d armEnd = this.rootTip.func_174791_d().func_72441_c(0.0, (double)(this.rootTip.field_70131_O / 2.0f), 0.0).func_178788_d(this.func_174791_d());
        if (!this.field_70170_p.field_72995_K) {
            Vec3d armStartWorld = this.func_174791_d().func_178787_e(ikArmStart);
            Vec3d tipPos = this.updateTargetTipPos(armStartWorld, maxArmLength, dirFwd, dirUp);
            tipPos = armStartWorld.func_178787_e(tipPos.func_178788_d(armStartWorld).func_72432_b().func_186678_a(Math.min(tipPos.func_178788_d(armStartWorld).func_72433_c(), (double)(maxArmLength + this.getArmLengthSlack()))));
            this.setTipPos(tipPos);
            this.rootTip.func_70107_b(tipPos.field_72450_a, tipPos.field_72448_b, tipPos.field_72449_c);
        } else {
            Vec3d tipPos = this.getTipPos();
            this.rootTip.func_70107_b(tipPos.field_72450_a, tipPos.field_72448_b, tipPos.field_72449_c);
            this.updateWallSprite();
        }
        if (this.armSegments.size() != this.getNumSegments() || this.getFacing() != this.segmentsFacing) {
            this.armSegments.clear();
            for (int i2 = 0; i2 < this.getNumSegments(); ++i2) {
                ArmSegment segment = new ArmSegment(this);
                float dist = maxArmLength / (float)(this.getNumSegments() - 1) * (float)i2;
                segment.update(dirUp, ikArmStart.func_72441_c(dirFwd.field_72450_a * (double)dist, dirFwd.field_72448_b * (double)dist, dirFwd.field_72449_c * (double)dist), dirFwd);
                this.armSegments.add(segment);
            }
            this.segmentsFacing = this.getFacing();
        }
        for (ArmSegment segment : this.armSegments) {
            segment.updatePrev();
            segment.pos = segment.pos.func_178787_e(segment.motion);
        }
        for (i = this.getNumSegments() - 2; i >= 2; --i) {
            ArmSegment segment = this.armSegments.get(i);
            Vec3d target = i == this.getNumSegments() - 2 ? armEnd : this.armSegments.get((int)(i + 1)).pos;
            dir = segment.pos.func_178788_d(target).func_72432_b();
            segment.update(dirUp, target.func_178787_e(dir.func_186678_a((double)segmentLength)), dir.func_186678_a(-1.0));
        }
        for (i = 2; i < this.getNumSegments(); ++i) {
            ArmSegment segment = this.armSegments.get(i);
            Vec3d target = i == 0 ? ikArmStart : this.armSegments.get((int)(i - 1)).pos;
            dir = segment.pos.func_178788_d(target).func_72432_b();
            segment.update(dirUp, target.func_178787_e(dir.func_186678_a((double)segmentLength)), dir.func_186678_a(-1.0));
        }
        ArmSegment startSegment = this.armSegments.get(0);
        startSegment.update(dirUp, armStart, new Vec3d(-dirFwd.field_72450_a, -dirFwd.field_72448_b, -dirFwd.field_72449_c));
        ArmSegment startSegment2 = this.armSegments.get(1);
        startSegment2.update(dirUp, ikArmStart, new Vec3d(-dirFwd.field_72450_a, -dirFwd.field_72448_b, -dirFwd.field_72449_c));
        ArmSegment endSegment = this.armSegments.get(this.armSegments.size() - 1);
        endSegment.update(dirUp, armEnd, this.armSegments.get((int)(this.armSegments.size() - 2)).pos.func_178788_d(armEnd).func_72432_b());
        for (int i3 = 0; i3 < this.getNumSegments(); ++i3) {
            ArmSegment segment = this.armSegments.get(i3);
            Vec3d pos = segment.pos;
            this.parts[i3 + 1].func_70107_b(this.field_70165_t + pos.field_72450_a, this.field_70163_u + pos.field_72448_b - (double)(this.parts[i3 + 1].field_70131_O / 2.0f), this.field_70161_v + pos.field_72449_c);
        }
    }

    @Override
    protected void updateMovement() {
        if (!this.field_70170_p.field_72995_K && this.isMoving() && this.getMoveReason() != EntityWallFace.MoveReason.LOOK) {
            boolean wasFirstHalf = this.getMovementProgress(1.0f) < 0.5f;
            super.updateMovement();
            if (this.getMovementProgress(1.0f) >= 0.5f && wasFirstHalf) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.WALL_LIVING_ROOT_EMERGE, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        } else {
            super.updateMovement();
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateWallSprite() {
        this.wallSprite = null;
        BlockPos pos = this.func_180425_c();
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if ((state = state.func_185899_b((IBlockAccess)this.field_70170_p, pos)).func_185917_h()) {
            this.wallSprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getWallSprite() {
        return this.wallSprite;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.armMovementTicks = nbt.func_74762_e("armMovementTicks");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("armMovementTicks", this.armMovementTicks);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.LIVING_ROOT_DEATH;
    }

    protected void func_184581_c(DamageSource source) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)82);
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 3) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.LIVING_ROOT_DEATH, this.func_184176_by(), 0.75f, 0.8f, false);
        }
        if (id == 82) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.LIVING_ROOT_HURT, this.func_184176_by(), 0.75f, 0.5f, false);
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.WALL_LIVING_ROOT;
    }

    @Override
    public boolean canResideInBlock(BlockPos pos, EnumFacing facing, EnumFacing facingUp) {
        return this.isValidBlockForMovement(pos, this.field_70170_p.func_180495_p(pos));
    }

    @Override
    protected boolean isValidBlockForMovement(BlockPos pos, IBlockState state) {
        return state.func_185914_p() && state.func_185915_l() && state.func_185917_h() && state.func_185887_b(this.field_70170_p, pos) > 0.0f && (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151575_d);
    }

    @Override
    public Vec3d getOffset(float movementProgress) {
        return super.getOffset(1.0f);
    }

    public float getArmSize(float partialTicks) {
        return this.getHalfMovementProgress(partialTicks);
    }

    public float getHoleDepthPercent(float partialTicks) {
        return this.getHalfMovementProgress(partialTicks);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public Entity[] func_70021_al() {
        return this.parts;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack item;
        EntityLivingBase attacker;
        EntityLivingBase entityLivingBase = attacker = source.func_76364_f() instanceof EntityLivingBase ? (EntityLivingBase)source.func_76364_f() : null;
        if (attacker != null && attacker.func_184600_cs() != null && !(item = attacker.func_184586_b(attacker.func_184600_cs())).func_190926_b() && item.func_77973_b().getToolClasses(item).contains("axe")) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }

    protected static class AIArmAttack
    extends EntityAIBase {
        protected final EntityWallLivingRoot entity;
        protected int attackTicks;

        public AIArmAttack(EntityWallLivingRoot entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() != null;
        }

        public void func_75246_d() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (this.attackTicks > 0) {
                --this.attackTicks;
            } else if (target != null && target.func_174813_aQ().func_72326_a(this.entity.rootTip.func_174813_aQ())) {
                this.entity.func_70652_k((Entity)target);
                this.entity.func_184609_a(EnumHand.MAIN_HAND);
                this.attackTicks = 20;
            }
        }
    }

    public static class ArmSegment {
        public Vec3d motion = Vec3d.field_186680_a;
        public Vec3d prevPos;
        public Vec3d pos;
        public final float[] offsetX;
        public final float[] offsetY;
        public final float[] offsetZ;
        private final float[][] armCrossSection;

        public ArmSegment(EntityWallLivingRoot root) {
            this.armCrossSection = root.getArmCrossSection();
            this.offsetX = new float[this.armCrossSection.length];
            this.offsetY = new float[this.armCrossSection.length];
            this.offsetZ = new float[this.armCrossSection.length];
        }

        public void updatePrev() {
            this.prevPos = this.pos == null ? Vec3d.field_186680_a : this.pos;
        }

        public void update(Vec3d quadUp, Vec3d pos, Vec3d dir) {
            this.pos = pos;
            Vec3d right = dir.func_72431_c(quadUp).func_72432_b();
            Vec3d up = right.func_72431_c(dir).func_72432_b();
            int i = 0;
            for (float[] hullCrossSection : this.armCrossSection) {
                float hullX = hullCrossSection[0];
                float hullY = hullCrossSection[1];
                this.offsetX[i] = (float)(right.field_72450_a * (double)hullX + up.field_72450_a * (double)hullY);
                this.offsetY[i] = (float)(right.field_72448_b * (double)hullX + up.field_72448_b * (double)hullY);
                this.offsetZ[i] = (float)(right.field_72449_c * (double)hullX + up.field_72449_c * (double)hullY);
                ++i;
            }
        }
    }
}

