/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.common.entity.mobs.EntityMovingWallFace;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceSmall;
import thebetweenlands.common.entity.projectiles.EntitySapSpit;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public abstract class EntitySpiritTreeFace
extends EntityMovingWallFace {
    public static final byte EVENT_ATTACKED = 2;
    public static final byte EVENT_DEATH = 3;
    public static final byte EVENT_EMERGE_SOUND = 81;
    public static final byte EVENT_HURT_SOUND = 82;
    public static final byte EVENT_SPIT = 83;
    protected int spitTicks = 0;
    protected float spitDamage;
    private boolean emergeSound = false;
    protected int prevGlowTicks = 0;
    protected int glowTicks = 0;
    protected int glowDuration = 0;

    public EntitySpiritTreeFace(World world) {
        super(world);
        this.field_70728_aV = 4;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public void setGlowTicks(int duration) {
        this.glowTicks = duration = Math.max(duration, 1);
        this.glowDuration = duration;
    }

    public float getGlow(float partialTicks) {
        return ((float)this.prevGlowTicks + (float)(this.glowTicks - this.prevGlowTicks) * partialTicks) / (float)this.glowDuration;
    }

    protected void playSpitSound() {
    }

    protected void playEmergeSound() {
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_174814_R() {
        return super.func_174814_R() || !this.isActive();
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_184581_c(DamageSource source) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)82);
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 83) {
            if (this.glowTicks < 10) {
                this.setGlowTicks(10);
            }
        } else if (id == 2) {
            if (this.glowTicks < 10) {
                this.setGlowTicks(10);
            }
        } else if (id == 82 || id == 3) {
            SoundType soundType = SoundType.field_185848_a;
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 1.3f, soundType.func_185847_b() * 0.8f, false);
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185846_f(), SoundCategory.NEUTRAL, (soundType.func_185843_a() + 1.0f) / 4.0f, soundType.func_185847_b() * 0.5f, false);
        }
    }

    public boolean isActive() {
        return true;
    }

    @Override
    protected boolean func_70610_aX() {
        return !this.isActive() || this.isAttacking() || super.func_70610_aX();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean canResideInBlock(BlockPos pos, EnumFacing facing, EnumFacing facingUp) {
        return this.field_70170_p.func_180495_p(pos).func_177230_c() == BlockRegistry.LOG_SPIRIT_TREE;
    }

    public boolean func_85031_j(Entity entity) {
        if (this.func_190530_aW()) {
            return true;
        }
        return super.func_85031_j(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack item;
        EntityLivingBase attacker;
        if (this.func_190530_aW()) {
            return false;
        }
        if (source.func_76364_f() instanceof IProjectile && source.func_76346_g() != null && source.func_76346_g().func_70032_d((Entity)this) >= 26.0f) {
            return false;
        }
        EntityLivingBase entityLivingBase = attacker = source.func_76364_f() instanceof EntityLivingBase ? (EntityLivingBase)source.func_76364_f() : null;
        if (attacker != null && attacker.func_184600_cs() != null && !(item = attacker.func_184586_b(attacker.func_184600_cs())).func_190926_b() && item.func_77973_b().getToolClasses(item).contains("axe")) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76369_e || source == DamageSource.field_76371_c || super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        return super.func_190530_aW() || !this.isActive();
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevGlowTicks = this.glowTicks;
        if (this.glowTicks > 0) {
            --this.glowTicks;
        }
        if (!this.field_70170_p.field_72995_K) {
            float moveProgress = this.getMovementProgress(1.0f);
            if (moveProgress < 0.6f) {
                this.emergeSound = false;
            } else {
                if (!this.emergeSound) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)81);
                    this.playEmergeSound();
                }
                this.emergeSound = true;
            }
        }
        if (this.spitTicks > 0) {
            this.updateSpitAttack();
        }
    }

    protected void updateSpitAttack() {
        if (this.spitTicks == 1) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
            this.setGlowTicks(10);
            this.playSpitSound();
        }
        if (this.spitTicks > 6) {
            this.doSpitAttack();
            this.spitTicks = 0;
        } else {
            ++this.spitTicks;
        }
    }

    @Override
    protected boolean isValidBlockForMovement(BlockPos pos, IBlockState state) {
        return state.func_177230_c() == BlockRegistry.LOG_SPIRIT_TREE;
    }

    public boolean isAttacking() {
        return this.spitTicks > 0;
    }

    public void startSpit(float spitDamage) {
        this.spitTicks = 1;
        this.spitDamage = spitDamage;
    }

    public void doSpitAttack() {
        EntityLivingBase target = this.func_70638_az();
        if (target != null) {
            EnumFacing facing = this.getFacing();
            EntitySapSpit spit = new EntitySapSpit(this.field_70170_p, (EntityLivingBase)this, this.spitDamage);
            spit.func_70107_b(this.field_70165_t + (double)((float)facing.func_82601_c() * (this.field_70130_N / 2.0f + 0.1f)), this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)((float)facing.func_96559_d() * (this.field_70131_O / 2.0f + 0.1f)), this.field_70161_v + (double)((float)facing.func_82599_e() * (this.field_70130_N / 2.0f + 0.1f)));
            double dx = target.field_70165_t - spit.field_70165_t;
            double dy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - spit.field_70163_u;
            double dz = target.field_70161_v - spit.field_70161_v;
            double dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
            spit.func_70186_c(dx, dy + dist * (double)0.2f, dz, 1.0f, 1.0f);
            this.field_70170_p.func_72838_d((Entity)spit);
        }
    }

    public static class AISpit
    extends EntityAIBase {
        protected final EntitySpiritTreeFace entity;
        protected int minCooldown;
        protected int maxCooldown;
        protected int cooldown = 0;
        protected float spitDamage;

        public AISpit(EntitySpiritTreeFace entity, float spitDamage) {
            this(entity, spitDamage, 50, 170);
        }

        public AISpit(EntitySpiritTreeFace entity, float spitDamage, int minCooldown, int maxCooldown) {
            this.entity = entity;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.spitDamage = spitDamage;
            this.func_75248_a(0);
        }

        public boolean isWearingTreeMask(EntityLivingBase entityIn) {
            ItemStack helmet;
            return entityIn instanceof EntityPlayer && this.entity instanceof EntitySpiritTreeFaceSmall && !(helmet = ((EntityPlayer)entityIn).func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && (helmet.func_77973_b() == ItemRegistry.SPIRIT_TREE_FACE_SMALL_MASK || helmet.func_77973_b() == ItemRegistry.SPIRIT_TREE_FACE_LARGE_MASK);
        }

        public boolean func_75250_a() {
            return this.entity.isActive() && !this.entity.isAttacking() && !this.entity.isMoving() && this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az()) && !this.isWearingTreeMask(this.entity.func_70638_az());
        }

        public void func_75249_e() {
            this.cooldown = 20 + this.entity.field_70146_Z.nextInt(40);
        }

        public void func_75246_d() {
            if (!this.entity.isAttacking()) {
                if (this.cooldown <= 0) {
                    this.cooldown = this.minCooldown + this.entity.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown + 1);
                    this.entity.startSpit(this.getSpitDamage());
                }
                --this.cooldown;
            }
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        protected float getSpitDamage() {
            return this.spitDamage;
        }
    }

    public static class AITrackTargetSpiritTreeFace
    extends EntityMovingWallFace.AITrackTarget<EntitySpiritTreeFace> {
        public AITrackTargetSpiritTreeFace(EntitySpiritTreeFace entity) {
            super(entity);
        }

        public AITrackTargetSpiritTreeFace(EntitySpiritTreeFace entity, boolean stayInRange, double maxRange) {
            super(entity, stayInRange, maxRange);
        }

        @Override
        protected boolean canMove() {
            return ((EntitySpiritTreeFace)this.entity).isActive() && !((EntitySpiritTreeFace)this.entity).isAttacking();
        }
    }
}

