/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntitySiltCrab
extends EntityMob
implements IEntityBL {
    protected EntityAIAttackMelee aiAttack;
    protected EntityAIAvoidEntity<EntityPlayer> aiRunAway;
    protected EntityAINearestAttackableTarget<EntityPlayer> aiTarget;
    protected int aggroCooldown = 200;
    protected boolean canAttack = false;
    private static final DataParameter<ItemStack> TRIM_ITEM_1 = EntityDataManager.func_187226_a(EntitySiltCrab.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> TRIM_ITEM_2 = EntityDataManager.func_187226_a(EntitySiltCrab.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> TRIM_ITEM_3 = EntityDataManager.func_187226_a(EntitySiltCrab.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntitySiltCrab(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.6f);
        this.field_70138_W = 2.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.CRUNCH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.CRUNCH;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRIM_ITEM_1, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TRIM_ITEM_2, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(TRIM_ITEM_3, (Object)ItemStack.field_190927_a);
    }

    protected void func_184651_r() {
        this.aiAttack = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiRunAway = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 10.0f, 0.7, 0.7);
        this.aiTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
        this.field_70714_bg.func_75776_a(1, this.aiRunAway);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, this.aiTarget);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public void setItem1(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(TRIM_ITEM_1, (Object)itemStack);
    }

    public ItemStack getItem1() {
        return (ItemStack)this.field_70180_af.func_187225_a(TRIM_ITEM_1);
    }

    public void setItem2(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(TRIM_ITEM_2, (Object)itemStack);
    }

    public ItemStack getItem2() {
        return (ItemStack)this.field_70180_af.func_187225_a(TRIM_ITEM_2);
    }

    public void setItem3(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(TRIM_ITEM_3, (Object)itemStack);
    }

    public ItemStack getItem3() {
        return (ItemStack)this.field_70180_af.func_187225_a(TRIM_ITEM_3);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagCompound item1 = new NBTTagCompound();
        this.getItem1().func_77955_b(item1);
        nbt.func_74782_a("item1", (NBTBase)item1);
        NBTTagCompound item2 = new NBTTagCompound();
        this.getItem2().func_77955_b(item2);
        nbt.func_74782_a("item2", (NBTBase)item2);
        NBTTagCompound item3 = new NBTTagCompound();
        this.getItem3().func_77955_b(item3);
        nbt.func_74782_a("item3", (NBTBase)item3);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        NBTBase item1 = nbt.func_74781_a("item1");
        ItemStack stack1 = ItemStack.field_190927_a;
        if (item1 instanceof NBTTagCompound) {
            stack1 = new ItemStack((NBTTagCompound)item1);
        }
        this.setItem1(stack1);
        NBTBase item2 = nbt.func_74781_a("item2");
        ItemStack stack2 = ItemStack.field_190927_a;
        if (item2 instanceof NBTTagCompound) {
            stack2 = new ItemStack((NBTTagCompound)item2);
        }
        this.setItem2(stack2);
        NBTBase item3 = nbt.func_74781_a("item3");
        ItemStack stack3 = ItemStack.field_190927_a;
        if (item3 instanceof NBTTagCompound) {
            stack3 = new ItemStack((NBTTagCompound)item3);
        }
        this.setItem3(stack3);
        if (!this.field_70170_p.field_72995_K && item1 == null && item2 == null && item3 == null) {
            this.randomizeSiltCrabProperties();
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.randomizeSiltCrabProperties();
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public void randomizeSiltCrabProperties() {
        this.setItem1(this.getPartFromLootTable(LootTableRegistry.SILT_CRAB_TRIM_1));
        this.setItem2(this.getPartFromLootTable(LootTableRegistry.SILT_CRAB_TRIM_2));
        this.setItem3(this.getPartFromLootTable(LootTableRegistry.SILT_CRAB_TRIM_3));
    }

    public ItemStack getPartFromLootTable(ResourceLocation lootTableIn) {
        LootContext.Builder lootBuilder;
        List loot;
        LootTable lootTable;
        if (this.field_70170_p instanceof WorldServer && (lootTable = this.field_70170_p.func_184146_ak().func_186521_a(lootTableIn)) != null && !(loot = lootTable.func_186462_a(this.field_70170_p.field_73012_v, (lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this)).func_186471_a())).isEmpty()) {
            return (ItemStack)loot.get(0);
        }
        return ItemStack.field_190927_a;
    }

    public int func_70641_bl() {
        return 5;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.aggroCooldown == 200 && !this.canAttack) {
                this.field_70714_bg.func_85156_a(this.aiRunAway);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
                this.field_70715_bh.func_75776_a(1, this.aiTarget);
                this.canAttack = true;
            }
            if (this.aggroCooldown == 0 && this.canAttack) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttack);
                this.field_70715_bh.func_85156_a(this.aiTarget);
                this.field_70714_bg.func_75776_a(1, this.aiRunAway);
                this.canAttack = false;
            }
            if (this.aggroCooldown < 201) {
                ++this.aggroCooldown;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return !source.equals(DamageSource.field_76369_e) && super.func_70097_a(source, damage);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.func_70032_d((Entity)player) <= 1.5f && this.canAttack) {
            this.aggroCooldown = 0;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean attacked = super.func_70652_k(entityIn);
        if (attacked) {
            this.func_184185_a(SoundRegistry.CRAB_SNIP, 1.0f, 1.0f);
        }
        return attacked;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SILT_CRAB;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean lureToCrabPot(BlockPos pos) {
        return this.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 1.0);
    }

    @Nullable
    public ItemMob getCrabPotItem() {
        return ItemRegistry.SILT_CRAB;
    }
}

