/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.entity.ai.EntityAIHurtByTargetImproved;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.mobs.EntityRockSnotTendril;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityRockSnot
extends EntityProximitySpawner
implements IEntityBL {
    private static final DataParameter<Integer> TENDRIL_COUNT = EntityDataManager.func_187226_a(EntityRockSnot.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> JAW_ANGLE = EntityDataManager.func_187226_a(EntityRockSnot.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> EATING_TIMER = EntityDataManager.func_187226_a(EntityRockSnot.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PEARL_TIMER = EntityDataManager.func_187226_a(EntityRockSnot.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean placed_by_player;
    public int spawnDelayCounter = 20;
    public static final int PEARL_CREATION_TIME = 120;
    public static final Method XP_POINTS = EntityRockSnot.getExperiencePoints();
    public int xpStored = 0;

    public EntityRockSnot(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.5f);
    }

    public World getWorld() {
        return this.func_130014_f_();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.CRUNCH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.CRUNCH;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTargetImproved(this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIShootTendril(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TENDRIL_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(JAW_ANGLE, (Object)0);
        this.field_70180_af.func_187214_a(EATING_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(PEARL_TIMER, (Object)-1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a() == Material.field_151586_h;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ROCK_SNOT;
    }

    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K && this.spawnDelayCounter > 0) {
            --this.spawnDelayCounter;
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (this.func_130014_f_().field_72995_K) {
            if (this.func_70090_H() && !this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).func_185904_a().func_76220_a()) {
                this.field_70181_x -= 0.2;
            }
            if (this.func_184207_aI() && this.getJawAngle() == 16 && this.func_130014_f_().func_82737_E() % 20L == 0L) {
                this.spawnEatingParticles();
            }
            if (this.getPearlTimer() == 1) {
                this.spawnSpittingParticles();
            }
            if (this.getPearlTimer() >= 30 && this.func_130014_f_().func_82737_E() % 10L == 0L) {
                this.spawnMakingParticles();
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getPearlTimer() < 0) {
                if (this.func_130014_f_().func_82737_E() % 5L == 0L) {
                    this.checkAreaHere();
                }
                if (this.func_70638_az() != null) {
                    if (!this.func_184207_aI() && this.getJawAngle() < 80) {
                        this.setJawAngle(this.getJawAngle() + 8);
                        if (this.getEatingHeight() > 0) {
                            this.setEatingHeight(0);
                        }
                    }
                    if (this.func_184207_aI() && this.getJawAngle() > 16) {
                        this.setJawAngle(this.getJawAngle() - 8);
                    }
                }
                if (this.func_70638_az() == null && !this.func_184207_aI() && this.getJawAngle() > 0 && this.getTendrilCount() <= 0) {
                    this.setJawAngle(this.getJawAngle() - 8);
                }
                if (this.func_184207_aI() && this.getJawAngle() == 16 && this.getPlacedByPlayer() && this.func_130014_f_().func_82737_E() % 20L == 0L) {
                    this.setEatingHeight(this.getEatingHeight() + 1);
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.ROCK_SNOT_EAT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    ((Entity)this.func_184188_bt().get(0)).func_70097_a(DamageSource.field_76377_j, 0.0f);
                    if (this.getEatingHeight() == 10 && this.func_184188_bt().get(0) != null) {
                        this.setContainedXP(this.getContainedXP() + Math.round((float)this.getXPEaten((EntityLivingBase)this.func_184188_bt().get(0)) * 0.5f));
                        ((Entity)this.func_184188_bt().get(0)).func_70106_y();
                        if (this.getContainedXP() >= 10) {
                            this.setPearlTimer(120);
                        }
                        this.setEatingHeight(0);
                        this.setJawAngle(0);
                    }
                }
                if (this.func_184207_aI() && this.getJawAngle() == 16 && !this.getPlacedByPlayer() && this.func_130014_f_().func_82737_E() % 20L == 0L) {
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.ROCK_SNOT_EAT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    ((Entity)this.func_184188_bt().get(0)).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
            } else {
                if (this.getPearlTimer() >= 0) {
                    this.setPearlTimer(this.getPearlTimer() - 1);
                    if (this.func_130014_f_().func_82737_E() % 20L == 0L && this.getPearlTimer() >= 30) {
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.ROCK_SNOT_DIGEST, SoundCategory.HOSTILE, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.5f);
                    }
                }
                if (this.getPearlTimer() == 0) {
                    int quotient = this.getContainedXP() / 10;
                    int result = this.getContainedXP() - quotient * 10;
                    this.setContainedXP(result);
                    ItemStack pearl = new ItemStack(ItemRegistry.ROCK_SNOT_PEARL, quotient);
                    EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, pearl);
                    item.field_70179_y = 0.0;
                    item.field_70159_w = 0.0;
                    item.field_70181_x = 0.4;
                    this.field_70170_p.func_72838_d((Entity)item);
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.ROCK_SNOT_SPIT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
        super.func_70071_h_();
    }

    public int getXPEaten(EntityLivingBase entity) {
        int xp = 0;
        if (entity != null) {
            try {
                xp = (Integer)XP_POINTS.invoke((Object)entity, FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_130014_f_())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return xp;
    }

    public static Method getExperiencePoints() {
        Method method = null;
        try {
            method = EntityLiving.class.getDeclaredMethod("getExperiencePoints", EntityPlayer.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = EntityLiving.class.getDeclaredMethod("func_70693_a", EntityPlayer.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public int getContainedXP() {
        return this.xpStored;
    }

    public void setContainedXP(int amount) {
        this.xpStored = amount;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    @Override
    @Nullable
    protected Entity checkArea() {
        return null;
    }

    public void checkAreaHere() {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.proximityBox());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityLivingBase entity = (EntityLivingBase)iterator.next();
                if (entity == null || this.canTarget(entity)) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                this.func_70624_b(null);
                return;
            }
            if (!list.isEmpty()) {
                EntityLivingBase entity = (EntityLivingBase)list.get(0);
                if (this.canSneakPast() && entity.func_70093_af()) {
                    return;
                }
                if (this.checkSight() && !this.func_70685_l((Entity)entity)) {
                    return;
                }
                if (this.getCanShootTendril()) {
                    this.func_70624_b(entity);
                }
                if (!this.field_70128_L && this.isSingleUse()) {
                    this.func_70106_y();
                }
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        return this.func_70685_l(entity) ? super.func_70652_k(entity) : false;
    }

    protected boolean damageSnot(DamageSource source, float ammount) {
        return super.func_70097_a(source, ammount);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76369_e) {
            return false;
        }
        if (source instanceof EntityDamageSource) {
            Entity sourceEntity = ((EntityDamageSource)source).func_76346_g();
            if (!(sourceEntity instanceof EntityPlayer) && this.func_184207_aI() && this.func_184188_bt().get(0) == sourceEntity) {
                return false;
            }
            if (sourceEntity instanceof EntityPlayer && ((EntityPlayer)sourceEntity).func_184812_l_()) {
                this.func_70106_y();
            }
        }
        return this.damageSnot(source, damage);
    }

    public boolean canTarget(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && this.getPlacedByPlayer() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v() || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            return false;
        }
        if (entity instanceof EntityRockSnot) {
            return false;
        }
        if (entity instanceof EntityLurker) {
            return false;
        }
        if (!entity.func_184222_aU()) {
            return false;
        }
        return this.field_70171_ac;
    }

    public boolean func_70686_a(Class entity) {
        if (entity == EntityPlayer.class && this.getPlacedByPlayer()) {
            return false;
        }
        if (entity == EntityRockSnot.class || entity == EntityRockSnotTendril.class) {
            return false;
        }
        if (entity == EntityLurker.class) {
            return false;
        }
        return super.func_70686_a(entity);
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (this.getPlacedByPlayer()) {
            if (!(entity instanceof EntityPlayer)) {
                super.func_70624_b(entity);
            }
        } else {
            super.func_70624_b(entity);
        }
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void func_184232_k(Entity entity) {
        entity.func_70107_b(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O * 0.5f) - (double)(entity.field_70131_O / 10.0f * (float)this.getEatingHeight()), this.field_70161_v);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnMakingParticles() {
        for (int count = 0; count < 5; ++count) {
            BLParticles.GEM_PROC.spawn(this.field_70170_p, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), this.field_70163_u + 0.5 + this.field_70170_p.field_73012_v.nextDouble(), this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnEatingParticles() {
        for (int count = 0; count < 5; ++count) {
            BLParticles.ITEM_BREAKING.spawn(this.field_70170_p, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble(), this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withData(ItemMisc.EnumItemMisc.SNOT.create(1)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnSpittingParticles() {
        for (int count = 0; count < 5; ++count) {
            for (int more = 0; more < 5; ++more) {
                if (this.field_70171_ac) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, this.field_70163_u + (double)count * 0.5, this.field_70161_v, 0.0, 0.1, 0.0, new int[0]);
                    continue;
                }
                BLParticles.RAIN.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)count * 0.5, this.field_70161_v).func_70538_b(0.4118f, 0.2745f, 0.1568f);
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    private int getEatingHeight() {
        return (Integer)this.field_70180_af.func_187225_a(EATING_TIMER);
    }

    public void setEatingHeight(int count) {
        this.field_70180_af.func_187227_b(EATING_TIMER, (Object)count);
    }

    public int getPearlTimer() {
        return (Integer)this.field_70180_af.func_187225_a(PEARL_TIMER);
    }

    public void setPearlTimer(int count) {
        this.field_70180_af.func_187227_b(PEARL_TIMER, (Object)count);
    }

    public boolean getCanShootTendril() {
        return this.getTendrilCount() < 4 && this.getPearlTimer() <= 0;
    }

    public int getTendrilCount() {
        return (Integer)this.field_70180_af.func_187225_a(TENDRIL_COUNT);
    }

    public void setTendrilCount(int count) {
        this.field_70180_af.func_187227_b(TENDRIL_COUNT, (Object)count);
    }

    public void setJawAngle(int angle) {
        this.field_70180_af.func_187227_b(JAW_ANGLE, (Object)angle);
    }

    public int getJawAngle() {
        return (Integer)this.field_70180_af.func_187225_a(JAW_ANGLE);
    }

    public void setPlacedByPlayer(boolean placed) {
        this.placed_by_player = placed;
    }

    public boolean getPlacedByPlayer() {
        return this.placed_by_player;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setPlacedByPlayer(compound.func_74767_n("placed_by_player"));
        this.setContainedXP(compound.func_74762_e("xpStored"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("placed_by_player", this.getPlacedByPlayer());
        compound.func_74768_a("xpStored", this.getContainedXP());
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected float getProximityHorizontal() {
        return 4.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 2.0f;
    }

    @Override
    protected AxisAlignedBB proximityBox() {
        return new AxisAlignedBB(this.func_180425_c()).func_72314_b((double)this.getProximityHorizontal(), (double)this.getProximityVertical(), (double)this.getProximityHorizontal()).func_72317_d(0.0, (double)(this.getProximityVertical() + this.field_70131_O), 0.0);
    }

    @Override
    protected boolean canSneakPast() {
        return true;
    }

    @Override
    protected boolean checkSight() {
        return true;
    }

    @Override
    protected Entity getEntitySpawned() {
        return null;
    }

    @Override
    protected int getEntitySpawnCount() {
        return 0;
    }

    @Override
    protected boolean isSingleUse() {
        return false;
    }

    @Override
    protected int maxUseCount() {
        return 0;
    }

    static class EntityAIShootTendril
    extends EntityAIBase {
        EntityRockSnot parentEntity;
        EntityLivingBase target;

        public EntityAIShootTendril(EntityRockSnot parent) {
            this.parentEntity = parent;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.target = this.parentEntity.func_70638_az();
            if (this.target == null || this.parentEntity.func_184207_aI() || !this.parentEntity.getCanShootTendril()) {
                return false;
            }
            return this.parentEntity.spawnDelayCounter == 0;
        }

        public boolean func_75253_b() {
            return this.target != null && this.parentEntity.field_70718_bc <= 40 && this.parentEntity.getCanShootTendril() && this.parentEntity.spawnDelayCounter == 0 && !this.parentEntity.func_184207_aI();
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
            if (!this.parentEntity.func_130014_f_().field_72995_K && this.target != null) {
                double targetX = this.target.field_70165_t - this.parentEntity.field_70165_t;
                double targetY = this.target.func_174813_aQ().field_72338_b + (double)(this.target.field_70131_O / 2.0f) - (this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                double targetZ = this.target.field_70161_v - this.parentEntity.field_70161_v;
                EntityRockSnotTendril grabber = new EntityRockSnotTendril(this.parentEntity);
                grabber.func_70634_a(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u + (double)this.parentEntity.field_70131_O * 0.5, this.parentEntity.field_70161_v);
                grabber.moveToTarget(targetX, targetY, targetZ, 0.3f);
                this.parentEntity.func_130014_f_().func_72838_d((Entity)grabber);
                this.parentEntity.func_130014_f_().func_184133_a(null, this.parentEntity.func_180425_c(), (SoundEvent)SoundRegistry.ROCK_SNOT_ATTACK, SoundCategory.HOSTILE, 1.0f, 1.0f);
                if (!grabber.getExtending()) {
                    grabber.setExtending(true);
                }
                this.parentEntity.setTendrilCount(this.parentEntity.getTendrilCount() + 1);
                this.parentEntity.spawnDelayCounter = 10;
            }
        }

        public void func_75251_c() {
            this.target = null;
        }
    }
}

